/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.overlay;

import com.kms.katalon.composer.components.ComponentBundleActivator;
import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.overlay.Popover;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.FontUtil;
import com.kms.katalon.composer.components.util.StyleContext;
import com.kms.katalon.composer.resources.image.ImageManager;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class GuidingPopover
extends Popover {
    private boolean useNextButton = false;
    private boolean useFinishButton = false;
    private int numSteps;
    private int curStepIndex;
    private String title;
    private String iconPath;
    private BeforeCloseConfirmation beforeClose;
    private int marginLeftXButton;
    private Listener onNextListener;

    public GuidingPopover(Shell parent, String title, Widget target) {
        this(parent, title, target, 0);
        this.MAX_CONTENT_WIDTH = 420;
    }

    public GuidingPopover(Shell parent, String title, Widget target, int style) {
        super(parent, target, 0, style, true);
        this.title = title;
        this.MAX_CONTENT_WIDTH = 420;
    }

    public GuidingPopover(Shell parent, String title, Widget target, int style, int position) {
        super(parent, target, style, position, true);
        this.title = title;
        this.MAX_CONTENT_WIDTH = 420;
    }

    @Override
    protected void createContent(Composite parent) {
        StyleContext.begin();
        StyleContext.setBackground((Color)ColorUtil.ONBOARDING_BACKGROUND_COLOR);
        StyleContext.setColor((Color)ColorUtil.getTextWhiteColor());
        ComponentBuilder.fromGrid((Composite)parent).margin(0).gridVerticalSpacing(0).minWidth(ComponentUtil.applyZoom((int)250)).build();
        ComponentUtil.getGridLayout((Composite)parent).numColumns = 1;
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).fill().build();
        boolean hasTitle = StringUtils.isNotBlank((String)this.title);
        Composite header = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).fillHorizontal().margin(10, this.marginLeftXButton, hasTitle ? 15 : 0, 30).build();
        Composite titleContainer = (Composite)ComponentBuilder.gridContainer((Composite)header).marginTop(hasTitle ? 15 : 0).marginRight(5).fillHorizontal().build();
        StyledText styledText = new StyledText(titleContainer, 72);
        GuidingPopover.applyHtmlBoldTags(styledText, this.title);
        styledText.setFont(FontUtil.H4);
        styledText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(16384, 0x1000000).create());
        styledText.setBackground(titleContainer.getBackground());
        styledText.setEditable(false);
        styledText.setCaret(null);
        ComponentBuilder.canvas((Composite)header).text("\u00d7").background(ColorUtil.ONBOARDING_BACKGROUND_COLOR).color(ColorUtil.GRAY_COLOR).autoSize(20, 20).font(FontUtil.H2).top().onClick(event -> {
            this.setReturnCode(12);
            if (this.getBeforeClose() != null && !this.getBeforeClose().call()) {
                return;
            }
            this.close();
        }).build();
        boolean isContainActionButton = this.useNextButton || this.useFinishButton;
        boolean hasIcon = StringUtils.isNotBlank((String)this.iconPath);
        if (hasIcon) {
            Composite iconContainer = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().build();
            ComponentUtil.setMargin((Composite)iconContainer, (int)0, (int)30, (int)(isContainActionButton ? 10 : 20), (int)30);
            Composite iconLeftContainer = (Composite)ComponentBuilder.gridContainer((Composite)iconContainer).left().build();
            Image swtImage = ImageManager.getImage((String)this.iconPath);
            if (swtImage != null) {
                ComponentBuilder.image((Composite)iconLeftContainer, (String)this.iconPath).autoSize(48, 48).build();
            }
        }
        if (isContainActionButton) {
            Composite buttonContainer = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().build();
            ComponentUtil.setMargin((Composite)buttonContainer, (int)0, (int)15, (int)20, (int)30);
            Color backgroundColor = this.useFinishButton ? ColorUtil.WHITE_COLOR : ColorUtil.ONBOARDING_BACKGROUND_COLOR;
            Color textColor = this.useFinishButton ? ColorUtil.BLACK_COLOR : ColorUtil.WHITE_COLOR;
            Color hoverButtonColor = this.useFinishButton ? ColorUtil.GRAY_BADGE_HOVER_COLOR : ColorUtil.ONBOARDING_BACKGROUND_COLOR_HOVER;
            String text = this.useFinishButton ? ComposerComponentsImplMessageConstants.POPOVER_FINISH : ComposerComponentsImplMessageConstants.POPOVER_NEXT;
            ComponentBuilder.canvas((Composite)buttonContainer).text(text).background(backgroundColor).font(FontUtil.H4).hoverBackground(hoverButtonColor).borderRadius(5).borderColor(ColorUtil.WHITE_COLOR).color(textColor).borderWidth(1).autoSize(70, 25).left().noFillHorizontal().onClick(event -> {
                this.onClickNextHandleEvent();
                this.setReturnCode(0);
                this.close();
            }).build();
        }
        container.pack();
        Point size = container.getSize();
        if (size.x > this.MAX_CONTENT_WIDTH) {
            ComponentUtil.setChildrenWidth((Composite)container, (int)this.MAX_CONTENT_WIDTH);
        } else if (ComponentBundleActivator.isDarkTheme((Display)Display.getCurrent())) {
            ComponentUtil.setChildrenWidth((Composite)container, (int)size.x);
        }
        StyleContext.end();
    }

    private void onClickNextHandleEvent() {
        if (this.onNextListener != null) {
            this.onNextListener.handleEvent(null);
        }
    }

    public int getNumSteps() {
        return this.numSteps;
    }

    public void setNumSteps(int numSteps) {
        this.numSteps = numSteps;
    }

    public int getCurStepIndex() {
        return this.curStepIndex;
    }

    public void setCurStepIndex(int curStepIndex) {
        this.curStepIndex = curStepIndex;
    }

    public boolean isUseNextButton() {
        return this.useNextButton;
    }

    public void setUseNextButton(boolean useNextButton) {
        this.useNextButton = useNextButton;
    }

    public void setUseFinishButton(boolean useFinishButton) {
        this.useFinishButton = useFinishButton;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public BeforeCloseConfirmation getBeforeClose() {
        return this.beforeClose;
    }

    public void setBeforeClose(BeforeCloseConfirmation beforeClose) {
        this.beforeClose = beforeClose;
    }

    public int getMarginLeftXButton() {
        return this.marginLeftXButton;
    }

    public void setMarginLeftXButton(int marginLeftXButton) {
        this.marginLeftXButton = marginLeftXButton;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public Listener getOnNextListener() {
        return this.onNextListener;
    }

    public void setOnNextListener(Listener onNextListener) {
        this.onNextListener = onNextListener;
    }

    public static void applyHtmlBoldTags(StyledText styledText, String htmlText) {
        if (htmlText == null || styledText == null) {
            return;
        }
        Color whiteColor = Display.getCurrent().getSystemColor(1);
        StringBuilder plainText = new StringBuilder();
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        int currentPos = 0;
        int plainTextPos = 0;
        while (currentPos < htmlText.length()) {
            int boldStart = htmlText.indexOf("<b>", currentPos);
            if (boldStart == -1) {
                String remainingText = htmlText.substring(currentPos);
                plainText.append(remainingText);
                if (remainingText.isEmpty()) break;
                StyleRange normalRange = new StyleRange();
                normalRange.start = plainTextPos;
                normalRange.length = remainingText.length();
                normalRange.foreground = whiteColor;
                styleRanges.add(normalRange);
                break;
            }
            String beforeBold = htmlText.substring(currentPos, boldStart);
            plainText.append(beforeBold);
            if (!beforeBold.isEmpty()) {
                StyleRange normalRange = new StyleRange();
                normalRange.start = plainTextPos;
                normalRange.length = beforeBold.length();
                normalRange.foreground = whiteColor;
                styleRanges.add(normalRange);
            }
            plainTextPos += beforeBold.length();
            int boldContentStart = boldStart + 3;
            int boldEnd = htmlText.indexOf("</b>", boldContentStart);
            if (boldEnd == -1) {
                String restText = htmlText.substring(boldStart);
                plainText.append(restText);
                StyleRange normalRange = new StyleRange();
                normalRange.start = plainTextPos;
                normalRange.length = restText.length();
                normalRange.foreground = whiteColor;
                styleRanges.add(normalRange);
                break;
            }
            String boldContent = htmlText.substring(boldContentStart, boldEnd);
            int boldContentLength = boldContent.length();
            plainText.append(boldContent);
            StyleRange boldRange = new StyleRange();
            boldRange.start = plainTextPos;
            boldRange.length = boldContentLength;
            boldRange.fontStyle = 1;
            boldRange.foreground = whiteColor;
            styleRanges.add(boldRange);
            plainTextPos += boldContentLength;
            currentPos = boldEnd + 4;
        }
        styledText.setText(plainText.toString());
        for (StyleRange range : styleRanges) {
            styledText.setStyleRange(range);
        }
    }

    public static interface BeforeCloseConfirmation {
        public boolean call();
    }
}

