/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.overlay;

import com.kms.katalon.composer.components.impl.overlay.HighlightArea;
import com.kms.katalon.composer.components.impl.overlay.OverlayShell;
import com.kms.katalon.composer.components.util.AnimationUtil;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.UITimeUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class HighlightOverlay
extends OverlayShell {
    protected Shell blockShell;
    protected Map<Widget, HighlightArea> highlightAreas = new HashMap<Widget, HighlightArea>();
    protected Region mainRegion;
    protected int focusShellAlpha = 255;
    protected int contentShellAlpha = 200;
    protected int overlayAlpha = 200;
    protected long animationDuration = 500L;
    protected boolean isShowOverlay = true;
    protected boolean ignoreFocusRegion = false;

    public HighlightOverlay(Control target) {
        this(target, 0);
    }

    public HighlightOverlay(Control target, int style) {
        super((Control)target.getShell());
        ComponentEventUtil.onClick((Widget)this, event -> this.highlight());
    }

    @Override
    public void open() {
        super.open();
        AnimationUtil.fadeIn((Shell)this, (long)this.animationDuration, (int)this.overlayAlpha);
        this.highlightAreas.forEach((control, area) -> this.animateArea((HighlightArea)area));
        if (!ControlUtil.isDisposed((Widget)this.blockShell)) {
            this.blockShell.setVisible(false);
        }
    }

    public void openSync() {
        this.open();
        while (!this.isDisposed() && this.isVisible()) {
            if (this.getDisplay().readAndDispatch()) continue;
            this.getDisplay().sleep();
        }
    }

    @Override
    public void close() {
        this.highlightAreas.forEach((control, area) -> area.dispose());
        if (!ControlUtil.isDisposed((Widget)this.blockShell)) {
            this.blockShell.dispose();
        }
        this.getParent().getShell().forceActive();
        AnimationUtil.fadeOut((Shell)this, (long)this.animationDuration);
        UITimeUtil.setTimeout(() -> {
            if (!this.isDisposed()) {
                super.close();
            }
        }, (long)this.animationDuration);
    }

    private void animateArea(HighlightArea area) {
        AnimationUtil.fadeIn((Shell)area.getFocusShell(), (int)this.focusShellAlpha);
        AnimationUtil.fadeIn((Shell)area.getContentShell(), (int)this.contentShellAlpha);
    }

    public void add(Widget control) {
        this.add(control, "");
    }

    public void add(Widget control, HighlightArea.HighlightAreaProvider highlightAreaProvider) {
        this.add(control, "", highlightAreaProvider);
    }

    public void add(Widget control, boolean focus) {
        this.add(control, null, focus);
    }

    public void add(Widget control, String text) {
        this.add(control, text, null);
    }

    public void add(Widget control, String text, HighlightArea.HighlightAreaProvider highlightAreaProvider) {
        this.add(control, text, true, highlightAreaProvider);
    }

    public void add(Widget control, String text, boolean focus) {
        this.add(control, text, focus, null);
    }

    public void add(Widget control, String text, boolean focus, HighlightArea.HighlightAreaProvider highlightAreaProvider) {
        if (ControlUtil.isDisposed((Widget)control) || this.isDisposed()) {
            return;
        }
        HighlightArea highlightArea = new HighlightArea(control, text, true, focus, true);
        highlightArea.setHighlightAreaProvider(highlightAreaProvider);
        highlightArea.setIgnoreFocusRegion(this.ignoreFocusRegion);
        highlightArea.attach(this);
        this.highlightAreas.put(control, highlightArea);
        highlightArea.onTargetChange(event -> this.redraw());
        if (this.isShowing()) {
            this.redraw();
            this.animateArea(highlightArea);
        }
    }

    public void remove(Widget control) {
        if (!this.highlightAreas.containsKey(control)) {
            return;
        }
        this.highlightAreas.get(control).dispose();
        this.highlightAreas.remove(control);
        if (this.isShowing()) {
            this.redraw();
        }
    }

    public void removeAll() {
        this.highlightAreas.forEach((control, area) -> area.dispose());
        this.highlightAreas.clear();
        if (this.isShowing()) {
            this.redraw();
        }
    }

    @Override
    protected void reposition() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.target.isVisible()) {
            this.setBounds(ZERO_BOUNDS);
            return;
        }
        Rectangle targetArea = ComponentUtil.getScreenArea((Widget)this.target);
        if (this.isShowOverlay || SystemUtils.IS_OS_MAC) {
            this.setBounds(targetArea);
        } else {
            this.setBounds(targetArea.x, targetArea.y, 0, 0);
        }
        this.redraw();
    }

    public void redraw() {
        if (this.isDisposed()) {
            return;
        }
        if (this.isShowOverlay) {
            Region visibleRegion = this.generateVisibleRegion();
            this.setRegion(visibleRegion);
            visibleRegion.dispose();
        } else if (SystemUtils.IS_OS_MAC) {
            this.setAlpha(1);
        } else {
            this.setBounds(ZERO_BOUNDS);
        }
        this.renderHighlightAreas();
    }

    protected Region generateVisibleRegion() {
        Region visibleRegion = new Region();
        Rectangle clientArea = ComponentUtil.getClientArea((Widget)this.target);
        if (clientArea == null) {
            return null;
        }
        visibleRegion.add(clientArea);
        this.highlightAreas.forEach((control, area) -> area.computeRegion(visibleRegion));
        return visibleRegion;
    }

    protected void renderHighlightAreas() {
        this.highlightAreas.forEach((control, area) -> area.renderFocusRegion());
    }

    public void highlight() {
        if (!this.isDisposed()) {
            this.highlightAreas.forEach((control, area) -> area.highlight());
        }
    }

    @Override
    public void setAlpha(int alpha) {
        this.overlayAlpha = alpha;
        if (this.isShowing()) {
            super.setAlpha(this.overlayAlpha);
        }
    }

    public int getAlpha() {
        return this.overlayAlpha;
    }

    public boolean isBlockingUI() {
        return this.isShowOverlay;
    }

    public void setBlockingUI(boolean isBlockingUI) {
        this.isShowOverlay = isBlockingUI;
    }

    public boolean ignoreFocusRegion() {
        return this.ignoreFocusRegion;
    }

    public void setIgnoreFocusRegion(boolean ignoreFocusRegion) {
        this.ignoreFocusRegion = ignoreFocusRegion;
    }
}

