/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.providers;

import com.kms.katalon.composer.components.impl.providers.MouseCursorColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public abstract class HoveredImageColumnLabelProvider<T>
extends MouseCursorColumnLabelProvider<T> {
    public HoveredImageColumnLabelProvider(int columnIndex) {
        super(columnIndex);
    }

    @Override
    public void initialize(ColumnViewer viewer, ViewerColumn column) {
        super.initialize(viewer, column);
        this.registerMouseListener(viewer);
    }

    private void registerMouseListener(ColumnViewer viewer) {
        Control table = this.getControl(viewer);
        final ImageHoveredListener mouseMoveListener = new ImageHoveredListener();
        table.addMouseMoveListener((MouseMoveListener)mouseMoveListener);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Control control = (Control)e.getSource();
                control.removeMouseMoveListener((MouseMoveListener)mouseMoveListener);
            }
        });
    }

    @Override
    protected void drawCellTextAndImage(Event event, ViewerCell cell, GC gc) {
        boolean shouldShowCursor = this.shouldShowCursor(cell, cell.getControl().toControl(event.display.getCursorLocation()));
        cell.setImage(shouldShowCursor ? this.getHoveredImage(cell.getElement()) : this.getImage(cell.getElement()));
        super.drawCellTextAndImage(event, cell, gc);
    }

    protected abstract Image getHoveredImage(T var1);

    private final class ImageHoveredListener
    implements MouseMoveListener {
        private ViewerCell lastFocusedIn;

        private ImageHoveredListener() {
        }

        public void mouseMove(MouseEvent e) {
            ColumnViewer viewer = HoveredImageColumnLabelProvider.this.getViewer();
            if (viewer == null) {
                return;
            }
            Point currentMouseLocation = new Point(e.x, e.y);
            ViewerCell cell = viewer.getCell(currentMouseLocation);
            try {
                if (!HoveredImageColumnLabelProvider.this.isPlacedMouseHover(cell) || !HoveredImageColumnLabelProvider.this.shouldShowCursor(cell, currentMouseLocation)) {
                    cell = null;
                    return;
                }
            }
            finally {
                if (this.lastFocusedIn == cell) {
                    return;
                }
                if (this.lastFocusedIn != null) {
                    HoveredImageColumnLabelProvider.this.getViewer().refresh(this.lastFocusedIn.getElement());
                }
                if (cell != null) {
                    HoveredImageColumnLabelProvider.this.getViewer().refresh(cell.getElement());
                }
                this.lastFocusedIn = cell;
            }
        }
    }
}

