/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.table;

import com.kms.katalon.composer.components.impl.editors.SingleFileSelectionDialogCellEditor;
import com.kms.katalon.composer.components.impl.table.CustomColumn;
import com.kms.katalon.composer.components.impl.table.CustomColumnType;
import com.kms.katalon.composer.components.impl.table.GenericTransfer;
import com.kms.katalon.composer.components.impl.table.SelectCellEditor;
import com.kms.katalon.composer.components.impl.util.CommonInterfaces;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.core.util.ObjectUtil;
import com.kms.katalon.core.webui.util.OSUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class CustomTable<ItemType>
extends Composite {
    private TableViewer tableViewer;
    private CustomTable<ItemType> _this = this;
    public CommonInterfaces.ValueProvider<ItemType> newRowProvider;
    public CommonInterfaces.CloneProvider<ItemType> cloneProvider;

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public CustomTable(Composite parent, int style) {
        super(parent, 0);
        this.create(this, style);
    }

    protected void create(Composite parent, int style) {
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        parent.setLayout((Layout)tableColumnLayout);
        this.initTable(parent, style);
    }

    protected void initTable(Composite parent, int style) {
        this.tableViewer = new TableViewer(parent, style | 0x800 | 0x10000 | 2 | 0x100 | 0x200);
        this.configTable();
        this.configDND();
        this.configShortcutKeys();
    }

    protected void configTable() {
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        final Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                Point curPos = new Point(event.x, event.y);
                CustomColumn column = CustomTable.this.getColumn(curPos);
                if (column != null) {
                    ComponentUtil.setCursor((Control)CustomTable.this.getTable(), (int)column.cursorType);
                } else {
                    ComponentUtil.setCursorDefault((Control)CustomTable.this.getTable());
                }
            }
        });
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = table.getSelection();
                event.data = CustomTable.this.tableItemsToRows(selection);
                CustomTable.this._this.notifyListeners(13, event);
            }
        });
        table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                if (CustomTable.this.tableViewer.getSelection().isEmpty()) {
                    CustomTable.this._this.addEmptyRow();
                }
            }
        });
        table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point curPos = new Point(event.x, event.y);
                TableItem item = CustomTable.this.getTable().getItem(curPos);
                if (item == null) {
                    CustomTable.this.tableViewer.setSelection(null);
                }
                CustomColumn column = CustomTable.this.getColumn(curPos);
                event.data = item != null ? item.getData() : null;
                CustomTable.this.dispatchColumnEvent(column, event, 13);
            }
        });
        table.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                CustomTable.this._this.showContextMenu(event);
            }
        });
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                boolean isCheckColumn;
                CustomColumn column = CustomTable.this.getColumn(event.index);
                Object row = event.item.getData();
                Object value = CustomTable.this.getField(row, column);
                boolean bl = isCheckColumn = value != null && value.getClass() == Boolean.class;
                if (isCheckColumn && column.align == 0x1000000) {
                    Image tmpImage = (Boolean)value != false ? ImageManager.getImage((String)"checkbox_checked_16.png") : ImageManager.getImage((String)"checkbox_unchecked_16.png");
                    int tmpWidth = 0;
                    int tmpHeight = 0;
                    int tmpX = 0;
                    int tmpY = 0;
                    tmpWidth = table.getColumn(event.index).getWidth();
                    tmpHeight = ((TableItem)event.item).getBounds().height;
                    tmpX = tmpImage.getBounds().width;
                    tmpX = tmpWidth / 2 - tmpX / 2;
                    tmpY = tmpImage.getBounds().height;
                    tmpY = tmpHeight / 2 - tmpY / 2;
                    tmpX = tmpX <= 0 ? event.x : (tmpX += event.x);
                    tmpY = tmpY <= 0 ? event.y : (tmpY += event.y);
                    event.gc.drawImage(tmpImage, tmpX, tmpY);
                }
            }
        });
    }

    protected void configShortcutKeys() {
        this.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent event) {
            }

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    CustomTable.this.removeSelectedRows();
                }
            }
        });
    }

    protected void configDND() {
        Transfer[] types = new Transfer[]{GenericTransfer.create(TableItem.class)};
        this.tableViewer.addDragSupport(2, types, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                DragSource dragSource = (DragSource)event.widget;
                Table table = (Table)dragSource.getControl();
                event.data = table.getSelectionIndices();
                if (OSUtil.isMacBigSurOrLater()) {
                    CustomTable.this.tableViewer.getTable().redraw();
                }
            }
        });
        this.tableViewer.addDropSupport(2, types, (DropTargetListener)new ViewerDropAdapter((Viewer)this.tableViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return true;
            }

            public boolean performDrop(Object data) {
                DropTargetEvent event = this.getCurrentEvent();
                List rows = CustomTable.this.getRows();
                int[] selectedIndexes = (int[])data;
                List selectedItems = Arrays.stream(selectedIndexes).mapToObj(indexI -> rows.get(indexI)).collect(Collectors.toList());
                int targetIndex = 0;
                if (event.item != null) {
                    Object targetItem = ((TableItem)event.item).getData();
                    targetIndex = rows.indexOf(targetItem);
                } else {
                    DropTarget dropTarget = (DropTarget)event.widget;
                    Table table = (Table)dropTarget.getControl();
                    Point coordinates = table.toControl(new Point(event.x, event.y));
                    boolean isDropToBody = coordinates.y > table.getHeaderHeight();
                    int n = targetIndex = isDropToBody ? rows.size() : 0;
                }
                if (selectedIndexes[0] < targetIndex && event.item != null) {
                    ++targetIndex;
                }
                CustomTable.this.insertRows(selectedItems, targetIndex);
                return true;
            }
        });
    }

    public void showContextMenu(Event event) {
        MenuItem removeMenuItem;
        final Table table = this.tableViewer.getTable();
        int numSelectedItems = table.getSelectionCount();
        Menu menu = table.getMenu();
        if (menu != null) {
            menu.dispose();
        }
        menu = new Menu((Control)table);
        MenuItem insertMenuItem = new MenuItem(menu, 8);
        insertMenuItem.setText(GlobalMessageConstants.INSERT);
        insertMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = table.getSelection();
                int targetIndex = items.length > 0 ? table.indexOf(items[0]) : -1;
                CustomTable.this._this.addEmptyRow(targetIndex);
            }
        });
        if (numSelectedItems > 0) {
            removeMenuItem = new MenuItem(menu, 8);
            removeMenuItem.setText(GlobalMessageConstants.REMOVE);
            removeMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomTable.this._this.removeSelectedRows();
                }
            });
        }
        if (numSelectedItems > 0) {
            removeMenuItem = new MenuItem(menu, 8);
            removeMenuItem.setText(GlobalMessageConstants.DUPLICATE);
            removeMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomTable.this._this.duplicateSelectedRows();
                }
            });
        }
        table.setMenu(menu);
    }

    public void addEmptyRow() {
        this.addEmptyRow(-1);
    }

    public void addEmptyRow(int index) {
        if (this.newRowProvider != null) {
            ItemType newItem = this.newRowProvider.call();
            if (index >= 0) {
                this.tableViewer.insert(newItem, index);
            } else {
                this.tableViewer.add(newItem);
            }
            this.tableViewer.editElement(newItem, 0);
            this.setRows(this.getRows());
            this.notifyListeners(24, null);
        }
    }

    public void setRows(List<ItemType> rows) {
        this.tableViewer.setInput(rows);
        if (OSUtil.isMacBigSurOrLater()) {
            this.tableViewer.getTable().redraw();
        }
    }

    public List<ItemType> getRows() {
        return this.tableItemsToRows(this.tableViewer.getTable().getItems());
    }

    public void removeSelectedRows() {
        Object[] selections = this.tableViewer.getStructuredSelection().toArray();
        List<Object> selectionObjects = Arrays.asList(selections);
        List<ItemType> rows = this.getRows();
        rows.removeAll(selectionObjects);
        this.setRows(rows);
        this.notifyListeners(24, null);
    }

    public void duplicateSelectedRows() {
        Object[] selections = this.tableViewer.getStructuredSelection().toArray();
        if (selections.length <= 0) {
            return;
        }
        List rows = this.getRows();
        int targetIndex = Arrays.stream(selections).map(itemI -> rows.indexOf(itemI)).max(Comparator.comparing(Integer::intValue)).get() + 1;
        List clones = Arrays.stream(selections).map(selectionI -> {
            Object clone = null;
            clone = this.cloneProvider != null ? this.cloneProvider.clone(selectionI) : ObjectUtil.clone((Object)selectionI);
            return clone;
        }).filter(cloneI -> cloneI != null).collect(Collectors.toList());
        this.insertRows(clones, targetIndex);
    }

    public void insertRows(List<ItemType> newRows, int targetIndex) {
        List<ItemType> rows = this.getRows();
        ArrayList<ItemType> beforeRows = new ArrayList<ItemType>(rows.subList(0, targetIndex));
        ArrayList<ItemType> afterRows = new ArrayList<ItemType>(rows.subList(targetIndex, rows.size()));
        beforeRows.removeIf(rowI -> newRows.contains(rowI));
        afterRows.removeIf(rowI -> newRows.contains(rowI));
        List finalRows = Stream.of(beforeRows, newRows, afterRows).flatMap(Collection::stream).collect(Collectors.toList());
        this.setRows(finalRows);
        this.notifyListeners(24, null);
    }

    public void hideColumn(int ... indexes) {
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableColumn column = this.getTable().getColumn(index);
            int columnWidth = column.getWidth();
            if (columnWidth > 0) {
                column.setData("control.width", (Object)columnWidth);
                column.setWidth(0);
            }
            ++n2;
        }
    }

    public void showColumn(int ... indexes) {
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableColumn column = this.getTable().getColumn(index);
            Object width = column.getData("control.width");
            if (width != null) {
                column.setWidth(((Integer)width).intValue());
            }
            ++n2;
        }
    }

    public <ColumnType> void createColumn(final CustomColumn<ItemType, ColumnType> column) {
        final TableViewerColumn columnViewer = new TableViewerColumn(this.tableViewer, column.align);
        TableColumn tableColumn = columnViewer.getColumn();
        final Table table = this.tableViewer.getTable();
        tableColumn.setText(column.headerName);
        tableColumn.setData(column);
        columnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object item) {
                Object value = CustomTable.this.getField(item, column);
                if (value != null && value.getClass() == Boolean.class) {
                    return "";
                }
                String viewValue = "";
                viewValue = column.cellRenderer != null ? column.cellRenderer.render(value, item) : (value != null ? value.toString() : viewValue);
                return viewValue;
            }

            public Color getForeground(Object item) {
                boolean disabled = false;
                disabled = column.disabledProvider != null ? column.disabledProvider.get(item) : column.disabled;
                if (disabled) {
                    return ColorUtil.getDisabledTextColor();
                }
                if (column.colorProvider != null) {
                    return column.colorProvider.get(item);
                }
                return column.color != null ? column.color : super.getForeground(item);
            }
        });
        columnViewer.setEditingSupport(new EditingSupport(columnViewer.getViewer()){

            protected void setValue(Object item, Object value) {
                TableColumn tableColumn = columnViewer.getColumn();
                Event modifyEvent = ComponentEventUtil.generateEvent((Widget)tableColumn, (int)24);
                modifyEvent.data = value;
                CustomTable.this.dispatchColumnEvent(column, modifyEvent);
                ComponentEventUtil.trigger(CustomTable.this._this, (int)24, (Event)modifyEvent);
                if (!column.readyToUpdate) {
                    return;
                }
                CustomTable.this.setField(item, value, column);
                CustomTable.this.tableViewer.update(item, null);
                CustomTable.this.tableViewer.refresh(true);
            }

            protected CellEditor getCellEditor(Object item) {
                return CustomTable.this.getSmartCellEditor(table, item, column);
            }

            protected boolean canEdit(Object item) {
                if (column.editableProvider != null) {
                    return column.editableProvider.get(item);
                }
                return column.editable;
            }

            protected Object getValue(Object item) {
                return CustomTable.this.getField(item, column);
            }
        });
    }

    private <ColumnType> CellEditor getSmartCellEditor(Table table, Object item, CustomColumn<ItemType, ColumnType> column) {
        Object sampleValue;
        CellEditor editor = null;
        if (column.editorRenderer != null && (editor = column.editorRenderer.render(table)) != null) {
            return editor;
        }
        CustomColumnType editorType = column.editorType;
        if (column.editorTypeProvider != null) {
            editorType = column.editorTypeProvider.get(item);
        }
        if (editorType != null) {
            switch (editorType) {
                case FILE: {
                    return new SingleFileSelectionDialogCellEditor((Composite)table, GlobalMessageConstants.BROWSE);
                }
            }
            return new TextCellEditor((Composite)table);
        }
        if (column.options != null) {
            return new SelectCellEditor<Object>((Composite)table, column.options.toArray());
        }
        Class<?> type = null;
        if (column.type != null) {
            type = column.type;
        } else if (StringUtils.isNotBlank((String)column.field)) {
            Field field = ObjectUtil.findField((Object)item, (String)column.field);
            type = field.getType();
        } else if (column.getter != null && (sampleValue = column.getter.get(item)) != null) {
            type = sampleValue.getClass();
        }
        if (type != null && type.isEnum()) {
            return new SelectCellEditor((Composite)table, type.getEnumConstants());
        }
        if (type == Boolean.class) {
            return new CheckboxCellEditor((Composite)table);
        }
        return new TextCellEditor((Composite)table);
    }

    private <ColumnType> Object getField(Object item, CustomColumn<ItemType, ColumnType> column) {
        if (column.getter != null) {
            return column.getter.get(item);
        }
        if (StringUtils.isNotBlank((String)column.field)) {
            return ObjectUtil.getField((Object)item, (String)column.field);
        }
        return null;
    }

    private <ColumnType> void setField(Object item, Object value, CustomColumn<ItemType, ColumnType> column) {
        if (column.setter != null) {
            column.setter.set(item, value);
        } else if (StringUtils.isNotBlank((String)column.field)) {
            ObjectUtil.setField((Object)item, (String)column.field, (Object)value);
        }
    }

    public List<ItemType> tableItemsToRows(TableItem[] items) {
        return Arrays.stream(items).map(tableItemI -> tableItemI.getData()).collect(Collectors.toList());
    }

    public Set<Listener> getColumnListeners(CustomColumn column, int event) {
        if (column == null || column.listeners == null) {
            return Collections.emptySet();
        }
        if (column.listeners.containsKey(event)) {
            return column.listeners.get(event);
        }
        return Collections.emptySet();
    }

    public void dispatchColumnEvent(CustomColumn column, Event event, int eventType) {
        event.type = eventType;
        this.dispatchColumnEvent(column, event);
    }

    public void dispatchColumnEvent(CustomColumn column, Event event) {
        Set<Listener> listeners = this.getColumnListeners(column, event.type);
        ComponentEventUtil.dispatchEvent(listeners, (Event)event);
    }

    private CustomColumn getColumn(Point position) {
        ViewerCell cell = this.tableViewer.getCell(position);
        if (cell == null) {
            return null;
        }
        int columnIndex = cell.getColumnIndex();
        return this.getColumn(columnIndex);
    }

    private CustomColumn getColumn(int columnIndex) {
        TableColumn tableColumn = this.getTable().getColumn(columnIndex);
        CustomColumn column = (CustomColumn)tableColumn.getData();
        return column;
    }
}

