/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.thread;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.IImportExportController;
import com.kms.katalon.entity.dal.exception.CancelTaskException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImportExportProgressThread
implements IRunnableWithProgress {
    private int maxProgress;
    private IImportExportController importExportController;
    private Logger logger;

    public ImportExportProgressThread(int maxProgress, IImportExportController importExportController) {
        this.maxProgress = maxProgress;
        this.importExportController = importExportController;
        this.logger = LoggerSingleton.getInstance().getLogger();
    }

    public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Thread progressThread = null;
        try {
            try {
                monitor.beginTask(this.importExportController.getDisplayText(), this.maxProgress);
                progressThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int progress = 0;
                            while (progress < ImportExportProgressThread.this.maxProgress) {
                                Thread.sleep(100L);
                                int newProgress = ImportExportProgressThread.this.importExportController.getProgress();
                                if (newProgress > progress) {
                                    monitor.worked(newProgress - progress);
                                    progress = newProgress;
                                }
                                if (monitor.isCanceled()) {
                                    ImportExportProgressThread.this.importExportController.cancel();
                                } else if (!Thread.currentThread().isInterrupted()) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                        catch (Exception e) {
                            ImportExportProgressThread.this.logger.error((Throwable)e);
                        }
                    }
                });
                progressThread.start();
                this.importExportController.execute();
            }
            catch (CancelTaskException cancelTaskException) {
                if (progressThread != null && progressThread.isAlive()) {
                    progressThread.interrupt();
                }
                monitor.done();
            }
            catch (Exception e) {
                block10: {
                    this.logger.error((Throwable)e);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)StringConstants.ERROR, (String)e.getMessage());
                        }
                    });
                    if (progressThread == null || !progressThread.isAlive()) break block10;
                    progressThread.interrupt();
                }
                monitor.done();
            }
        }
        finally {
            if (progressThread != null && progressThread.isAlive()) {
                progressThread.interrupt();
            }
            monitor.done();
        }
    }
}

