/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.module.ModuleDescriptor;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.core.runtime.Platform;

public class PlatformUtil {
    private static final String BROWSE_NAME_GOOGLE_CHROME_ON_LINUX = "google-chrome-stable";
    private static final String BROWSER_NAME_FIREFOX_ON_LINUX = "firefox";
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static final String VERSION = System.getProperty("os.version").toLowerCase();
    private static final String WINDOWS_10_VERSION_PREFIX = "10";
    private static final String REG_SZ = "REG_SZ";
    private static final String BROWSER_NAME_GOOGLE_CHROME = "Google Chrome";
    private static final String BROWSER_NAME_FIREFOX = "Firefox";
    private static final String BROWSER_NAME_SAFARI = "Safari";

    public static boolean isFirefoxInstalled() {
        if (PlatformUtil.isMacOS()) {
            return PlatformUtil.isBrowserInstalledOnMac(BROWSER_NAME_FIREFOX);
        }
        if (PlatformUtil.isWindowsOS()) {
            return PlatformUtil.isBrowserInstalledOnWindows(BROWSER_NAME_FIREFOX);
        }
        if (PlatformUtil.isLinux()) {
            return PlatformUtil.isBrowserInstalledOnLinux(BROWSER_NAME_FIREFOX_ON_LINUX);
        }
        return false;
    }

    public static boolean isChromeInstalled() {
        if (PlatformUtil.isMacOS()) {
            return PlatformUtil.isBrowserInstalledOnMac(BROWSER_NAME_GOOGLE_CHROME);
        }
        if (PlatformUtil.isWindowsOS()) {
            return PlatformUtil.isBrowserInstalledOnWindows(BROWSER_NAME_GOOGLE_CHROME);
        }
        if (PlatformUtil.isLinux()) {
            return PlatformUtil.isBrowserInstalledOnLinux(BROWSE_NAME_GOOGLE_CHROME_ON_LINUX);
        }
        return false;
    }

    public static boolean isBrowserInstalledOnLinux(String browserName) {
        try {
            Process process = Runtime.getRuntime().exec("which " + browserName);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            Optional<String> output = stdInput.lines().findFirst();
            return output.isPresent();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isSafariInstalled() {
        return PlatformUtil.isBrowserInstalledOnMac(BROWSER_NAME_SAFARI);
    }

    public static boolean isWindowsOS() {
        return "win32".equals(Platform.getOS());
    }

    public static boolean isWindows10() {
        return PlatformUtil.isWindowsOS() && StringUtils.startsWith((String)PlatformUtil.getOSVersion(), (String)WINDOWS_10_VERSION_PREFIX);
    }

    public static boolean isMacOS() {
        return "macosx".equals(Platform.getOS());
    }

    public static String getOSName() {
        return SystemUtils.OS_NAME;
    }

    public static String getOSVersion() {
        return SystemUtils.OS_VERSION;
    }

    private static boolean isBrowserInstalledOnWindows(String browserName) {
        if (!PlatformUtil.isWindowsOS()) {
            return false;
        }
        try {
            Process process = Runtime.getRuntime().exec("reg query \"HKLM\\SOFTWARE\\RegisteredApplications\" /v \"" + browserName + "*\"");
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            Optional<String> output = stdInput.lines().filter(line -> StringUtils.isNotEmpty((String)line)).filter(line -> line.contains(browserName) && line.contains(REG_SZ)).findFirst();
            return output.isPresent();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isBrowserInstalledOnMac(String browserName) {
        if (!PlatformUtil.isMacOS()) {
            return false;
        }
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"osascript", "-e", "version of app \"" + browserName + "\""});
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            Optional<String> output = stdInput.lines().filter(line -> StringUtils.isNotEmpty((String)line)).filter(line -> !line.contains("error")).findFirst();
            return output.isPresent();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isWindows() {
        return OS.contains("windows");
    }

    public static boolean isLinux() {
        return OS.contains("linux");
    }

    public static String getPlatform() {
        return String.format("%s-%s", Platform.getOS(), PlatformUtil.getArch());
    }

    public static String getArch() {
        return Platform.getOSArch();
    }

    public static boolean isSonomaOrLater() {
        if ("macosx".equals(Platform.getOS())) {
            return ModuleDescriptor.Version.parse(VERSION).compareTo(ModuleDescriptor.Version.parse("14.0")) >= 0;
        }
        return false;
    }
}

