/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.dal.setting.IDataProviderSetting;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public abstract class EntityController {
    private static IDataProviderSetting dataProviderSetting;

    protected EntityController() {
    }

    protected static IDataProviderSetting getDataProviderSetting() {
        if (dataProviderSetting == null) {
            EntityController.initDataProviderSetting();
        }
        return dataProviderSetting;
    }

    private static void initDataProviderSetting() {
        BundleContext bundleContext = FrameworkUtil.getBundle(EntityController.class).getBundleContext();
        IEclipseContext eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        dataProviderSetting = (IDataProviderSetting)eclipseContext.get(IDataProviderSetting.class);
    }

    public static String toValidFileName(String fileName) {
        fileName = fileName.replaceAll("[^A-Za-z0-9_()\\.\\-\\ ,]", "");
        fileName = fileName.replaceAll("[.]{2,}", ".");
        fileName = StringUtils.stripStart((String)fileName, (String)"\\.? *");
        fileName = StringUtils.stripEnd((String)fileName, (String)"\\.? *");
        return fileName;
    }

    public static String toXmlString(Object entity) throws Exception {
        return EntityController.getDataProviderSetting().getEntityDataProvider().toXmlString(entity);
    }
}

