/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.manager.impl;

import com.katalon.capability.constant.CapabilityStorageConstant;
import com.katalon.capability.exception.UnsupportedDriverTypeException;
import com.katalon.capability.exception.WriteCapabilityException;
import com.katalon.capability.exception.WriteCustomCapabilityException;
import com.katalon.capability.manager.ICustomCapabilityManager;
import com.katalon.capability.model.CustomCapabilitySetting;
import com.katalon.capability.repository.ICustomCapabilityRepository;
import com.kms.katalon.controller.ProjectController;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class CustomCapabilityManagerImpl
implements ICustomCapabilityManager {
    private final ICustomCapabilityRepository customCapabilityRepository;

    @Inject
    public CustomCapabilityManagerImpl(ICustomCapabilityRepository customCapabilityRepository) {
        this.customCapabilityRepository = customCapabilityRepository;
    }

    @Override
    public List<CustomCapabilitySetting> getAllCustomCapabilities() {
        return this.customCapabilityRepository.getAppCustomCapabilities();
    }

    @Override
    public void saveCustomCapabilities(List<CustomCapabilitySetting> customCapabilitySettings) throws IOException, WriteCustomCapabilityException, UnsupportedDriverTypeException, WriteCapabilityException {
        File customCapabilityRootFolder = new File(ProjectController.getInstance().getCurrentProject().getFolderLocation() + File.separator + CapabilityStorageConstant.EXTERNAL_SETTING_ROOT_FOLDER_NAME + File.separator + "execution");
        if (customCapabilityRootFolder.exists() && customCapabilityRootFolder.isDirectory()) {
            FileUtils.deleteDirectory((File)customCapabilityRootFolder);
        }
        for (CustomCapabilitySetting customCapabilitySetting : customCapabilitySettings) {
            this.customCapabilityRepository.saveCustomCapability(customCapabilityRootFolder, customCapabilitySetting);
        }
    }
}

