/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.repository.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.katalon.capability.constant.DriverType;
import com.katalon.capability.exception.WriteCapabilityException;
import com.katalon.capability.jackson.DriverTypeJacksonModule;
import com.katalon.capability.repository.ICapabilityRepository;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class CapabilityRepositoryImpl
implements ICapabilityRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapabilityRepositoryImpl.class);

    @Override
    public Map<DriverType, Map<String, Object>> readCapabilityMapFromFile(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists()) {
                String fileData = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
                ObjectMapper mapper = new ObjectMapper();
                mapper.registerModule((Module)new DriverTypeJacksonModule());
                Map capabilityMap = (Map)mapper.readValue(fileData, (TypeReference)new TypeReference<Map<DriverType, Map<String, Object>>>(){});
                if (capabilityMap == null) {
                    return new LinkedHashMap<DriverType, Map<String, Object>>();
                }
                for (Map.Entry entry : capabilityMap.entrySet()) {
                    this.convertSettingValue((Map)entry.getValue());
                }
                return capabilityMap;
            }
            return new LinkedHashMap<DriverType, Map<String, Object>>();
        }
        catch (Exception e) {
            LOGGER.error("Exception while readCapabilityMapFromFile | filePath = %s".formatted(filePath), (Throwable)e);
            return new LinkedHashMap<DriverType, Map<String, Object>>();
        }
    }

    @Override
    public void writeCapabilityMapToFile(String filePath, Map<DriverType, Map<String, Object>> data) throws IOException, WriteCapabilityException {
        File file = new File(filePath);
        if (!file.exists() && !file.createNewFile()) {
            throw new WriteCapabilityException("Failed to create capability file at: %s".formatted(filePath));
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new DriverTypeJacksonModule());
        FileUtils.writeStringToFile((File)file, (String)mapper.writeValueAsString(data), (Charset)Charset.defaultCharset());
    }

    @Override
    public Map<String, Object> readCapabilityValueFromFile(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists()) {
                ObjectMapper mapper = new ObjectMapper();
                String fileData = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
                Map capabilityValue = (Map)mapper.readValue(fileData, (TypeReference)new TypeReference<Map<String, Object>>(){});
                if (capabilityValue == null) {
                    return new LinkedHashMap<String, Object>();
                }
                this.convertSettingValue(capabilityValue);
                return capabilityValue;
            }
            return new LinkedHashMap<String, Object>();
        }
        catch (Exception e) {
            LOGGER.error("Exception while readCapabilityValueFromFile | filePath = %s".formatted(filePath), (Throwable)e);
            return new LinkedHashMap<String, Object>();
        }
    }

    @Override
    public void writeCapabilityValueToFile(String filePath, Map<String, Object> data) throws IOException {
        File exportFile = new File(filePath);
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        FileUtils.writeStringToFile((File)exportFile, (String)mapper.writeValueAsString(data), (Charset)Charset.defaultCharset());
    }

    private void convertSettingValue(Map<?, Object> mapData) {
        for (Map.Entry<?, Object> entry : mapData.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof List) {
                List listObject = (List)object;
                this.convertSettingValue(listObject);
                continue;
            }
            if (object instanceof Map) {
                Map mapObject = (Map)object;
                this.convertSettingValue(mapObject);
                continue;
            }
            if (!(object instanceof Double)) continue;
            Double doubleObject = (Double)object;
            entry.setValue((double)doubleObject);
        }
    }

    private void convertSettingValue(List<Object> list) {
        int i = 0;
        while (i < list.size()) {
            Object object = list.get(i);
            if (object instanceof List) {
                List listObject = (List)object;
                this.convertSettingValue(listObject);
            } else if (object instanceof Map) {
                Map mapObject = (Map)object;
                this.convertSettingValue(mapObject);
            } else if (object instanceof Double) {
                Double doubleObject = (Double)object;
                list.set(i, (double)doubleObject);
            }
            ++i;
        }
    }
}

