/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.testcloud.core.model;

import com.kms.katalon.testcloud.core.model.TestCloudBrowserVersion;
import com.kms.katalon.testcloud.core.model.TestCloudDesktopBrowser;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class TestCloudBrowser {
    private String browserName;
    private String browserDisplayName;
    private List<TestCloudBrowserVersion> versions = new ArrayList<TestCloudBrowserVersion>();

    public TestCloudBrowser(TestCloudDesktopBrowser environment) {
        this.setBrowserName(environment.getBrowserName());
        this.setBrowserDisplayName(environment.getBrowserDisplayName());
        this.addVersion(environment);
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    public String getBrowserDisplayName() {
        return StringUtils.capitalize((String)this.browserDisplayName.toLowerCase());
    }

    public void setBrowserDisplayName(String browserDisplayName) {
        this.browserDisplayName = browserDisplayName;
    }

    public List<TestCloudBrowserVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(List<TestCloudBrowserVersion> versions) {
        this.versions = versions;
    }

    public void addVersion(TestCloudDesktopBrowser environment) {
        Optional<TestCloudBrowserVersion> mappedVersion = this.versions.stream().filter(e -> e.getBrowserVersion().equalsIgnoreCase(environment.getBrowserName())).findFirst();
        if (!mappedVersion.isPresent()) {
            this.versions.add(new TestCloudBrowserVersion(environment));
        }
    }
}

