/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.testcloud.core.model;

import com.kms.katalon.testcloud.core.model.TestCloudEntity;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class TestCloudDesktopBrowser
extends TestCloudEntity {
    private int id;
    private String osDisplayName;
    private String browserName;
    private String browserDisplayName;
    private String browserVersion;
    private String browserVersionType;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public void setBrowserName(String browserName) {
        this.browserName = browserName.toLowerCase();
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    public String getBrowserVersionType() {
        if (Objects.isNull(this.browserVersionType)) {
            return "";
        }
        String result = this.browserVersionType.replaceAll("(?i)stable", "");
        return StringUtils.capitalize((String)result.toLowerCase());
    }

    public void setBrowserVersionType(String browserVersionType) {
        this.browserVersionType = browserVersionType;
    }

    public String getOsDisplayName() {
        if (Objects.isNull(this.osDisplayName)) {
            return "";
        }
        if (this.osDisplayName.toLowerCase().equals("macos") || this.osDisplayName.toLowerCase().equals("mac os") || this.osDisplayName.toLowerCase().equals("mac os x") || this.osDisplayName.toLowerCase().equals("mac")) {
            return "macOS";
        }
        return StringUtils.capitalize((String)this.osDisplayName.toLowerCase());
    }

    public void setOsDisplayName(String osDisplayName) {
        this.osDisplayName = osDisplayName;
    }

    public String getBrowserDisplayName() {
        return StringUtils.capitalize((String)this.browserDisplayName.toLowerCase());
    }

    public void setBrowserDisplayName(String browserDisplayName) {
        this.browserDisplayName = browserDisplayName;
    }

    @Override
    public Map<String, Object> toDesireCapabilitiesMap() {
        LinkedHashMap<String, Object> desiredCapabilitiesMap = new LinkedHashMap<String, Object>();
        desiredCapabilitiesMap.put("platformName", this.getOs());
        desiredCapabilitiesMap.put("browserName", this.getBrowserName());
        desiredCapabilitiesMap.put("browserVersion", this.getBrowserVersion());
        HashMap<String, Object> katalonOptions = new HashMap<String, Object>();
        katalonOptions.put("usingTunnel", this.isUsingTunnel());
        katalonOptions.put("browserVersionType", this.getBrowserVersionType());
        desiredCapabilitiesMap.put("katalon:options", katalonOptions);
        return desiredCapabilitiesMap;
    }

    @Override
    public Map<String, Object> getSystemPropertiesMap() {
        HashMap<String, Object> systemProperties = new HashMap<String, Object>();
        systemProperties.put("readTimeout", Integer.toString(this.getTimeout()));
        systemProperties.put("testCloudRemoteOS", this.getOsDisplayName());
        return systemProperties;
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.getOs()) && StringUtils.isEmpty((CharSequence)this.getBrowserName()) && StringUtils.isEmpty((CharSequence)this.getBrowserVersion());
    }
}

