/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import graphql.AssertException;
import graphql.Directives;
import graphql.GraphQLContext;
import graphql.PublicApi;
import graphql.Scalars;
import graphql.analysis.QueryTraverser;
import graphql.analysis.QueryVisitor;
import graphql.analysis.QueryVisitorFieldArgumentEnvironment;
import graphql.analysis.QueryVisitorFieldArgumentInputValue;
import graphql.analysis.QueryVisitorFieldArgumentValueEnvironment;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.analysis.QueryVisitorFragmentSpreadEnvironment;
import graphql.analysis.QueryVisitorInlineFragmentEnvironment;
import graphql.collect.ImmutableKit;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.AstPrinter;
import graphql.language.AstTransformer;
import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.EnumValue;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.IntValue;
import graphql.language.ListType;
import graphql.language.Node;
import graphql.language.NodeVisitorStub;
import graphql.language.NonNullType;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.parser.Parser;
import graphql.parser.ParserEnvironment;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLImplementingType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.GraphQLUnionType;
import graphql.schema.SchemaTransformer;
import graphql.schema.TypeResolver;
import graphql.schema.idl.DirectiveInfo;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.TypeUtil;
import graphql.schema.impl.SchemaUtil;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@PublicApi
public class Anonymizer {
    public static GraphQLSchema anonymizeSchema(String sdl) {
        return Anonymizer.anonymizeSchemaAndQueries((GraphQLSchema)SchemaGenerator.createdMockedSchema((String)sdl), ImmutableKit.emptyList(), ImmutableKit.emptyMap()).schema;
    }

    public static GraphQLSchema anonymizeSchema(GraphQLSchema schema) {
        return Anonymizer.anonymizeSchemaAndQueries((GraphQLSchema)schema, ImmutableKit.emptyList(), ImmutableKit.emptyMap()).schema;
    }

    public static AnonymizeResult anonymizeSchemaAndQueries(String sdl, List<String> queries) {
        return Anonymizer.anonymizeSchemaAndQueries(SchemaGenerator.createdMockedSchema(sdl), queries, ImmutableKit.emptyMap());
    }

    public static AnonymizeResult anonymizeSchemaAndQueries(GraphQLSchema schema, List<String> queries) {
        return Anonymizer.anonymizeSchemaAndQueries(schema, queries, ImmutableKit.emptyMap());
    }

    public static AnonymizeResult anonymizeSchemaAndQueries(String sdl, List<String> queries, Map<String, Object> variables) {
        return Anonymizer.anonymizeSchemaAndQueries(SchemaGenerator.createdMockedSchema(sdl), queries, variables);
    }

    public static AnonymizeResult anonymizeSchemaAndQueries(final GraphQLSchema schema, List<String> queries, Map<String, Object> variables) {
        Assert.assertNotNull(queries, () -> "queries can't be null");
        final AtomicInteger defaultStringValueCounter = new AtomicInteger(1);
        final AtomicInteger defaultIntValueCounter = new AtomicInteger(1);
        final Map<GraphQLNamedSchemaElement, String> newNameMap = Anonymizer.recordNewNamesForSchema(schema);
        final HashMap renamedArgumentsMap = new HashMap();
        SchemaTransformer schemaTransformer = new SchemaTransformer();
        GraphQLSchema newSchema = schemaTransformer.transform(schema, (GraphQLTypeVisitor)new GraphQLTypeVisitorStub(){

            @Override
            public TraversalControl visitGraphQLTypeReference(GraphQLTypeReference graphQLTypeReference, TraverserContext<GraphQLSchemaElement> context) {
                GraphQLNamedSchemaElement type = (GraphQLNamedSchemaElement)((Object)schema.getType(graphQLTypeReference.getName()));
                String newName = (String)newNameMap.get(type);
                GraphQLTypeReference newReference = GraphQLTypeReference.typeRef(newName);
                return this.changeNode(context, newReference);
            }

            @Override
            public TraversalControl visitGraphQLArgument(GraphQLArgument graphQLArgument, TraverserContext<GraphQLSchemaElement> context) {
                String newName = Assert.assertNotNull((String)newNameMap.get(graphQLArgument));
                if (context.getParentNode() instanceof GraphQLFieldDefinition && renamedArgumentsMap.containsKey(newName)) {
                    return this.changeNode(context, ((GraphQLArgument)renamedArgumentsMap.get(newName)).transform(b -> {}));
                }
                GraphQLArgument newElement = graphQLArgument.transform(builder -> {
                    builder.name(newName).description(null).definition(null);
                    if (graphQLArgument.hasSetDefaultValue()) {
                        Value<?> defaultValueLiteral = ValuesResolver.valueToLiteral(graphQLArgument.getArgumentDefaultValue(), graphQLArgument.getType(), GraphQLContext.getDefault(), Locale.getDefault());
                        builder.defaultValueLiteral(Anonymizer.replaceValue(defaultValueLiteral, graphQLArgument.getType(), newNameMap, defaultStringValueCounter, defaultIntValueCounter));
                    }
                    if (graphQLArgument.hasSetValue()) {
                        Value<?> valueLiteral = ValuesResolver.valueToLiteral(graphQLArgument.getArgumentValue(), graphQLArgument.getType(), GraphQLContext.getDefault(), Locale.getDefault());
                        builder.valueLiteral(Anonymizer.replaceValue(valueLiteral, graphQLArgument.getType(), newNameMap, defaultStringValueCounter, defaultIntValueCounter));
                    }
                });
                renamedArgumentsMap.put(newName, newElement);
                return this.changeNode(context, newElement);
            }

            @Override
            public TraversalControl visitGraphQLAppliedDirectiveArgument(GraphQLAppliedDirectiveArgument graphQLArgument, TraverserContext<GraphQLSchemaElement> context) {
                String newName = Assert.assertNotNull((String)newNameMap.get(graphQLArgument));
                GraphQLAppliedDirectiveArgument newElement = graphQLArgument.transform(builder -> {
                    ((GraphQLAppliedDirectiveArgument.Builder)((GraphQLAppliedDirectiveArgument.Builder)builder.name(newName)).description(null)).definition(null);
                    if (graphQLArgument.hasSetValue()) {
                        Value<?> valueLiteral = ValuesResolver.valueToLiteral(graphQLArgument.getArgumentValue(), graphQLArgument.getType(), GraphQLContext.getDefault(), Locale.getDefault());
                        builder.valueLiteral(Anonymizer.replaceValue(valueLiteral, graphQLArgument.getType(), newNameMap, defaultStringValueCounter, defaultIntValueCounter));
                    }
                });
                return this.changeNode(context, newElement);
            }

            @Override
            public TraversalControl visitGraphQLInterfaceType(GraphQLInterfaceType graphQLInterfaceType, TraverserContext<GraphQLSchemaElement> context) {
                if (Introspection.isIntrospectionTypes(graphQLInterfaceType)) {
                    return TraversalControl.ABORT;
                }
                String newName = Assert.assertNotNull((String)newNameMap.get(graphQLInterfaceType));
                GraphQLInterfaceType newElement = graphQLInterfaceType.transform(builder -> builder.name(newName).description(null).definition(null));
                GraphQLCodeRegistry.Builder codeRegistry = Assert.assertNotNull(context.getVarFromParents(GraphQLCodeRegistry.Builder.class));
                TypeResolver typeResolver = codeRegistry.getTypeResolver(graphQLInterfaceType);
                codeRegistry.typeResolver(newName, typeResolver);
                return this.changeNode(context, newElement);
            }

            @Override
            public TraversalControl visitGraphQLEnumType(GraphQLEnumType graphQLEnumType, TraverserContext<GraphQLSchemaElement> context) {
                if (Introspection.isIntrospectionTypes(graphQLEnumType)) {
                    return TraversalControl.ABORT;
                }
                String newName = Assert.assertNotNull((String)newNameMap.get(graphQLEnumType));
                GraphQLEnumType newElement = graphQLEnumType.transform(builder -> builder.name(newName).description(null).definition(null));
                return this.changeNode(context, newElement);
            }

            @Override
            public TraversalControl visitGraphQLEnumValueDefinition(GraphQLEnumValueDefinition enumValueDefinition, TraverserContext<GraphQLSchemaElement> context) {
                String newName = Assert.assertNotNull((String)newNameMap.get(enumValueDefinition));
                GraphQLEnumValueDefinition newElement = enumValueDefinition.transform(builder -> builder.name(newName).description(null).definition(null));
                return this.changeNode(context, newElement);
            }

            @Override
            public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition graphQLFieldDefinition, TraverserContext<GraphQLSchemaElement> context) {
                String newName = Assert.assertNotNull((String)newNameMap.get(graphQLFieldDefinition));
                GraphQLFieldDefinition newElement = graphQLFieldDefinition.transform(builder -> builder.name(newName).description(null).definition(null));
                return this.changeNode(context, newElement);
            }

            @Override
            public TraversalControl visitGraphQLDirective(GraphQLDirective graphQLDirective, TraverserContext<GraphQLSchemaElement> context) {
                if (Directives.DEPRECATED_DIRECTIVE_DEFINITION.getName().equals(graphQLDirective.getName())) {
                    GraphQLArgument reason = GraphQLArgument.newArgument().name("reason").type(Scalars.GraphQLString).clearValue().build();
                    GraphQLDirective newElement = graphQLDirective.transform(builder -> builder.description(null).argument(reason));
                    this.changeNode(context, newElement);
                    return TraversalControl.ABORT;
                }
                if (DirectiveInfo.isGraphqlSpecifiedDirective(graphQLDirective.getName())) {
                    return TraversalControl.ABORT;
                }
                String newName = Assert.assertNotNull((String)newNameMap.get(graphQLDirective));
                GraphQLDirective newElement = graphQLDirective.transform(builder -> builder.name(newName).description(null).definition(null));
                return this.changeNode(context, newElement);
            }

            @Override
            public TraversalControl visitGraphQLAppliedDirective(GraphQLAppliedDirective graphQLDirective, TraverserContext<GraphQLSchemaElement> context) {
                if (Directives.DEPRECATED_DIRECTIVE_DEFINITION.getName().equals(graphQLDirective.getName())) {
                    GraphQLAppliedDirectiveArgument reason = ((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name("reason")).type(Scalars.GraphQLString).clearValue().build();
                    GraphQLAppliedDirective newElement = graphQLDirective.transform(builder -> ((GraphQLAppliedDirective.Builder)builder.description(null)).argument(reason));
                    this.changeNode(context, newElement);
                    return TraversalControl.ABORT;
                }
                if (DirectiveInfo.isGraphqlSpecifiedDirective(graphQLDirective.getName())) {
                    return TraversalControl.ABORT;
                }
                String newName = Assert.assertNotNull((String)newNameMap.get(graphQLDirective));
                GraphQLAppliedDirective newElement = graphQLDirective.transform(builder -> ((GraphQLAppliedDirective.Builder)((GraphQLAppliedDirective.Builder)builder.name(newName)).description(null)).definition(null));
                return this.changeNode(context, newElement);
            }

            @Override
            public TraversalControl visitGraphQLInputObjectField(GraphQLInputObjectField graphQLInputObjectField, TraverserContext<GraphQLSchemaElement> context) {
                String newName = Assert.assertNotNull((String)newNameMap.get(graphQLInputObjectField));
                Value defaultValue = null;
                if (graphQLInputObjectField.hasSetDefaultValue()) {
                    defaultValue = ValuesResolver.valueToLiteral(graphQLInputObjectField.getInputFieldDefaultValue(), graphQLInputObjectField.getType(), GraphQLContext.getDefault(), Locale.getDefault());
                    defaultValue = Anonymizer.replaceValue(defaultValue, graphQLInputObjectField.getType(), newNameMap, defaultStringValueCounter, defaultIntValueCounter);
                }
                Value finalDefaultValue = defaultValue;
                GraphQLInputObjectField newElement = graphQLInputObjectField.transform(builder -> {
                    builder.name(newName);
                    if (finalDefaultValue != null) {
                        builder.defaultValueLiteral(finalDefaultValue);
                    }
                    builder.description(null);
                    builder.definition(null);
                });
                return this.changeNode(context, newElement);
            }

            @Override
            public TraversalControl visitGraphQLInputObjectType(GraphQLInputObjectType graphQLInputObjectType, TraverserContext<GraphQLSchemaElement> context) {
                if (Introspection.isIntrospectionTypes(graphQLInputObjectType)) {
                    return TraversalControl.ABORT;
                }
                String newName = Assert.assertNotNull((String)newNameMap.get(graphQLInputObjectType));
                GraphQLInputObjectType newElement = graphQLInputObjectType.transform(builder -> builder.name(newName).description(null).definition(null));
                return this.changeNode(context, newElement);
            }

            @Override
            public TraversalControl visitGraphQLObjectType(GraphQLObjectType graphQLObjectType, TraverserContext<GraphQLSchemaElement> context) {
                if (Introspection.isIntrospectionTypes(graphQLObjectType)) {
                    return TraversalControl.ABORT;
                }
                String newName = Assert.assertNotNull((String)newNameMap.get(graphQLObjectType));
                GraphQLObjectType newElement = graphQLObjectType.transform(builder -> builder.name(newName).description(null).definition(null));
                return this.changeNode(context, newElement);
            }

            @Override
            public TraversalControl visitGraphQLScalarType(GraphQLScalarType graphQLScalarType, TraverserContext<GraphQLSchemaElement> context) {
                if (ScalarInfo.isGraphqlSpecifiedScalar(graphQLScalarType)) {
                    return TraversalControl.ABORT;
                }
                String newName = Assert.assertNotNull((String)newNameMap.get(graphQLScalarType));
                GraphQLScalarType newElement = graphQLScalarType.transform(builder -> builder.name(newName).description(null).definition(null));
                return this.changeNode(context, newElement);
            }

            @Override
            public TraversalControl visitGraphQLUnionType(GraphQLUnionType graphQLUnionType, TraverserContext<GraphQLSchemaElement> context) {
                if (Introspection.isIntrospectionTypes(graphQLUnionType)) {
                    return TraversalControl.ABORT;
                }
                String newName = Assert.assertNotNull((String)newNameMap.get(graphQLUnionType));
                GraphQLUnionType newElement = graphQLUnionType.transform(builder -> builder.name(newName).description(null).definition(null));
                GraphQLCodeRegistry.Builder codeRegistry = Assert.assertNotNull(context.getVarFromParents(GraphQLCodeRegistry.Builder.class));
                TypeResolver typeResolver = codeRegistry.getTypeResolver(graphQLUnionType);
                codeRegistry.typeResolver(newName, typeResolver);
                return this.changeNode(context, newElement);
            }
        });
        ArrayList<String> newQueries = new ArrayList<String>();
        for (String query : queries) {
            String newQuery = Anonymizer.rewriteQuery(query, schema, newNameMap, variables);
            newQueries.add(newQuery);
        }
        AnonymizeResult result = new AnonymizeResult(newSchema, newQueries);
        return result;
    }

    private static Value replaceValue(Value valueLiteral, GraphQLInputType argType, Map<GraphQLNamedSchemaElement, String> newNameMap, AtomicInteger defaultStringValueCounter, AtomicInteger defaultIntValueCounter) {
        if (valueLiteral instanceof ArrayValue) {
            List<Value> values = ((ArrayValue)valueLiteral).getValues();
            ArrayValue.Builder newArrayValueBuilder = ArrayValue.newArrayValue();
            for (Value value : values) {
                GraphQLInputType unwrappedInputType = (GraphQLInputType)GraphQLTypeUtil.unwrapOneAs(GraphQLTypeUtil.unwrapNonNull(argType));
                newArrayValueBuilder.value(Anonymizer.replaceValue(value, unwrappedInputType, newNameMap, defaultStringValueCounter, defaultIntValueCounter));
            }
            return newArrayValueBuilder.build();
        }
        if (valueLiteral instanceof StringValue) {
            return StringValue.newStringValue("stringValue" + defaultStringValueCounter.getAndIncrement()).build();
        }
        if (valueLiteral instanceof IntValue) {
            return IntValue.newIntValue(BigInteger.valueOf(defaultIntValueCounter.getAndIncrement())).build();
        }
        if (valueLiteral instanceof EnumValue) {
            GraphQLEnumType enumType = (GraphQLEnumType)GraphQLTypeUtil.unwrapNonNullAs(argType);
            GraphQLEnumValueDefinition enumValueDefinition = enumType.getValue(((EnumValue)valueLiteral).getName());
            String newName = newNameMap.get(enumValueDefinition);
            return new EnumValue(newName);
        }
        if (valueLiteral instanceof ObjectValue) {
            GraphQLInputObjectType inputObjectType = (GraphQLInputObjectType)GraphQLTypeUtil.unwrapNonNullAs(argType);
            ObjectValue.Builder newObjectValueBuilder = ObjectValue.newObjectValue();
            List<ObjectField> objectFields = ((ObjectValue)valueLiteral).getObjectFields();
            for (ObjectField objectField : objectFields) {
                String objectFieldName = objectField.getName();
                Value objectFieldValue = objectField.getValue();
                GraphQLInputObjectField inputObjectTypeField = inputObjectType.getField(objectFieldName);
                GraphQLInputType fieldType = (GraphQLInputType)GraphQLTypeUtil.unwrapNonNullAs(inputObjectTypeField.getType());
                ObjectField newObjectField = objectField.transform(builder -> {
                    builder.name((String)newNameMap.get(inputObjectTypeField));
                    builder.value(Anonymizer.replaceValue(objectFieldValue, fieldType, newNameMap, defaultStringValueCounter, defaultIntValueCounter));
                });
                newObjectValueBuilder.objectField(newObjectField);
            }
            return newObjectValueBuilder.build();
        }
        return valueLiteral;
    }

    public static Map<GraphQLNamedSchemaElement, String> recordNewNamesForSchema(final GraphQLSchema schema) {
        final AtomicInteger objectCounter = new AtomicInteger(1);
        final AtomicInteger inputObjectCounter = new AtomicInteger(1);
        final AtomicInteger inputObjectFieldCounter = new AtomicInteger(1);
        final AtomicInteger fieldCounter = new AtomicInteger(1);
        final AtomicInteger scalarCounter = new AtomicInteger(1);
        AtomicInteger directiveCounter = new AtomicInteger(1);
        final AtomicInteger argumentCounter = new AtomicInteger(1);
        final AtomicInteger interfaceCounter = new AtomicInteger(1);
        final AtomicInteger unionCounter = new AtomicInteger(1);
        final AtomicInteger enumCounter = new AtomicInteger(1);
        final AtomicInteger enumValueCounter = new AtomicInteger(1);
        final LinkedHashMap<GraphQLNamedSchemaElement, String> newNameMap = new LinkedHashMap<GraphQLNamedSchemaElement, String>();
        HashMap directivesOriginalToNewNameMap = new HashMap();
        HashMap seenArgumentsOnDirectivesMap = new HashMap();
        final Map<String, List<GraphQLImplementingType>> interfaceToImplementations = new SchemaUtil().groupImplementationsForInterfacesAndObjects(schema);
        final Consumer<GraphQLNamedSchemaElement> recordDirectiveName = graphQLDirective -> {
            String directiveName = graphQLDirective.getName();
            if (directivesOriginalToNewNameMap.containsKey(directiveName)) {
                newNameMap.put((GraphQLNamedSchemaElement)graphQLDirective, (String)directivesOriginalToNewNameMap.get(directiveName));
                return;
            }
            String newName = "Directive" + directiveCounter.getAndIncrement();
            newNameMap.put((GraphQLNamedSchemaElement)graphQLDirective, newName);
            directivesOriginalToNewNameMap.put(directiveName, newName);
        };
        final BiConsumer<GraphQLNamedSchemaElement, String> recordDirectiveArgumentName = (graphQLArgument, directiveArgumentKey) -> {
            if (seenArgumentsOnDirectivesMap.containsKey(directiveArgumentKey)) {
                newNameMap.put((GraphQLNamedSchemaElement)graphQLArgument, (String)seenArgumentsOnDirectivesMap.get(directiveArgumentKey));
                return;
            }
            String newName = "argument" + argumentCounter.getAndIncrement();
            newNameMap.put((GraphQLNamedSchemaElement)graphQLArgument, newName);
            seenArgumentsOnDirectivesMap.put(directiveArgumentKey, newName);
        };
        GraphQLTypeVisitorStub visitor = new GraphQLTypeVisitorStub(){

            @Override
            public TraversalControl visitGraphQLArgument(GraphQLArgument graphQLArgument, TraverserContext<GraphQLSchemaElement> context) {
                Object newName;
                GraphQLImplementingType implementingType;
                String curName = graphQLArgument.getName();
                GraphQLSchemaElement parentNode = context.getParentNode();
                if (parentNode instanceof GraphQLDirective) {
                    String directiveArgumentKey = ((GraphQLDirective)parentNode).getName() + graphQLArgument.getName();
                    recordDirectiveArgumentName.accept(graphQLArgument, directiveArgumentKey);
                    return TraversalControl.CONTINUE;
                }
                if (!(parentNode instanceof GraphQLFieldDefinition)) {
                    String newName2 = "argument" + argumentCounter.getAndIncrement();
                    newNameMap.put(graphQLArgument, newName2);
                    return TraversalControl.CONTINUE;
                }
                GraphQLFieldDefinition fieldDefinition = (GraphQLFieldDefinition)parentNode;
                String fieldName = fieldDefinition.getName();
                Set<GraphQLFieldDefinition> matchingInterfaceFieldDefinitions = Anonymizer.getSameFields(fieldName, (implementingType = (GraphQLImplementingType)context.getParentContext().getParentNode()).getName(), interfaceToImplementations, schema);
                if (matchingInterfaceFieldDefinitions.size() == 0) {
                    newName = "argument" + argumentCounter.getAndIncrement();
                } else {
                    List<GraphQLArgument> matchingArgumentDefinitions = Anonymizer.getMatchingArgumentDefinitions(curName, matchingInterfaceFieldDefinitions);
                    if (matchingArgumentDefinitions.size() == 0) {
                        newName = "argument" + argumentCounter.getAndIncrement();
                    } else if (newNameMap.containsKey(matchingArgumentDefinitions.get(0))) {
                        newName = (String)newNameMap.get(matchingArgumentDefinitions.get(0));
                    } else {
                        newName = "argument" + argumentCounter.getAndIncrement();
                        for (GraphQLArgument argument : matchingArgumentDefinitions) {
                            newNameMap.put(argument, newName);
                        }
                    }
                }
                newNameMap.put(graphQLArgument, newName);
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLAppliedDirectiveArgument(GraphQLAppliedDirectiveArgument graphQLArgument, TraverserContext<GraphQLSchemaElement> context) {
                GraphQLSchemaElement parentNode = context.getParentNode();
                if (parentNode instanceof GraphQLAppliedDirective) {
                    String directiveArgumentKey = ((GraphQLAppliedDirective)parentNode).getName() + graphQLArgument.getName();
                    recordDirectiveArgumentName.accept(graphQLArgument, directiveArgumentKey);
                }
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLDirective(GraphQLDirective graphQLDirective, TraverserContext<GraphQLSchemaElement> context) {
                if (DirectiveInfo.isGraphqlSpecifiedDirective(graphQLDirective)) {
                    return TraversalControl.ABORT;
                }
                recordDirectiveName.accept(graphQLDirective);
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLAppliedDirective(GraphQLAppliedDirective graphQLAppliedDirective, TraverserContext<GraphQLSchemaElement> context) {
                if (DirectiveInfo.isGraphqlSpecifiedDirective(graphQLAppliedDirective.getName())) {
                    return TraversalControl.ABORT;
                }
                recordDirectiveName.accept(graphQLAppliedDirective);
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLInterfaceType(GraphQLInterfaceType graphQLInterfaceType, TraverserContext<GraphQLSchemaElement> context) {
                if (Introspection.isIntrospectionTypes(graphQLInterfaceType)) {
                    return TraversalControl.ABORT;
                }
                String newName = "Interface" + interfaceCounter.getAndIncrement();
                newNameMap.put(graphQLInterfaceType, newName);
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLEnumType(GraphQLEnumType graphQLEnumType, TraverserContext<GraphQLSchemaElement> context) {
                if (Introspection.isIntrospectionTypes(graphQLEnumType)) {
                    return TraversalControl.ABORT;
                }
                String newName = "Enum" + enumCounter.getAndIncrement();
                newNameMap.put(graphQLEnumType, newName);
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLEnumValueDefinition(GraphQLEnumValueDefinition enumValueDefinition, TraverserContext<GraphQLSchemaElement> context) {
                String newName = "EnumValue" + enumValueCounter.getAndIncrement();
                newNameMap.put(enumValueDefinition, newName);
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition graphQLFieldDefinition, TraverserContext<GraphQLSchemaElement> context) {
                Object newName;
                GraphQLImplementingType parentNode;
                String fieldName = graphQLFieldDefinition.getName();
                Set<GraphQLFieldDefinition> sameFields = Anonymizer.getSameFields(fieldName, (parentNode = (GraphQLImplementingType)context.getParentNode()).getName(), interfaceToImplementations, schema);
                if (sameFields.size() == 0) {
                    newName = "field" + fieldCounter.getAndIncrement();
                } else if (newNameMap.containsKey(sameFields.iterator().next())) {
                    newName = (String)newNameMap.get(sameFields.iterator().next());
                } else {
                    newName = "field" + fieldCounter.getAndIncrement();
                    for (GraphQLFieldDefinition fieldDefinition : sameFields) {
                        newNameMap.put(fieldDefinition, newName);
                    }
                }
                newNameMap.put(graphQLFieldDefinition, newName);
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLInputObjectField(GraphQLInputObjectField graphQLInputObjectField, TraverserContext<GraphQLSchemaElement> context) {
                String newName = "inputField" + inputObjectFieldCounter.getAndIncrement();
                newNameMap.put(graphQLInputObjectField, newName);
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLInputObjectType(GraphQLInputObjectType graphQLInputObjectType, TraverserContext<GraphQLSchemaElement> context) {
                if (Introspection.isIntrospectionTypes(graphQLInputObjectType)) {
                    return TraversalControl.ABORT;
                }
                String newName = "InputObject" + inputObjectCounter.getAndIncrement();
                newNameMap.put(graphQLInputObjectType, newName);
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLObjectType(GraphQLObjectType graphQLObjectType, TraverserContext<GraphQLSchemaElement> context) {
                if (Introspection.isIntrospectionTypes(graphQLObjectType)) {
                    return TraversalControl.ABORT;
                }
                String newName = "Object" + objectCounter.getAndIncrement();
                newNameMap.put(graphQLObjectType, newName);
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLScalarType(GraphQLScalarType graphQLScalarType, TraverserContext<GraphQLSchemaElement> context) {
                if (ScalarInfo.isGraphqlSpecifiedScalar(graphQLScalarType)) {
                    return TraversalControl.ABORT;
                }
                String newName = "Scalar" + scalarCounter.getAndIncrement();
                newNameMap.put(graphQLScalarType, newName);
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLUnionType(GraphQLUnionType graphQLUnionType, TraverserContext<GraphQLSchemaElement> context) {
                if (Introspection.isIntrospectionTypes(graphQLUnionType)) {
                    return TraversalControl.ABORT;
                }
                String newName = "Union" + unionCounter.getAndIncrement();
                newNameMap.put(graphQLUnionType, newName);
                return TraversalControl.CONTINUE;
            }
        };
        SchemaTransformer.transformSchema(schema, (GraphQLTypeVisitor)visitor);
        return newNameMap;
    }

    private static Set<GraphQLFieldDefinition> getSameFields(String fieldName, String objectOrInterfaceName, Map<String, List<GraphQLImplementingType>> interfaceToImplementations, GraphQLSchema schema) {
        LinkedHashSet<GraphQLFieldDefinition> result = new LinkedHashSet<GraphQLFieldDefinition>();
        LinkedHashSet<String> alreadyChecked = new LinkedHashSet<String>();
        Anonymizer.getSameFieldsImpl(fieldName, objectOrInterfaceName, interfaceToImplementations, schema, alreadyChecked, result);
        return result;
    }

    private static void getSameFieldsImpl(String fieldName, String curObjectOrInterface, Map<String, List<GraphQLImplementingType>> interfaceToImplementations, GraphQLSchema schema, Set<String> alreadyChecked, Set<GraphQLFieldDefinition> result) {
        if (alreadyChecked.contains(curObjectOrInterface)) {
            return;
        }
        alreadyChecked.add(curObjectOrInterface);
        GraphQLImplementingType type = (GraphQLImplementingType)schema.getType(curObjectOrInterface);
        List<GraphQLNamedOutputType> interfaces = type.getInterfaces();
        Anonymizer.getMatchingFieldDefinitions(fieldName, interfaces, result);
        for (GraphQLNamedOutputType interfaze : interfaces) {
            Anonymizer.getSameFieldsImpl(fieldName, interfaze.getName(), interfaceToImplementations, schema, alreadyChecked, result);
        }
        List<GraphQLImplementingType> implementations = interfaceToImplementations.get(curObjectOrInterface);
        if (implementations == null) {
            return;
        }
        Anonymizer.getMatchingFieldDefinitions(fieldName, implementations, result);
        for (GraphQLImplementingType implementingType : implementations) {
            Anonymizer.getSameFieldsImpl(fieldName, implementingType.getName(), interfaceToImplementations, schema, alreadyChecked, result);
        }
    }

    private static void getMatchingFieldDefinitions(String fieldName, List<? extends GraphQLType> interfaces, Set<GraphQLFieldDefinition> result) {
        for (GraphQLType graphQLType : interfaces) {
            GraphQLImplementingType implementingType = (GraphQLImplementingType)graphQLType;
            if (implementingType.getFieldDefinition(fieldName) == null) continue;
            result.add(implementingType.getFieldDefinition(fieldName));
        }
    }

    private static List<GraphQLArgument> getMatchingArgumentDefinitions(String name, Set<GraphQLFieldDefinition> fieldDefinitions) {
        ArrayList<GraphQLArgument> result = new ArrayList<GraphQLArgument>();
        for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
            Optional.ofNullable(fieldDefinition.getArgument(name)).ifPresent(result::add);
        }
        return result;
    }

    private static String rewriteQuery(String query, final GraphQLSchema schema, final Map<GraphQLNamedSchemaElement, String> newNames, Map<String, Object> variables) {
        final AtomicInteger fragmentCounter = new AtomicInteger(1);
        final AtomicInteger variableCounter = new AtomicInteger(1);
        final LinkedHashMap astNodeToNewName = new LinkedHashMap();
        final LinkedHashMap variableNames = new LinkedHashMap();
        final LinkedHashMap fieldToFieldDefinition = new LinkedHashMap();
        Document document = Parser.parse(ParserEnvironment.newParserEnvironment().document(query).build());
        Anonymizer.assertUniqueOperation(document);
        QueryTraverser queryTraverser = QueryTraverser.newQueryTraverser().document(document).schema(schema).variables(variables).build();
        queryTraverser.visitDepthFirst(new QueryVisitor(){

            @Override
            public void visitField(QueryVisitorFieldEnvironment env) {
                if (env.isTypeNameIntrospectionField()) {
                    return;
                }
                fieldToFieldDefinition.put(env.getField(), env.getFieldDefinition());
                String newName = Assert.assertNotNull((String)newNames.get(env.getFieldDefinition()));
                Field field = env.getField();
                astNodeToNewName.put(field, newName);
                List<Directive> directives = field.getDirectives();
                for (Directive directive : directives) {
                    GraphQLDirective directiveDefinition = Assert.assertNotNull(schema.getDirective(directive.getName()), "%s directive definition not found ", directive.getName());
                    String directiveName = directiveDefinition.getName();
                    String newDirectiveName = Assert.assertNotNull((String)newNames.get(directiveDefinition), "No new name found for directive %s", directiveName);
                    astNodeToNewName.put(directive, newDirectiveName);
                    for (Argument argument : directive.getArguments()) {
                        GraphQLArgument argumentDefinition = directiveDefinition.getArgument(argument.getName());
                        String newArgumentName = Assert.assertNotNull((String)newNames.get(argumentDefinition), "No new name found for directive %s argument %s", directiveName, argument.getName());
                        astNodeToNewName.put(argument, newArgumentName);
                        this.visitDirectiveArgumentValues(directive, argument.getValue());
                    }
                }
            }

            private void visitDirectiveArgumentValues(Directive directive, Value value) {
                String name;
                if (value instanceof VariableReference && !variableNames.containsKey(name = ((VariableReference)value).getName())) {
                    String newName = "var" + variableCounter.getAndIncrement();
                    variableNames.put(name, newName);
                }
            }

            @Override
            public void visitInlineFragment(QueryVisitorInlineFragmentEnvironment queryVisitorInlineFragmentEnvironment) {
            }

            @Override
            public TraversalControl visitArgumentValue(QueryVisitorFieldArgumentValueEnvironment environment) {
                String name;
                QueryVisitorFieldArgumentInputValue argumentInputValue = environment.getArgumentInputValue();
                if (argumentInputValue.getValue() instanceof VariableReference && !variableNames.containsKey(name = ((VariableReference)argumentInputValue.getValue()).getName())) {
                    String newName = "var" + variableCounter.getAndIncrement();
                    variableNames.put(name, newName);
                }
                return TraversalControl.CONTINUE;
            }

            @Override
            public void visitFragmentSpread(QueryVisitorFragmentSpreadEnvironment queryVisitorFragmentSpreadEnvironment) {
                Object newName;
                FragmentDefinition fragmentDefinition = queryVisitorFragmentSpreadEnvironment.getFragmentDefinition();
                if (!astNodeToNewName.containsKey(fragmentDefinition)) {
                    newName = "Fragment" + fragmentCounter.getAndIncrement();
                    astNodeToNewName.put(fragmentDefinition, newName);
                } else {
                    newName = (String)astNodeToNewName.get(fragmentDefinition);
                }
                astNodeToNewName.put(queryVisitorFragmentSpreadEnvironment.getFragmentSpread(), newName);
            }

            @Override
            public TraversalControl visitArgument(QueryVisitorFieldArgumentEnvironment environment) {
                String newName = Assert.assertNotNull((String)newNames.get(environment.getGraphQLArgument()));
                astNodeToNewName.put(environment.getArgument(), newName);
                return TraversalControl.CONTINUE;
            }
        });
        AstTransformer astTransformer = new AstTransformer();
        final AtomicInteger aliasCounter = new AtomicInteger(1);
        final AtomicInteger defaultStringValueCounter = new AtomicInteger(1);
        final AtomicInteger defaultIntValueCounter = new AtomicInteger(1);
        Document newDocument = (Document)astTransformer.transform(document, new NodeVisitorStub(){

            @Override
            public TraversalControl visitDirective(Directive directive, TraverserContext<Node> context) {
                String newName = Assert.assertNotNull((String)astNodeToNewName.get(directive));
                GraphQLDirective directiveDefinition = schema.getDirective(directive.getName());
                context.setVar(GraphQLDirective.class, directiveDefinition);
                return TreeTransformerUtil.changeNode(context, directive.transform(builder -> builder.name(newName)));
            }

            @Override
            public TraversalControl visitOperationDefinition(OperationDefinition node, TraverserContext<Node> context) {
                if (node.getName() != null) {
                    return TreeTransformerUtil.changeNode(context, node.transform(builder -> builder.name("operation")));
                }
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitField(Field field, TraverserContext<Node> context) {
                String newName;
                String newAlias = null;
                if (field.getAlias() != null) {
                    newAlias = "alias" + aliasCounter.getAndIncrement();
                }
                if (field.getName().equals(Introspection.TypeNameMetaFieldDef.getName())) {
                    newName = Introspection.TypeNameMetaFieldDef.getName();
                } else {
                    newName = Assert.assertNotNull((String)astNodeToNewName.get(field));
                    context.setVar(GraphQLFieldDefinition.class, Assert.assertNotNull((GraphQLFieldDefinition)fieldToFieldDefinition.get(field)));
                }
                String finalNewAlias = newAlias;
                return TreeTransformerUtil.changeNode(context, field.transform(builder -> builder.name(newName).alias(finalNewAlias)));
            }

            @Override
            public TraversalControl visitVariableDefinition(VariableDefinition node, TraverserContext<Node> context) {
                String newName = Assert.assertNotNull((String)variableNames.get(node.getName()));
                VariableDefinition newNode = node.transform(builder -> {
                    builder.name(newName).comments((List)ImmutableKit.emptyList());
                    TypeName typeName = TypeUtil.unwrapAll(node.getType());
                    GraphQLNamedType originalType = (GraphQLNamedType)schema.getTypeAs(typeName.getName());
                    if (newNames.containsKey(originalType)) {
                        String newTypeName = (String)newNames.get(originalType);
                        builder.type(Anonymizer.replaceTypeName(node.getType(), newTypeName));
                    }
                    if (node.getDefaultValue() != null) {
                        Value defaultValueLiteral = node.getDefaultValue();
                        GraphQLType graphQLType = Anonymizer.fromTypeToGraphQLType(node.getType(), schema);
                        builder.defaultValue(Anonymizer.replaceValue(defaultValueLiteral, (GraphQLInputType)graphQLType, newNames, defaultStringValueCounter, defaultIntValueCounter));
                    }
                });
                return TreeTransformerUtil.changeNode(context, newNode);
            }

            @Override
            public TraversalControl visitVariableReference(VariableReference node, TraverserContext<Node> context) {
                String newName = Assert.assertNotNull((String)variableNames.get(node.getName()), "No new variable name found for %s", node.getName());
                return TreeTransformerUtil.changeNode(context, node.transform(builder -> builder.name(newName)));
            }

            @Override
            public TraversalControl visitFragmentDefinition(FragmentDefinition node, TraverserContext<Node> context) {
                String newName = Assert.assertNotNull((String)astNodeToNewName.get(node));
                GraphQLType currentCondition = Assert.assertNotNull(schema.getType(node.getTypeCondition().getName()));
                String newCondition = (String)newNames.get(currentCondition);
                return TreeTransformerUtil.changeNode(context, node.transform(builder -> builder.name(newName).typeCondition(new TypeName(newCondition))));
            }

            @Override
            public TraversalControl visitInlineFragment(InlineFragment node, TraverserContext<Node> context) {
                GraphQLType currentCondition = Assert.assertNotNull(schema.getType(node.getTypeCondition().getName()));
                String newCondition = (String)newNames.get(currentCondition);
                return TreeTransformerUtil.changeNode(context, node.transform(builder -> builder.typeCondition(new TypeName(newCondition))));
            }

            @Override
            public TraversalControl visitFragmentSpread(FragmentSpread node, TraverserContext<Node> context) {
                String newName = Assert.assertNotNull((String)astNodeToNewName.get(node));
                return TreeTransformerUtil.changeNode(context, node.transform(builder -> builder.name(newName)));
            }

            @Override
            public TraversalControl visitArgument(Argument argument, TraverserContext<Node> context) {
                GraphQLArgument graphQLArgumentDefinition;
                if (context.getVarFromParents(GraphQLDirective.class) != null) {
                    GraphQLDirective directiveDefinition = context.getVarFromParents(GraphQLDirective.class);
                    graphQLArgumentDefinition = directiveDefinition.getArgument(argument.getName());
                } else {
                    GraphQLFieldDefinition graphQLFieldDefinition = Assert.assertNotNull(context.getVarFromParents(GraphQLFieldDefinition.class));
                    graphQLArgumentDefinition = graphQLFieldDefinition.getArgument(argument.getName());
                }
                GraphQLInputType argumentType = graphQLArgumentDefinition.getType();
                String newName = Assert.assertNotNull((String)astNodeToNewName.get(argument));
                Value newValue = Anonymizer.replaceValue(argument.getValue(), argumentType, newNames, defaultStringValueCounter, defaultIntValueCounter);
                return TreeTransformerUtil.changeNode(context, argument.transform(builder -> builder.name(newName).value(newValue)));
            }
        });
        return AstPrinter.printAstCompact(newDocument);
    }

    private static GraphQLType fromTypeToGraphQLType(Type type, GraphQLSchema schema) {
        if (type instanceof TypeName) {
            String typeName = ((TypeName)type).getName();
            GraphQLType graphQLType = schema.getType(typeName);
            Assert.assertNotNull(graphQLType, "Schema must contain type %s", typeName);
            return graphQLType;
        }
        if (type instanceof NonNullType) {
            return GraphQLNonNull.nonNull(Anonymizer.fromTypeToGraphQLType(TypeUtil.unwrapOne(type), schema));
        }
        if (type instanceof ListType) {
            return GraphQLList.list(Anonymizer.fromTypeToGraphQLType(TypeUtil.unwrapOne(type), schema));
        }
        Assert.assertShouldNeverHappen();
        return null;
    }

    private static Type replaceTypeName(Type type, String newName) {
        if (type instanceof TypeName) {
            return TypeName.newTypeName(newName).build();
        }
        if (type instanceof ListType) {
            return ListType.newListType(Anonymizer.replaceTypeName(((ListType)type).getType(), newName)).build();
        }
        if (type instanceof NonNullType) {
            return NonNullType.newNonNullType(Anonymizer.replaceTypeName(((NonNullType)type).getType(), newName)).build();
        }
        Assert.assertShouldNeverHappen();
        return null;
    }

    private static void assertUniqueOperation(Document document) {
        String operationName = null;
        for (Definition definition : document.getDefinitions()) {
            if (!(definition instanceof OperationDefinition)) continue;
            if (operationName != null) {
                throw new AssertException("Query must have exactly one operation");
            }
            OperationDefinition operationDefinition = (OperationDefinition)definition;
            operationName = operationDefinition.getName();
        }
    }

    public static class AnonymizeResult {
        private GraphQLSchema schema;
        private List<String> queries;

        public AnonymizeResult(GraphQLSchema schema, List<String> queries) {
            this.schema = schema;
            this.queries = queries;
        }

        public GraphQLSchema getSchema() {
            return this.schema;
        }

        public List<String> getQueries() {
            return this.queries;
        }
    }
}

