/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.actions;

import java.util.ArrayList;
import org.codehaus.groovy.eclipse.actions.ListMessageDialog;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.frameworkadapter.util.SpecifiedVersion;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class FixCompilerMismatches
implements IObjectActionDelegate {
    Shell activeShell;

    public void run(IAction action) {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> mismatchedProjects = new ArrayList<IProject>(allProjects.length);
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this.hasMismatch(project)) {
                mismatchedProjects.add(project);
            }
            ++n2;
        }
        if (!mismatchedProjects.isEmpty()) {
            IProject[] toConvert = ListMessageDialog.openViewer(this.activeShell, mismatchedProjects.toArray(new IProject[0]));
            if (toConvert == null) {
                return;
            }
            IProject[] iProjectArray2 = toConvert;
            int n3 = toConvert.length;
            n = 0;
            while (n < n3) {
                IProject project = iProjectArray2[n];
                CompilerUtils.setCompilerLevel((IProject)project, (SpecifiedVersion)CompilerUtils.getActiveGroovyVersion(), (boolean)false);
                ++n;
            }
        } else {
            MessageDialog.openInformation((Shell)this.activeShell, (String)"No mismatches found", (String)"All projects have correct compiler settings.");
        }
    }

    private boolean hasMismatch(IProject project) {
        if (!project.isAccessible()) {
            return false;
        }
        try {
            IMarker[] markers = project.findMarkers("org.codehaus.groovy.eclipse.core.compilerMismatch", true, 0);
            return markers != null && markers.length > 0;
        }
        catch (CoreException e) {
            GroovyCore.logException((String)"Error finding markers", (Throwable)e);
            return false;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activeShell = targetPart != null ? targetPart.getSite().getShell() : null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

