/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug;

import groovy.lang.GroovyClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ParserPluginFactory;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.eclipse.debug.JDIComparator;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;

public class JDIScriptLoader
extends GroovyClassLoader {
    private ClassNode theClass;

    public JDIScriptLoader(ClassLoader loader) {
        super(loader);
    }

    public ClassNode getTheClass() {
        return this.theClass;
    }

    protected GroovyClassLoader.ClassCollector createCollector(CompilationUnit cu, SourceUnit su) {
        GroovyClassLoader.InnerLoader loader = AccessController.doPrivileged(() -> new GroovyClassLoader.InnerLoader((GroovyClassLoader)this));
        return new GroovyClassLoader.ClassCollector(loader, cu, su){

            protected Class createClass(byte[] code, ClassNode classNode) {
                JDIScriptLoader.this.theClass = classNode;
                return super.createClass(code, classNode);
            }
        };
    }

    protected CompilationUnit createCompilationUnit(CompilerConfiguration config, CodeSource source) {
        config = new CompilerConfiguration(config);
        config.setPluginFactory(ParserPluginFactory.antlr4());
        config.getCompilationCustomizers().addAll(config.getCompilationCustomizers());
        CompilationUnit compilationUnit = super.createCompilationUnit(config, source);
        compilationUnit.addPhaseOperation(sourceUnit -> new ClassCodeExpressionTransformer(){

            protected SourceUnit getSourceUnit() {
                return sourceUnit;
            }

            public Expression transform(Expression expression) {
                BinaryExpression b;
                String methodName;
                if (expression instanceof BinaryExpression && (methodName = JDIComparator.methodNameFor((b = (BinaryExpression)expression).getOperation())) != null) {
                    Expression lhs = this.transform(b.getLeftExpression());
                    Expression rhs = this.transform(b.getRightExpression());
                    return GeneralUtils.callX((Expression)GeneralUtils.varX((String)"__comparator"), (String)methodName, (Expression)GeneralUtils.args((Expression[])new Expression[]{lhs, rhs}));
                }
                if (expression instanceof MethodPointerExpression) {
                    MethodPointerExpression m = (MethodPointerExpression)expression;
                    return GeneralUtils.callX((Expression)GeneralUtils.classX(ScriptBytecodeAdapter.class), (String)"getMethodPointer", (Expression)GeneralUtils.args((Expression[])new Expression[]{this.transform(m.getExpression()), this.transform(m.getMethodName())}));
                }
                if (expression instanceof StaticMethodCallExpression) {
                    StaticMethodCallExpression s = (StaticMethodCallExpression)expression;
                    return GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)s.getOwnerType()), (String)s.getMethod(), (Expression)this.transform(s.getArguments()));
                }
                return super.transform(expression);
            }
        }.visitBlockStatement(sourceUnit.getAST().getStatementBlock()), 5);
        return compilationUnit;
    }
}

