/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug.ui;

import java.util.HashMap;
import org.codehaus.groovy.antlr.LocationSupport;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.debug.ui.BreakpointLocationFinder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class BreakpointLocationVerifierJob
extends Job {
    public static final Object FAMILY = new Object();
    private IJavaLineBreakpoint fBreakpoint;
    private int fLineNumber;
    private String fTypeName;
    private IType fType;
    private IResource fResource;
    private IEditorPart fEditorPart;

    public BreakpointLocationVerifierJob(IJavaLineBreakpoint breakpoint, int lineNumber, String typeName, IType type, IResource resource, IEditorPart editorPart) {
        super(ActionMessages.BreakpointLocationVerifierJob_breakpoint_location);
        this.fBreakpoint = breakpoint;
        this.fLineNumber = lineNumber;
        this.fTypeName = typeName;
        this.fType = type;
        this.fResource = resource;
        this.fEditorPart = editorPart;
    }

    public boolean belongsTo(Object family) {
        return family == FAMILY;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            ModuleNode module;
            if (this.fBreakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
            }
            if ((module = (ModuleNode)Adapters.adapt((Object)this.fEditorPart, ModuleNode.class)) != null) {
                ASTNode found = new BreakpointLocationFinder(module).findBreakpointLocation(this.fLineNumber);
                if (found instanceof ClassNode && ((ClassNode)found).getNameEnd() > 0) {
                    this.createNewClassBreakpoint((ClassNode)found, (LocationSupport)module.getNodeMetaData(LocationSupport.class));
                } else if (found instanceof FieldNode && ((FieldNode)found).getNameEnd() > 0) {
                    this.createNewFieldBreakpoint((FieldNode)found, (LocationSupport)module.getNodeMetaData(LocationSupport.class));
                } else if (found instanceof MethodNode && ((MethodNode)found).getNameEnd() > 0) {
                    this.createNewMethodBreakpoint((MethodNode)found, (LocationSupport)module.getNodeMetaData(LocationSupport.class));
                } else if (found != null) {
                    this.createNewLineBreakpoint(found);
                }
                if (found != null) {
                    return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), ActionMessages.BreakpointLocationVerifierJob_breakpoint_set);
                }
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log((IStatus)new Status(2, JDIDebugUIPlugin.getUniqueIdentifier(), "Breakpoint location verification failed", (Throwable)e));
        }
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(() -> {
            IEditorStatusLine statusLine = (IEditorStatusLine)Adapters.adapt((Object)this.fEditorPart, IEditorStatusLine.class);
            if (statusLine != null) {
                statusLine.setMessage(true, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
            }
            if (JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                Display.getCurrent().beep();
            }
        });
        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), ActionMessages.BreakpointLocationVerifierJob_not_valid_location);
    }

    private void createNewLineBreakpoint(ASTNode node) throws CoreException {
        if (JDIDebugModel.lineBreakpointExists((String)this.fTypeName, (int)node.getLineNumber()) == null) {
            HashMap newAttributes = new HashMap();
            int start = node.getStart();
            int end = node.getEnd();
            if (this.fType != null) {
                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(newAttributes, (IJavaElement)this.fType, (int)start, (int)end);
            }
            JDIDebugModel.createLineBreakpoint((IResource)this.fResource, (String)this.fTypeName, (int)node.getLineNumber(), (int)start, (int)end, (int)0, (boolean)true, newAttributes);
        }
    }

    private void createNewClassBreakpoint(ClassNode node, LocationSupport locator) throws CoreException {
        if (this.fType != null) {
            int start = node.getNameStart();
            int end = node.getNameEnd();
            IJavaElement element = this.fType.getTypeRoot().getElementAt(start);
            if (element != null) {
                int memberType = !node.isInterface() ? 0 : 1;
                HashMap attributes = new HashMap();
                BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)element);
                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(attributes, (IJavaElement)element, (int)start, (int)end);
                JDIDebugModel.createClassPrepareBreakpoint((IResource)this.fResource, (String)node.getName(), (int)memberType, (int)start, (int)end, (boolean)true, attributes);
            }
        }
    }

    private void createNewFieldBreakpoint(FieldNode node, LocationSupport locator) throws CoreException {
        if (this.fType != null) {
            int start = node.getNameStart();
            int end = node.getNameEnd();
            IJavaElement element = this.fType.getTypeRoot().getElementAt(start);
            if (element != null) {
                int lineNumber = locator.getRowCol(start)[0];
                HashMap attributes = new HashMap();
                BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)element);
                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(attributes, (IJavaElement)element, (int)start, (int)end);
                JDIDebugModel.createWatchpoint((IResource)this.fResource, (String)node.getDeclaringClass().getName(), (String)node.getName(), (int)lineNumber, (int)start, (int)end, (int)0, (boolean)true, attributes);
            }
        }
    }

    private void createNewMethodBreakpoint(MethodNode node, LocationSupport locator) throws CoreException {
        if (this.fType != null) {
            int start = node.getNameStart();
            int end = node.getNameEnd();
            IJavaElement element = this.fType.getTypeRoot().getElementAt(start);
            if (element != null) {
                int lineNumber = locator.getRowCol(start)[0];
                HashMap attributes = new HashMap();
                BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)element);
                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(attributes, (IJavaElement)element, (int)start, (int)end);
                JDIDebugModel.createMethodBreakpoint((IResource)this.fResource, (String)node.getDeclaringClass().getName(), (String)node.getName(), (String)BreakpointLocationVerifierJob.createMethodSignature(node), (boolean)true, (boolean)false, (boolean)false, (int)lineNumber, (int)start, (int)end, (int)0, (boolean)true, attributes);
            }
        }
    }

    private static String createMethodSignature(MethodNode node) {
        String[] parameterTypes = GroovyUtils.getParameterTypeSignatures((MethodNode)node, (boolean)true);
        String returnType = GroovyUtils.getTypeSignature((ClassNode)node.getReturnType(), (boolean)true, (boolean)true);
        return Signature.createMethodSignature((String[])parameterTypes, (String)returnType).replace('.', '/');
    }
}

