/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.debug.ui.ForceDetailFormatter;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jface.preference.IPreferenceStore;

public class GroovyDebugOptionsEnforcer {
    private final IPreferenceStore preferenceStore = JDIDebugUIPlugin.getDefault().getPreferenceStore();

    public void force() {
        this.forceDetailFormatter();
        this.forceLogicalStructure();
        this.forceStepThroughFilters();
    }

    public void maybeForce(IPreferenceStore store) {
        if (store.getBoolean("groovy.debug.force_options")) {
            this.force();
            store.setValue("groovy.debug.force_options", false);
        }
    }

    private void forceDetailFormatter() {
        new ForceDetailFormatter().forceReferenceFormatter();
    }

    private void forceLogicalStructure() {
    }

    private void forceStepThroughFilters() {
        String groovyInternalPackages = GroovyPlugin.getDefault().getPreferenceStore().getDefaultString("groovy.debug.filter.list");
        Set defaultFilters = Arrays.stream(JavaDebugOptionsManager.parseList((String)groovyInternalPackages)).map(p -> p + ".*").collect(Collectors.toSet());
        TreeSet<String> activeFilters = new TreeSet<String>(defaultFilters);
        Collections.addAll(activeFilters, JavaDebugOptionsManager.parseList((String)this.preferenceStore.getString(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST)));
        activeFilters.remove("java.lang.ClassLoader");
        activeFilters.remove("java.lang.reflect.*");
        activeFilters.add("java.*");
        TreeSet inactiveFilters = new TreeSet();
        Collections.addAll(inactiveFilters, JavaDebugOptionsManager.parseList((String)this.preferenceStore.getString(IJDIPreferencesConstants.PREF_INACTIVE_FILTERS_LIST)));
        inactiveFilters.removeAll(activeFilters);
        DebugPlugin.setUseStepFilters((boolean)true);
        this.preferenceStore.setValue(IJDIPreferencesConstants.PREF_STEP_THRU_FILTERS, true);
        this.preferenceStore.setValue(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST, JavaDebugOptionsManager.serializeList((String[])activeFilters.toArray(new String[activeFilters.size()])));
        this.preferenceStore.setValue(IJDIPreferencesConstants.PREF_INACTIVE_FILTERS_LIST, JavaDebugOptionsManager.serializeList((String[])inactiveFilters.toArray(new String[inactiveFilters.size()])));
    }
}

