/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug.ui;

import java.util.HashMap;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.debug.ui.BreakpointLocationVerifierJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    public static final Object TOGGLE_BREAKPOINT_FAMILY = new Object();

    protected static IResource getResource(IEditorPart editor) {
        IResource resource = (IResource)Adapters.adapt((Object)editor.getEditorInput(), IFile.class);
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    public ToggleBreakpointAdapter() {
        ActionDelegateHelper.getDefault();
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleBreakpoints(part, selection);
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleBreakpoints(part, selection);
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleBreakpoints(part, selection);
    }

    public void toggleBreakpoints(final IWorkbenchPart part, final ISelection selection) {
        Job job = new Job("Toggle Breakpoint"){

            public boolean belongsTo(Object family) {
                return family == TOGGLE_BREAKPOINT_FAMILY;
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (selection instanceof ITextSelection) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    ToggleBreakpointAdapter.this.report(null, part);
                    IEditorPart editorPart = (IEditorPart)part;
                    ITextSelection textSelection = (ITextSelection)selection;
                    IType type = ToggleBreakpointAdapter.this.getType(textSelection);
                    IEditorInput editorInput = editorPart.getEditorInput();
                    IDocumentProvider documentProvider = ((ITextEditor)editorPart).getDocumentProvider();
                    if (documentProvider == null) {
                        return Status.CANCEL_STATUS;
                    }
                    IDocument document = documentProvider.getDocument((Object)editorInput);
                    int lineNumber = textSelection.getStartLine() + 1;
                    int offset = textSelection.getOffset();
                    try {
                        IClassFile classFile;
                        if (type == null && (classFile = (IClassFile)Adapters.adapt((Object)editorInput, IClassFile.class)) instanceof IOrdinaryClassFile && (type = ((IOrdinaryClassFile)classFile).getType()).getDeclaringType() != null) {
                            ISourceRange sourceRange = type.getSourceRange();
                            int start = sourceRange.getOffset();
                            int end = start + sourceRange.getLength();
                            if (offset < start || offset > end) {
                                IStatusLineManager statusLine = editorPart.getEditorSite().getActionBars().getStatusLineManager();
                                statusLine.setErrorMessage(NLS.bind((String)"Breakpoints can only be created within the type associated with the editor: {0}.", (Object[])new Object[]{type.getTypeQualifiedName()}));
                                Display.getCurrent().beep();
                                return Status.OK_STATUS;
                            }
                        }
                        Object typeName = null;
                        IResource resource = null;
                        HashMap attributes = new HashMap(10);
                        if (type == null) {
                            ICompilationUnit unit;
                            ModuleNode node;
                            resource = ToggleBreakpointAdapter.getResource(editorPart);
                            if (editorPart instanceof ITextEditor && (node = (ModuleNode)Adapters.adapt((Object)editorInput, ModuleNode.class)) != null) {
                                for (ClassNode clazz : node.getClasses()) {
                                    if (offset < clazz.getStart() || offset > clazz.getEnd() || clazz.isInterface()) continue;
                                    typeName = clazz.getName();
                                    break;
                                }
                            }
                            if (typeName == null && (unit = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource))) != null) {
                                IType[] types = unit.getAllTypes();
                                int i = 0;
                                while (i < types.length) {
                                    int begin = types[i].getSourceRange().getOffset();
                                    int end = begin + types[i].getSourceRange().getLength();
                                    if (offset >= begin && offset <= end && !types[i].isInterface()) {
                                        typeName = types[i].getPackageFragment().getElementName() + "." + types[i].getTypeQualifiedName();
                                        break;
                                    }
                                    ++i;
                                }
                            }
                        } else {
                            typeName = type.getFullyQualifiedName();
                            int index = ((String)typeName).indexOf(36);
                            if (index >= 0) {
                                typeName = ((String)typeName).substring(0, index);
                            }
                            resource = BreakpointUtils.getBreakpointResource((IMember)type);
                            try {
                                IRegion line = document.getLineInformation(lineNumber - 1);
                                int start = line.getOffset();
                                int end = start + line.getLength() - 1;
                                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(attributes, (IJavaElement)type, (int)start, (int)end);
                            }
                            catch (BadLocationException ble) {
                                JDIDebugUIPlugin.log((Throwable)ble);
                            }
                        }
                        if (typeName != null) {
                            IJavaLineBreakpoint existingBreakpoint = JDIDebugModel.lineBreakpointExists((String)typeName, (int)lineNumber);
                            if (existingBreakpoint != null) {
                                ToggleBreakpointAdapter.this.removeBreakpoint((IBreakpoint)existingBreakpoint, true);
                                return Status.OK_STATUS;
                            }
                            if (resource != null) {
                                boolean register = true;
                                int charStart = -1;
                                int charEnd = -1;
                                int hitCount = 0;
                                IJavaLineBreakpoint breakpoint = JDIDebugModel.createLineBreakpoint((IResource)resource, (String)typeName, (int)lineNumber, (int)charStart, (int)charEnd, (int)hitCount, (boolean)register, attributes);
                                new BreakpointLocationVerifierJob(breakpoint, lineNumber, (String)typeName, type, resource, editorPart).schedule();
                            }
                        }
                    }
                    catch (CoreException ce) {
                        return ce.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        this.toggleBreakpoints(part, selection);
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection, boolean bestMatch) {
        this.toggleBreakpoints(part, selection);
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        this.toggleBreakpoints(part, selection);
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        this.toggleBreakpoints(part, selection);
    }

    protected IType getType(ITextSelection selection) {
        IMember member = ActionDelegateHelper.getDefault().getCurrentMember(selection);
        IType type = null;
        if (member instanceof IType) {
            type = (IType)member;
        } else if (member != null) {
            type = member.getDeclaringType();
        }
        try {
            while (type != null && !type.isBinary() && type.isLocal()) {
                type = type.getDeclaringType();
            }
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log((Throwable)e);
        }
        return type;
    }

    private void removeBreakpoint(IBreakpoint breakpoint, boolean delete) throws CoreException {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, delete);
    }

    protected void report(String message, IWorkbenchPart part) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(() -> {
            IEditorStatusLine statusLine = (IEditorStatusLine)Adapters.adapt((Object)part, IEditorStatusLine.class);
            if (statusLine != null) {
                statusLine.setMessage(true, message, null);
            }
            if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                JDIDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
            }
        });
    }
}

