/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.mining;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.jdt.groovy.ast.MethodNodeWithNamedParams;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineContentCodeMining;

public class MethodParameterCodeMiningProvider
extends AbstractCodeMiningProvider {
    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        return CompletableFuture.supplyAsync(() -> {
            GroovyCompilationUnit compilationUnit;
            if (!monitor.isCanceled() && (compilationUnit = (GroovyCompilationUnit)this.getAdapter(GroovyCompilationUnit.class)) != null && compilationUnit.isConsistent()) {
                int[] lastLine = new int[1];
                ArrayList codeMinings = new ArrayList();
                TypeInferencingVisitorWithRequestor codeVisitor = new TypeInferencingVisitorFactory().createVisitor(compilationUnit);
                codeVisitor.visitCompilationUnit((node, result, enclosingElement) -> {
                    if (node.getEnd() > 0 && !(node instanceof MethodNode) && result.declaration instanceof MethodNode && DefaultGroovyMethods.asBoolean((Object[])((MethodNode)result.declaration).getParameters())) {
                        MethodCall methodCall = null;
                        if (node instanceof MethodCall) {
                            methodCall = (MethodCall)node;
                        } else if (node instanceof ConstantExpression && result.scope.getEnclosingNode() instanceof MethodCall) {
                            methodCall = (MethodCall)result.scope.getEnclosingNode();
                            assert (node.getText().equals(methodCall.getMethodAsString()));
                        }
                        if (methodCall != null) {
                            this.provideMethodCallCodeMinings(codeMinings, methodCall, (MethodNode)result.declaration, result.isGroovy);
                        }
                        if (node.getLineNumber() > lastLine[0]) {
                            nArray[0] = node.getLineNumber();
                            if (monitor.isCanceled()) {
                                return ITypeRequestor.VisitStatus.STOP_VISIT;
                            }
                        }
                    }
                    return ITypeRequestor.VisitStatus.CONTINUE;
                });
                return codeMinings;
            }
            return null;
        });
    }

    private void provideMethodCallCodeMinings(List<ICodeMining> codeMinings, MethodCall methodCall, MethodNode methodNode, boolean isGroovyMethod) {
        if (methodCall.getArguments() instanceof ArgumentListExpression) {
            int i = isGroovyMethod ? 1 : 0;
            Parameter[] parameters = methodNode instanceof MethodNodeWithNamedParams ? ((MethodNodeWithNamedParams)methodNode).getPositionalParams() : methodNode.getParameters();
            for (Expression argument : (ArgumentListExpression)methodCall.getArguments()) {
                Parameter parameter = parameters[Math.min(i++, parameters.length - 1)];
                codeMinings.add(this.newMethodParameterCodeMining(argument, parameter));
            }
        }
    }

    private ICodeMining newMethodParameterCodeMining(Expression argument, Parameter parameter) {
        LineContentCodeMining codeMining = new LineContentCodeMining(new Position(argument.getStart(), 1), (ICodeMiningProvider)this){};
        codeMining.setLabel(parameter.getName() + ":");
        return codeMining;
    }
}

