/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.preferences;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.builder.ConvertLegacyProject;
import org.codehaus.groovy.eclipse.preferences.FieldEditorOverlayPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GroovyPreferencePage
extends FieldEditorOverlayPage
implements IWorkbenchPreferencePage {
    public GroovyPreferencePage() {
        super(1);
        this.setPreferenceStore(GroovyPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    @Override
    protected String getPageId() {
        return "org.codehaus.groovy.eclipse.preferences";
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new RadioGroupFieldEditor("groovy.scripts.workingdir", "Default working directory for running Groovy scripts\n  (will not change the working directory of existing scripts)", 1, (String[][])new String[][]{{"Eclipse home", "eclipse_home"}, {"Project home", "proj_home"}, {"Script location", "script_loc"}}, this.getFieldEditorParent()));
        new Label(this.getFieldEditorParent(), 0).setText("");
        this.addField((FieldEditor)new BooleanFieldEditor("groovy.junit.monospace.font", "&Use monospace font for JUnit (deprecated)", this.getFieldEditorParent()));
        new Label(this.getFieldEditorParent(), 16448).setText("  This is particularly useful for testing with the assert keyword");
        IProject[] oldProjects = new ConvertLegacyProject().getAllOldProjects();
        if (oldProjects.length > 0) {
            new Label(this.getFieldEditorParent(), 0).setText("");
            Label label = new Label(this.getFieldEditorParent(), 16448);
            label.setText("The following legacy groovy projects exist in the workspace:\n");
            final List oldProjectsList = new List(this.getFieldEditorParent(), 514);
            oldProjectsList.setItems((String[])Arrays.stream(oldProjects).map(IResource::getName).toArray(String[]::new));
            label = new Label(this.getFieldEditorParent(), 16448);
            label.setText("Select the projects to convert.");
            Button button = new Button(this.getFieldEditorParent(), 8);
            button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GroovyPreferencePage.this.convertSelectedProjects(oldProjectsList.getSelection());
                    IProject[] oldProjects = new ConvertLegacyProject().getAllOldProjects();
                    oldProjectsList.setItems((String[])Arrays.stream(oldProjects).map(IResource::getName).toArray(String[]::new));
                }
            });
            button.setText("Convert");
        }
    }

    private void convertSelectedProjects(String[] selection) {
        if (selection.length == 0) {
            return;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = (IProject[])Arrays.stream(selection).map(s -> root.getProject(s)).toArray(IProject[]::new);
        try {
            new ConvertLegacyProject().convertProjects(projects);
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Successful conversion", (String)("The following projects have been converted:\n" + Arrays.stream(selection).collect(Collectors.joining("\n"))));
        }
        catch (Exception e) {
            GroovyCore.logException((String)"Failure when converting legacy projects", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error converting projects", (String)"There has been an error converting the projects.  See the error log.");
        }
    }
}

