/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import java.lang.reflect.InvocationTargetException;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.corext.codemanipulation.AddImportsOperation;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.AddImportOnSelectionAction;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public abstract class AddImportOnSelectionAdapter
extends AddImportOnSelectionAction {
    private static Class<? extends AddImportsOperation.IChooseImportQuery> SELECT_TYPE_QUERY;

    static {
        try {
            SELECT_TYPE_QUERY = (Class)Class.class.cast(Class.forName("org.eclipse.jdt.internal.ui.javaeditor.AddImportOnSelectionAction$SelectTypeQuery"));
        }
        catch (Exception e) {
            GroovyPlugin.getDefault().logError("Failed to locate SelectTypeQuery", e);
        }
    }

    public AddImportOnSelectionAdapter(CompilationUnitEditor editor) {
        super(editor);
    }

    protected abstract AddImportOperation newAddImportOperation(GroovyCompilationUnit var1, ITextSelection var2, AddImportsOperation.IChooseImportQuery var3);

    public final void run() {
        ICompilationUnit cu = this.getCompilationUnit();
        if (!(cu instanceof GroovyCompilationUnit)) {
            super.run();
        } else {
            CompilationUnitEditor editor = this.getCompilationUnitEditor();
            Shell shell = editor.getSite().getShell();
            if (cu == null || editor == null) {
                return;
            }
            if (!editor.validateEditorInputState()) {
                return;
            }
            if (!ElementValidator.checkValidateEdit((IJavaElement)cu, (Shell)shell, (String)"Add Import")) {
                return;
            }
            ISelection selection = editor.getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                AddImportsOperation.IChooseImportQuery typeQuery = this.newChooseImportQuery(shell);
                IEditingSupport helper = this.newEditingSupport(textSelection, typeQuery);
                AddImportOperation operation = this.newAddImportOperation((GroovyCompilationUnit)cu, textSelection, typeQuery);
                try {
                    try {
                        IStatusLineManager manager;
                        this.register(helper);
                        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                        progressService.runInUI((IRunnableContext)editor.getSite().getWorkbenchWindow(), (IRunnableWithProgress)operation, (ISchedulingRule)cu.getJavaProject().getResource());
                        IStatus status = operation.getStatus();
                        if (!status.isOK() && (manager = editor.getEditorSite().getActionBars().getStatusLineManager()) != null) {
                            manager.setMessage(status.getMessage());
                        }
                    }
                    catch (InvocationTargetException e) {
                        ExceptionHandler.handle((InvocationTargetException)e, (Shell)shell, (String)"Add Import", null);
                        this.unregister(helper);
                    }
                    catch (InterruptedException interruptedException) {
                        this.unregister(helper);
                    }
                }
                finally {
                    this.unregister(helper);
                }
            }
        }
    }

    private ICompilationUnit getCompilationUnit() {
        CompilationUnitEditor editor = this.getCompilationUnitEditor();
        return editor == null ? null : JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
    }

    private CompilationUnitEditor getCompilationUnitEditor() {
        CompilationUnitEditor editor = (CompilationUnitEditor)ReflectionUtils.getPrivateField(AddImportOnSelectionAction.class, (String)"fEditor", (Object)((Object)this));
        return editor;
    }

    private AddImportsOperation.IChooseImportQuery newChooseImportQuery(Shell shell) {
        return (AddImportsOperation.IChooseImportQuery)ReflectionUtils.invokeConstructor(SELECT_TYPE_QUERY, (Class[])new Class[]{Shell.class}, (Object[])new Object[]{shell});
    }

    private IEditingSupport newEditingSupport(ITextSelection textSelection, AddImportsOperation.IChooseImportQuery typeQuery) {
        return (IEditingSupport)ReflectionUtils.executePrivateMethod(AddImportOnSelectionAction.class, (String)"createViewerHelper", (Class[])new Class[]{ITextSelection.class, SELECT_TYPE_QUERY}, (Object)((Object)this), (Object[])new Object[]{textSelection, typeQuery});
    }

    private void register(IEditingSupport helper) {
        ReflectionUtils.executePrivateMethod(AddImportOnSelectionAction.class, (String)"registerHelper", (Class[])new Class[]{IEditingSupport.class}, (Object)((Object)this), (Object[])new Object[]{helper});
    }

    private void unregister(IEditingSupport helper) {
        ReflectionUtils.executePrivateMethod(AddImportOnSelectionAction.class, (String)"deregisterHelper", (Class[])new Class[]{IEditingSupport.class}, (Object)((Object)this), (Object[])new Object[]{helper});
    }

    public static interface AddImportOperation
    extends IRunnableWithProgress {
        public IStatus getStatus();
    }
}

