/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.actions.GroovyRefactoringAction;
import org.codehaus.groovy.eclipse.refactoring.actions.GroovyRenameLinkedMode;
import org.codehaus.groovy.eclipse.refactoring.actions.IRenameTarget;
import org.codehaus.groovy.eclipse.refactoring.core.rename.CandidateCollector;
import org.codehaus.groovy.eclipse.refactoring.core.rename.JavaRefactoringDispatcher;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class RenameDispatcherAction
extends GroovyRefactoringAction {
    public void run(IAction action) {
        if (this.checkPreconditions()) {
            GroovyCompilationUnit unit = this.getUnit();
            ITextSelection selection = this.getSelection();
            CandidateCollector dispatcher = new CandidateCollector(unit, selection);
            try {
                ISourceReference target = dispatcher.getRefactoringTarget();
                boolean lightweight = JavaPlugin.getDefault().getPreferenceStore().getBoolean("Refactor.lightweight");
                if (!this.runViaAdapter(target, lightweight)) {
                    if (target instanceof IMember || target instanceof ILocalVariable) {
                        if (lightweight && this.nameMatches(((IJavaElement)target).getElementName().toCharArray(), unit, selection)) {
                            new GroovyRenameLinkedMode((IJavaElement)target, this.getEditor()).start();
                        } else {
                            this.openJavaRefactoringWizard((IJavaElement)target);
                        }
                    } else {
                        this.displayErrorDialog("Cannot refactor on current selection. No refactoring candidates found.");
                    }
                }
            }
            catch (CoreException e) {
                this.displayErrorDialog(e.getMessage());
            }
        }
    }

    private boolean nameMatches(char[] elementName, GroovyCompilationUnit unit, ITextSelection selection) {
        char[] contents = unit.getContents();
        int start = Math.min(selection.getOffset(), contents.length - 1);
        int end = Math.min(start + selection.getLength(), contents.length);
        while (start > 0 && Character.isJavaIdentifierPart(contents[start - 1])) {
            --start;
        }
        while (end < contents.length && Character.isJavaIdentifierPart(contents[end])) {
            ++end;
        }
        char[] selectedName = CharOperation.subarray((char[])contents, (int)start, (int)end);
        return selectedName != null && CharOperation.equals((char[])elementName, (char[])selectedName);
    }

    private boolean runViaAdapter(ISourceReference targetParam, boolean lightweight) {
        try {
            IRenameTarget target;
            if (targetParam instanceof IAdaptable && (target = (IRenameTarget)Adapters.adapt((Object)targetParam, IRenameTarget.class)) != null) {
                return target.performRenameAction(this.getShell(), (AbstractTextEditor)this.getEditor(), lightweight);
            }
        }
        catch (Exception e) {
            GroovyCore.logException((String)"", (Throwable)e);
        }
        return false;
    }

    private void openJavaRefactoringWizard(IJavaElement element) throws CoreException {
        JavaRefactoringDispatcher dispatcher = new JavaRefactoringDispatcher(element);
        RenameSupport refactoring = dispatcher.dispatchJavaRenameRefactoring();
        refactoring.openDialog(this.getShell());
    }

    private Shell getShell() {
        return this.getEditor().getSite().getShell();
    }
}

