/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.core;

import com.kms.katalon.objectspy.core.HTMLElementCollector;
import com.kms.katalon.objectspy.core.HTMLElementServlet;
import jakarta.servlet.Servlet;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

public class HTMLElementCaptureServer {
    protected Server server;
    protected boolean isUsingDynamicPort = false;
    protected ServletContextHandler context;

    public HTMLElementCaptureServer(int port, Class<?> socketClass) {
        this.server = new Server(port);
        this.context = new ServletContextHandler(1);
        this.context.setContextPath("/");
        this.server.setHandler((Handler)this.context);
        try {
            JakartaWebSocketServletContainerInitializer.configure((ServletContextHandler)this.context, (servletContext, container) -> container.addEndpoint(socketClass));
            System.out.println(socketClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HTMLElementCaptureServer(HTMLElementCollector objectSpyDialog, Class<?> socketClass) {
        this(0, objectSpyDialog, socketClass);
        this.isUsingDynamicPort = true;
    }

    public HTMLElementCaptureServer(int port, HTMLElementCollector objectSpyDialog, Class<?> socketClass) {
        this(port, socketClass);
        this.addServlets(objectSpyDialog, this.context);
    }

    protected void addServlets(HTMLElementCollector objectSpyDialog, ServletContextHandler context) {
        context.addServlet(new ServletHolder((Servlet)new HTMLElementServlet(objectSpyDialog)), "/*");
    }

    public void start() throws Exception {
        this.server.start();
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public boolean isStarted() {
        return this.server.isStarted() && this.server.getConnectors().length > 0 && this.server.getConnectors()[0] != null;
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public String getServerUrl() {
        if (this.isStarted()) {
            return "http://localhost:" + this.getServerPort() + "/";
        }
        return "";
    }

    public int getServerPort() {
        if (this.isStarted()) {
            return ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
        }
        return -1;
    }

    public boolean isUsingDynamicPort() {
        return this.isUsingDynamicPort;
    }
}

