/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.element.tree;

import com.kms.katalon.objectspy.constants.ImageConstants;
import com.kms.katalon.objectspy.element.DomElementXpath;
import com.kms.katalon.objectspy.element.HTMLRawElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Node;

public class HTMLRawElementLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider {
    private static Color BROWN = null;
    private List<String> filteredElementsXpath;

    public HTMLRawElementLabelProvider() {
        if (BROWN == null || BROWN.isDisposed()) {
            BROWN = new Color((Device)Display.getCurrent(), 124, 84, 50);
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (BROWN != null) {
            BROWN.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        cell.setText(this.getText(element));
        if (!(element instanceof HTMLRawElement)) {
            super.update(cell);
            return;
        }
        HTMLRawElement htmlRawElement = (HTMLRawElement)element;
        if (this.filteredElementsXpath == null) {
            super.update(cell);
            return;
        }
        String elementAbsoluteXpath = htmlRawElement.getAbsoluteXpath();
        boolean isSelected = this.filteredElementsXpath.contains(elementAbsoluteXpath);
        int textLength = cell.getText().length();
        ArrayList<StyleRange> range = new ArrayList<StyleRange>();
        Color backgroundColor = null;
        Color foreGroundColor = null;
        Color darkMagenta = Display.getCurrent().getSystemColor(12);
        if (isSelected) {
            backgroundColor = Display.getCurrent().getSystemColor(7);
            foreGroundColor = Display.getCurrent().getSystemColor(2);
        }
        range.add(new StyleRange(0, htmlRawElement.getTag().length() + 1, foreGroundColor != null ? foreGroundColor : darkMagenta, backgroundColor));
        range.add(new StyleRange(textLength - 1, textLength, foreGroundColor != null ? foreGroundColor : darkMagenta, backgroundColor));
        int currentPosition = htmlRawElement.getTag().length() + 1;
        int i = 0;
        while (i < htmlRawElement.getAttributes().getLength()) {
            range.add(new StyleRange(currentPosition, currentPosition + 1, null, backgroundColor));
            Node attribute = htmlRawElement.getAttributes().item(i);
            range.add(new StyleRange(currentPosition, ++currentPosition + attribute.getNodeName().length(), foreGroundColor != null ? foreGroundColor : BROWN, backgroundColor));
            range.add(new StyleRange(currentPosition, (currentPosition += attribute.getNodeName().length()) + "='".length(), foreGroundColor != null ? foreGroundColor : darkMagenta, backgroundColor));
            range.add(new StyleRange(currentPosition, (currentPosition += "='".length()) + attribute.getNodeValue().length(), foreGroundColor != null ? foreGroundColor : Display.getCurrent().getSystemColor(10), backgroundColor));
            range.add(new StyleRange(currentPosition, (currentPosition += attribute.getNodeValue().length()) + "'".length(), foreGroundColor != null ? foreGroundColor : darkMagenta, backgroundColor));
            currentPosition += "'".length();
            ++i;
        }
        cell.setStyleRanges(range.toArray(new StyleRange[range.size()]));
        cell.setImage(this.getImage(cell.getElement()));
        super.update(cell);
    }

    public Image getImage(Object element) {
        if (element instanceof HTMLRawElement) {
            return ImageConstants.IMG_16_TEST_OBJECT;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof HTMLRawElement) {
            return ((HTMLRawElement)element).toString();
        }
        return null;
    }

    public void setFilteredElements(List<DomElementXpath> filteredElements) {
        if (this.filteredElementsXpath == null) {
            this.filteredElementsXpath = new ArrayList<String>();
        }
        this.filteredElementsXpath.clear();
        if (filteredElements != null) {
            for (DomElementXpath filteredElement : filteredElements) {
                this.filteredElementsXpath.add(filteredElement.getXpath());
            }
        }
    }
}

