/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.model;

import com.atlassian.oai.validator.model.ApiPath;
import com.atlassian.oai.validator.model.NormalisedPath;
import com.atlassian.oai.validator.model.NormalisedPathImpl;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApiPathImpl
extends NormalisedPathImpl
implements ApiPath {
    private static final String PARAM_REGEX = "\\{(.*?)}";
    private static final Pattern PARAM_PATTERN = Pattern.compile("\\{(.*?)}");
    private static final char PARAM_START = '{';
    private static final char PARAM_END = '}';

    public ApiPathImpl(@Nonnull String path, @Nullable String apiPrefix) {
        super(path, apiPrefix);
    }

    @Override
    public boolean matches(NormalisedPath requestPath) {
        if (this.numberOfParts() != requestPath.numberOfParts()) {
            return false;
        }
        for (int i = 0; i < this.numberOfParts(); ++i) {
            if (this.partMatches(i, requestPath.part(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean partMatches(int index, @Nonnull String requestPathPart) {
        Objects.requireNonNull(requestPathPart, "A request path part is required");
        String template = this.part(index);
        Pattern templatePattern = Pattern.compile(Pattern.quote(template).replaceAll(PARAM_REGEX, "\\\\E(.*?)\\\\Q"), 2);
        return templatePattern.matcher(requestPathPart).matches();
    }

    @Override
    public boolean hasParams(int index) {
        String part = this.part(index);
        return PARAM_PATTERN.matcher(part).find();
    }

    @Override
    public List<String> paramNames(int index) {
        String part = this.part(index);
        Matcher matcher = PARAM_PATTERN.matcher(part);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }

    @Override
    public Map<String, Optional<String>> paramValues(int index, String requestPathPart) {
        List<String> paramNames = this.paramNames(index);
        if (paramNames.isEmpty()) {
            return Collections.emptyMap();
        }
        String template = this.part(index);
        if (paramNames.size() == 1 && template.indexOf(123) == 0 && template.indexOf(125) == template.length() - 1) {
            return ImmutableMap.of((Object)paramNames.get(0), Optional.of(requestPathPart));
        }
        HashMap<String, Optional<String>> result = new HashMap<String, Optional<String>>();
        int templateScanner = 0;
        int requestScanner = 0;
        int paramIndex = 0;
        while (templateScanner < template.length() && requestScanner < requestPathPart.length()) {
            if (template.charAt(templateScanner) == '{') {
                int paramValueStart = requestScanner;
                while (templateScanner < template.length() && template.charAt(templateScanner) != '}') {
                    ++templateScanner;
                }
                if (templateScanner == template.length() || template.charAt(templateScanner) != '}') break;
                if (templateScanner == template.length() - 1) {
                    result.put(paramNames.get(paramIndex++), Optional.of(requestPathPart.substring(paramValueStart)));
                    break;
                }
                char terminal = Character.toLowerCase(template.charAt(++templateScanner));
                while (requestScanner < requestPathPart.length() && Character.toLowerCase(requestPathPart.charAt(requestScanner)) != terminal) {
                    ++requestScanner;
                }
                if (Character.toLowerCase(requestPathPart.charAt(requestScanner)) != terminal) break;
                result.put(paramNames.get(paramIndex++), Optional.of(requestPathPart.substring(paramValueStart, requestScanner)));
                continue;
            }
            if (Character.toLowerCase(template.charAt(templateScanner)) != Character.toLowerCase(requestPathPart.charAt(requestScanner))) break;
            ++templateScanner;
            ++requestScanner;
        }
        while (paramIndex < paramNames.size()) {
            result.put(paramNames.get(paramIndex++), Optional.empty());
        }
        return result;
    }
}

