/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.util;

import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.Response;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ContentTypeUtils {
    private ContentTypeUtils() {
    }

    public static boolean isJsonContentType(Request request) {
        return ContentTypeUtils.isJsonContentType(request.getContentType().orElse(null));
    }

    public static boolean isJsonContentType(Response response) {
        return ContentTypeUtils.isJsonContentType(response.getContentType().orElse(null));
    }

    public static boolean isJsonContentType(@Nullable String contentType) {
        Optional<MediaType> optionalMediaType = ContentTypeUtils.parseContentType(contentType);
        return optionalMediaType.map(mediaType -> {
            if (mediaType.withoutParameters().is(MediaType.JSON_UTF_8.withoutParameters())) {
                return true;
            }
            if (mediaType.type().equals("application")) {
                return mediaType.subtype().endsWith("+json");
            }
            return false;
        }).orElse(false);
    }

    public static boolean isFormDataContentType(Request request) {
        return ContentTypeUtils.isFormDataContentType(request.getContentType().orElse(null));
    }

    public static boolean isFormDataContentType(Response response) {
        return ContentTypeUtils.isFormDataContentType(response.getContentType().orElse(null));
    }

    public static boolean isFormDataContentType(@Nullable String contentType) {
        return ContentTypeUtils.matches(contentType, MediaType.FORM_DATA);
    }

    public static boolean isMultipartFormDataContentType(@Nullable String contentType) {
        return contentType != null && contentType.startsWith("multipart/");
    }

    public static boolean matches(@Nullable String contentType, MediaType expected) {
        if (contentType == null) {
            return false;
        }
        try {
            MediaType mediaType = MediaType.parse((String)contentType);
            return expected.withoutParameters().is(mediaType.withoutParameters());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isMultipartContentTypeAcceptedByConsumer(@Nullable String requestContentType, @Nullable String consumesContentType) {
        if (requestContentType == null || consumesContentType == null) {
            return false;
        }
        if (!requestContentType.startsWith("multipart/") || !consumesContentType.startsWith("multipart/")) {
            return false;
        }
        Optional<String> consumesContentTypeBoundary = ContentTypeUtils.extractMultipartBoundary(consumesContentType);
        if (consumesContentTypeBoundary.isPresent()) {
            return requestContentType.trim().equals(consumesContentType.trim().toLowerCase());
        }
        return requestContentType.trim().toLowerCase().startsWith(consumesContentType.trim().toLowerCase());
    }

    @Nonnull
    public static Optional<String> extractMultipartBoundary(String multipartContentType) {
        String[] split = multipartContentType.split("=", 2);
        if (split.length < 2) {
            return Optional.empty();
        }
        return Optional.of(split[1]);
    }

    public static boolean hasContentType(Request request) {
        return request.getHeaderValue("Content-Type").isPresent();
    }

    public static boolean hasContentType(Response response) {
        return response.getHeaderValue("Content-Type").isPresent();
    }

    public static Optional<String> findMostSpecificMatch(Response response, Set<String> apiContentTypes) {
        return ContentTypeUtils.findMostSpecificMatch(response.getHeaderValue("Content-Type").orElse("*/*"), apiContentTypes);
    }

    public static Optional<String> findMostSpecificMatch(Request request, Set<String> apiContentTypes) {
        return ContentTypeUtils.findMostSpecificMatch(request.getHeaderValue("Content-Type").orElse("*/*"), apiContentTypes);
    }

    public static Optional<String> findMostSpecificMatch(String candidate, Set<String> apiContentTypes) {
        try {
            return apiContentTypes.stream().map(ParsedContentType::of).sorted(new ParsedContentTypeComparator()).filter(ct -> ct.matches(candidate)).map(ParsedContentType::getContentType).findFirst();
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static boolean matchesAny(String candidate, Collection<String> apiContentTypes) {
        if (candidate == null || candidate.isEmpty()) {
            return false;
        }
        return ContentTypeUtils.matchesAny(MediaType.parse((String)candidate), apiContentTypes);
    }

    public static boolean matchesAny(MediaType candidate, Collection<String> apiContentTypes) {
        return apiContentTypes.stream().map(MediaType::parse).anyMatch(apiMediaType -> candidate.withoutParameters().is(apiMediaType.withoutParameters()));
    }

    public static Optional<Charset> getCharsetFromContentType(@Nullable String contentType) {
        return ContentTypeUtils.parseContentType(contentType).flatMap(m -> Optional.ofNullable((Charset)m.charset().orNull()));
    }

    public static Optional<Charset> getCharsetFromContentType(@Nullable Multimap<String, String> headers) {
        if (headers != null) {
            String contentType = (String)Iterables.getFirst((Iterable)headers.get((Object)"Content-Type"), null);
            return ContentTypeUtils.getCharsetFromContentType(contentType);
        }
        return Optional.empty();
    }

    public static boolean containsGlobalAccept(Collection<String> apiContentTypes) {
        return apiContentTypes.stream().anyMatch(c -> c.equals("*/*"));
    }

    private static Optional<MediaType> parseContentType(@Nullable String contentType) {
        if (contentType == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(MediaType.parse((String)contentType));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private static class ParsedContentTypeComparator
    implements Comparator<ParsedContentType> {
        private ParsedContentTypeComparator() {
        }

        @Override
        public int compare(ParsedContentType o1, ParsedContentType o2) {
            return this.countWildcards(o1.getMediaType()) - this.countWildcards(o2.getMediaType());
        }

        private int countWildcards(MediaType mt) {
            int result = 0;
            if (mt.type().equals("*")) {
                ++result;
            }
            if (mt.subtype().equals("*")) {
                ++result;
            }
            return result;
        }
    }

    private static class ParsedContentType {
        private final String contentType;
        private final MediaType mediaType;

        static ParsedContentType of(String contentType) {
            return new ParsedContentType(contentType, MediaType.parse((String)contentType));
        }

        private ParsedContentType(String contentType, MediaType mediaType) {
            this.contentType = contentType;
            this.mediaType = mediaType;
        }

        boolean matches(String contentType) {
            return MediaType.parse((String)contentType).withoutParameters().is(this.mediaType.withoutParameters());
        }

        public String getContentType() {
            return this.contentType;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }
    }
}

