/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webservice.setting;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.webservice.setting.IWebServiceExecutionSettingStore;
import java.io.IOException;
import org.osgi.framework.FrameworkUtil;

public class WebServiceExecutionSettingStore
extends BundleSettingStore
implements IWebServiceExecutionSettingStore {
    public static final int EXECUTION_DEFAULT_CONNECTION_TIMEOUT_MS = 0;
    public static final int EXECUTION_DEFAULT_SOCKET_TIMEOUT_MS = 0;
    public static final long EXECUTION_DEFAULT_MAX_RESPONSE_SIZE = 0L;
    public static final boolean EXECUTION_DEFAULT_FOLLOW_REDIRECTS = false;

    public static WebServiceExecutionSettingStore getStore() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        return projectEntity == null ? null : new WebServiceExecutionSettingStore(projectEntity);
    }

    public WebServiceExecutionSettingStore(ProjectEntity projectEntity) {
        super(projectEntity.getFolderLocation(), FrameworkUtil.getBundle(WebServiceExecutionSettingStore.class).getSymbolicName(), false);
    }

    public int getConnectionTimeout() throws IOException {
        return this.getInt("execution.webservice.connectionTimeout", 0);
    }

    public void setConnectionTimeout(int connectionTimeout) throws IOException {
        this.setProperty("execution.webservice.connectionTimeout", connectionTimeout);
    }

    public int getSocketTimeout() throws IOException {
        return this.getInt("execution.webservice.socketTimeout", 0);
    }

    public void setSocketTimeout(int socketTimeout) throws IOException {
        this.setProperty("execution.webservice.socketTimeout", socketTimeout);
    }

    public long getMaxResponseSize() throws IOException {
        return this.getInt("execution.webservice.maxResponseSize", 0);
    }

    public void setMaxResponseSize(long maxResponseSize) throws IOException {
        this.setProperty("execution.webservice.maxResponseSize", maxResponseSize);
    }

    public boolean getFollowRedirects() throws IOException {
        return this.getBoolean("execution.webservice.followRedirects", false);
    }

    public void setFollowRedirects(boolean followRedirects) throws IOException {
        this.setProperty("execution.webservice.followRedirects", followRedirects);
    }
}

