/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.junit;

import cucumber.api.PickleStepTestStep;
import cucumber.api.Result;
import cucumber.api.event.EventHandler;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.runner.EventBus;
import cucumber.runtime.junit.JUnitOptions;
import cucumber.runtime.junit.NotificationLevel;
import cucumber.runtime.junit.PickleRunners;
import cucumber.runtime.junit.SkippedThrowable;
import cucumber.runtime.junit.UndefinedThrowable;
import gherkin.pickles.PickleStep;
import java.util.ArrayList;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.MultipleFailureException;

public class JUnitReporter {
    private final boolean strict;
    private final JUnitOptions junitOptions;
    TestNotifier stepNotifier;
    private PickleRunners.PickleRunner pickleRunner;
    private RunNotifier runNotifier;
    TestNotifier pickleRunnerNotifier;
    ArrayList<Throwable> stepErrors;
    private final EventHandler<TestCaseStarted> testCaseStartedHandler = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted event) {
            JUnitReporter.this.handleTestCaseStarted();
        }
    };
    private final EventHandler<TestStepStarted> testStepStartedHandler = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted event) {
            if (event.testStep instanceof PickleStepTestStep) {
                PickleStepTestStep testStep = (PickleStepTestStep)event.testStep;
                JUnitReporter.this.handleStepStarted(testStep.getPickleStep());
            }
        }
    };
    private final EventHandler<TestStepFinished> testStepFinishedHandler = new EventHandler<TestStepFinished>(){

        public void receive(TestStepFinished event) {
            if (event.testStep instanceof PickleStepTestStep) {
                PickleStepTestStep testStep = (PickleStepTestStep)event.testStep;
                JUnitReporter.this.handleStepResult(testStep, event.result);
            } else {
                JUnitReporter.this.handleHookResult(event.result);
            }
        }
    };
    private final EventHandler<TestCaseFinished> testCaseFinishedHandler = new EventHandler<TestCaseFinished>(){

        public void receive(TestCaseFinished event) {
            JUnitReporter.this.handleTestCaseResult(event.result);
        }
    };

    public JUnitReporter(EventBus bus, boolean strict, JUnitOptions junitOption) {
        this.strict = strict;
        this.junitOptions = junitOption;
        bus.registerHandlerFor(TestCaseStarted.class, this.testCaseStartedHandler);
        bus.registerHandlerFor(TestStepStarted.class, this.testStepStartedHandler);
        bus.registerHandlerFor(TestStepFinished.class, this.testStepFinishedHandler);
        bus.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
    }

    void startExecutionUnit(PickleRunners.PickleRunner pickleRunner, RunNotifier runNotifier) {
        this.pickleRunner = pickleRunner;
        this.runNotifier = runNotifier;
        this.stepNotifier = null;
        this.pickleRunnerNotifier = new EachTestNotifier(runNotifier, pickleRunner.getDescription());
    }

    void handleTestCaseStarted() {
        this.pickleRunnerNotifier.fireTestStarted();
        this.stepErrors = new ArrayList();
    }

    void handleStepStarted(PickleStep step) {
        if (this.stepNotifications()) {
            Description description = this.pickleRunner.describeChild(step);
            this.stepNotifier = new EachTestNotifier(this.runNotifier, description);
        } else {
            this.stepNotifier = new NoTestNotifier();
        }
        this.stepNotifier.fireTestStarted();
    }

    boolean stepNotifications() {
        return this.junitOptions.stepNotifications();
    }

    void handleStepResult(PickleStepTestStep testStep, Result result) {
        Throwable error = result.getError();
        switch (result.getStatus()) {
            case PASSED: {
                break;
            }
            case SKIPPED: {
                if (error == null) {
                    error = new SkippedThrowable(NotificationLevel.STEP);
                } else {
                    this.stepErrors.add(error);
                }
                this.stepNotifier.addFailedAssumption(error);
                break;
            }
            case PENDING: {
                this.stepErrors.add(error);
                this.addFailureOrFailedAssumptionDependingOnStrictMode(this.stepNotifier, error);
                break;
            }
            case UNDEFINED: {
                if (error == null) {
                    error = new UndefinedThrowable();
                }
                this.stepErrors.add(new UndefinedThrowable(testStep.getStepText()));
                this.addFailureOrFailedAssumptionDependingOnStrictMode(this.stepNotifier, error);
                break;
            }
            case AMBIGUOUS: 
            case FAILED: {
                this.stepErrors.add(error);
                this.stepNotifier.addFailure(error);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected result status: " + result.getStatus());
            }
        }
        this.stepNotifier.fireTestFinished();
    }

    void handleHookResult(Result result) {
        if (result.getError() != null) {
            this.stepErrors.add(result.getError());
        }
    }

    void handleTestCaseResult(Result result) {
        switch (result.getStatus()) {
            case PASSED: {
                break;
            }
            case SKIPPED: {
                if (this.stepErrors.isEmpty()) {
                    this.stepErrors.add(new SkippedThrowable(NotificationLevel.SCENARIO));
                }
                for (Throwable error : this.stepErrors) {
                    this.pickleRunnerNotifier.addFailedAssumption(error);
                }
                break;
            }
            case PENDING: 
            case UNDEFINED: {
                for (Throwable error : this.stepErrors) {
                    this.addFailureOrFailedAssumptionDependingOnStrictMode(this.pickleRunnerNotifier, error);
                }
                break;
            }
            case AMBIGUOUS: 
            case FAILED: {
                for (Throwable error : this.stepErrors) {
                    this.pickleRunnerNotifier.addFailure(error);
                }
                break;
            }
        }
        this.pickleRunnerNotifier.fireTestFinished();
    }

    boolean useFilenameCompatibleNames() {
        return this.junitOptions.filenameCompatibleNames();
    }

    private void addFailureOrFailedAssumptionDependingOnStrictMode(TestNotifier notifier, Throwable error) {
        if (this.strict) {
            notifier.addFailure(error);
        } else {
            notifier.addFailedAssumption(error);
        }
    }

    private static interface TestNotifier {
        public void fireTestStarted();

        public void addFailure(Throwable var1);

        public void addFailedAssumption(Throwable var1);

        public void fireTestFinished();
    }

    static class EachTestNotifier
    implements TestNotifier {
        private final RunNotifier notifier;
        private final Description description;

        EachTestNotifier(RunNotifier notifier, Description description) {
            this.notifier = notifier;
            this.description = description;
        }

        @Override
        public void addFailure(Throwable targetException) {
            if (targetException instanceof MultipleFailureException) {
                this.addMultipleFailureException((MultipleFailureException)targetException);
            } else {
                this.notifier.fireTestFailure(new Failure(this.description, targetException));
            }
        }

        private void addMultipleFailureException(MultipleFailureException mfe) {
            for (Throwable each : mfe.getFailures()) {
                this.addFailure(each);
            }
        }

        @Override
        public void addFailedAssumption(Throwable e) {
            this.notifier.fireTestAssumptionFailed(new Failure(this.description, e));
        }

        @Override
        public void fireTestFinished() {
            this.notifier.fireTestFinished(this.description);
        }

        @Override
        public void fireTestStarted() {
            this.notifier.fireTestStarted(this.description);
        }
    }

    static final class NoTestNotifier
    implements TestNotifier {
        NoTestNotifier() {
        }

        @Override
        public void fireTestStarted() {
        }

        @Override
        public void addFailure(Throwable error) {
        }

        @Override
        public void addFailedAssumption(Throwable error) {
        }

        @Override
        public void fireTestFinished() {
        }
    }
}

