/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.driver;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.core.driver.IDriverType;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.webui.driver.SeleniumWebDriverProvider;
import com.kms.katalon.execution.webui.driver.WebUiDriverConnector;
import java.io.IOException;
import java.util.Map;

public class ChromeDriverConnector
extends WebUiDriverConnector {
    private String chromeDriverPath;

    public ChromeDriverConnector(String configurationFolderPath) throws IOException {
        super(configurationFolderPath);
        this.setChromeDriverPath(SeleniumWebDriverProvider.getChromeDriverPath());
    }

    public IDriverType getDriverType() {
        return WebUIDriverType.CHROME_DRIVER;
    }

    public Map<String, Object> getSystemProperties() {
        Map propertyMap = super.getSystemProperties();
        propertyMap.put("chromeDriverPath", this.getChromeDriverPath());
        return propertyMap;
    }

    public void updateSystemProperties(Map<String, Object> systemProperties) {
        if (systemProperties.containsKey("chromeDriverPath")) {
            String newDriverPath = systemProperties.get("chromeDriverPath").toString();
            this.setChromeDriverPath(newDriverPath);
        }
    }

    public String getChromeDriverPath() {
        return this.chromeDriverPath;
    }

    public void setChromeDriverPath(String chromeDriverPath) {
        this.chromeDriverPath = chromeDriverPath;
    }

    public IDriverConnector clone() {
        try {
            ChromeDriverConnector iosDriverConnector = new ChromeDriverConnector(this.getParentFolderPath());
            iosDriverConnector.setChromeDriverPath(this.getChromeDriverPath());
            iosDriverConnector.driverProperties = (Map)this.cloneDriverPropertyValue(this.getUserConfigProperties());
            return iosDriverConnector;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

