/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.components;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.execution.components.ListPropertyValueCellEditor;
import com.kms.katalon.composer.execution.components.MapPropertyValueCellEditor;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.provider.ListPropertyLabelProvider;
import com.kms.katalon.core.setting.DriverPropertyValueType;
import com.kms.katalon.util.NumUtil;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class DriverPropertyListComposite
extends Composite {
    private Table table;
    private TableViewer tableViewer;
    private ToolItem tltmAddProperty;
    private ToolItem tltmRemoveProperty;
    private ToolItem tltmClearProperty;

    public DriverPropertyListComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(1808));
        Composite composite = new Composite((Composite)this, 0);
        GridLayout glComposite = new GridLayout(1, false);
        glComposite.marginWidth = 0;
        glComposite.marginHeight = 0;
        composite.setLayout((Layout)glComposite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite toolbarComposite = new Composite(composite, 0);
        toolbarComposite.setLayout((Layout)new FillLayout(256));
        toolbarComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ToolBar toolBar = new ToolBar(toolbarComposite, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.tltmAddProperty = new ToolItem(toolBar, 0);
        this.tltmAddProperty.setText(StringConstants.SETT_TOOLITEM_ADD);
        this.tltmAddProperty.setImage(ImageConstants.IMG_16_ADD);
        this.tltmRemoveProperty = new ToolItem(toolBar, 0);
        this.tltmRemoveProperty.setText(StringConstants.SETT_TOOLITEM_REMOVE);
        this.tltmRemoveProperty.setImage(ImageConstants.IMG_16_REMOVE);
        this.tltmClearProperty = new ToolItem(toolBar, 0);
        this.tltmClearProperty.setText(StringConstants.SETT_TOOLITEM_CLEAR);
        this.tltmClearProperty.setImage(ImageConstants.IMG_16_CLEAR);
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer = new TableViewer(tableComposite, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(ControlUtils.shouldLineVisble((Display)this.table.getDisplay()));
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.addTableColumn(this.tableViewer, tableColumnLayout, StringConstants.SETT_COL_PREFERENCE_TYPE, 100, 45, new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                if (!(value instanceof Integer)) {
                    return;
                }
                int selection = (Integer)value;
                if (selection >= 0 && DriverPropertyListComposite.this.tableViewer.getInput() instanceof List) {
                    List inputList;
                    int elementIndex;
                    DriverPropertyValueType newType = DriverPropertyValueType.valueOf((String)DriverPropertyValueType.stringValues()[selection]);
                    DriverPropertyValueType valueType = DriverPropertyValueType.fromValue((Object)element);
                    if (valueType != newType && (elementIndex = DriverPropertyListComposite.indexOfUsingObject(inputList = (List)DriverPropertyListComposite.this.tableViewer.getInput(), element)) >= 0 && elementIndex < inputList.size()) {
                        inputList.set(elementIndex, newType.getDefaultValue());
                        DriverPropertyListComposite.this.tableViewer.refresh();
                    }
                }
            }

            protected Object getValue(Object element) {
                DriverPropertyValueType valueType = DriverPropertyValueType.fromValue((Object)element);
                int i = 0;
                while (i < DriverPropertyValueType.values().length) {
                    if (DriverPropertyValueType.values()[i] == valueType) {
                        return i;
                    }
                    ++i;
                }
                return 0;
            }

            protected CellEditor getCellEditor(Object element) {
                return new ComboBoxCellEditor((Composite)DriverPropertyListComposite.this.tableViewer.getTable(), DriverPropertyValueType.stringValues());
            }

            protected boolean canEdit(Object element) {
                return element != null;
            }
        });
        this.addTableColumn(this.tableViewer, tableColumnLayout, StringConstants.SETT_COL_PREFERENCE_VALUE, 100, 45, new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                List inputList;
                int elementIndex;
                if (DriverPropertyListComposite.this.tableViewer.getInput() instanceof List && (elementIndex = DriverPropertyListComposite.indexOfUsingObject(inputList = (List)DriverPropertyListComposite.this.tableViewer.getInput(), element)) >= 0 && elementIndex < inputList.size()) {
                    DriverPropertyValueType propertyType = DriverPropertyValueType.fromValue((Object)element);
                    switch (propertyType) {
                        case Boolean: {
                            if (!(value instanceof Integer)) break;
                            if ((Integer)value == 1) {
                                inputList.set(elementIndex, Boolean.TRUE);
                                break;
                            }
                            inputList.set(elementIndex, Boolean.FALSE);
                            break;
                        }
                        case Number: {
                            if (!(value instanceof String)) break;
                            try {
                                Number numberValue = NumUtil.parseNumber((String)((String)value));
                                inputList.set(elementIndex, numberValue);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        case Dictionary: 
                        case List: {
                            DriverPropertyValueType newPropertyType = DriverPropertyValueType.fromValue((Object)value);
                            if (newPropertyType != propertyType) break;
                            inputList.set(elementIndex, value);
                            break;
                        }
                        case String: {
                            if (!(value instanceof String)) break;
                            inputList.set(elementIndex, value);
                        }
                    }
                    DriverPropertyListComposite.this.tableViewer.refresh();
                }
            }

            protected Object getValue(Object element) {
                DriverPropertyValueType propertyType = DriverPropertyValueType.fromValue((Object)element);
                switch (propertyType) {
                    case Boolean: {
                        Boolean booleanValue = (Boolean)element;
                        return booleanValue != false ? 0 : 1;
                    }
                    case Dictionary: 
                    case List: {
                        return element;
                    }
                    case String: 
                    case Number: {
                        return String.valueOf(element);
                    }
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                DriverPropertyValueType propertyType = DriverPropertyValueType.fromValue((Object)element);
                switch (propertyType) {
                    case Boolean: {
                        return new ComboBoxCellEditor((Composite)DriverPropertyListComposite.this.tableViewer.getTable(), new String[]{Boolean.TRUE.toString().toLowerCase(), Boolean.FALSE.toString().toLowerCase()});
                    }
                    case List: {
                        return new ListPropertyValueCellEditor((Composite)DriverPropertyListComposite.this.tableViewer.getTable());
                    }
                    case Dictionary: {
                        return new MapPropertyValueCellEditor((Composite)DriverPropertyListComposite.this.tableViewer.getTable());
                    }
                    case String: 
                    case Number: {
                        return new TextCellEditor((Composite)DriverPropertyListComposite.this.tableViewer.getTable());
                    }
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element != null;
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ListPropertyLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    public static int indexOfUsingObject(List<?> objectList, Object object) {
        int i = 0;
        while (i < objectList.size()) {
            if (objectList.get(i) == object) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void addTableColumn(TableViewer parent, TableColumnLayout tableColumnLayout, String headerText, int width, int weight, EditingSupport editingSupport) {
        TableViewerColumn tableColumn = new TableViewerColumn(parent, 0);
        tableColumn.getColumn().setWidth(width);
        tableColumn.getColumn().setMoveable(true);
        tableColumn.getColumn().setText(headerText);
        tableColumn.setEditingSupport(editingSupport);
        tableColumnLayout.setColumnData((Widget)tableColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, tableColumn.getColumn().getWidth()));
    }

    public void setInput(List<Object> propertyValueList) {
        this.addToolItemListeners(propertyValueList);
        this.tableViewer.setInput(propertyValueList);
    }

    private void addToolItemListeners(final List<Object> propertyValueList) {
        this.tltmAddProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                propertyValueList.add(new String(""));
                DriverPropertyListComposite.this.tableViewer.refresh();
            }
        });
        this.tltmRemoveProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DriverPropertyListComposite.this.tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    for (Object selectedObject : selection.toList()) {
                        int selectedObjectIndex = DriverPropertyListComposite.indexOfUsingObject(propertyValueList, selectedObject);
                        if (selectedObjectIndex < 0 || selectedObjectIndex >= propertyValueList.size()) continue;
                        propertyValueList.remove(selectedObjectIndex);
                    }
                    DriverPropertyListComposite.this.tableViewer.refresh();
                }
            }
        });
        this.tltmClearProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                propertyValueList.clear();
                DriverPropertyListComposite.this.tableViewer.refresh();
            }
        });
    }
}

