/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.components;

import com.kms.katalon.composer.execution.components.ListPropertyValueCellEditor;
import com.kms.katalon.composer.execution.components.MapPropertyValueCellEditor;
import com.kms.katalon.core.setting.DriverPropertyValueType;
import com.kms.katalon.util.NumUtil;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class DriverPropertyValueEditingSupport
extends EditingSupport {
    private TableViewer tableViewer;

    public DriverPropertyValueEditingSupport(TableViewer tableViewer) {
        super((ColumnViewer)tableViewer);
        this.tableViewer = tableViewer;
    }

    protected CellEditor getCellEditor(Object element) {
        DriverPropertyValueType propertyType = DriverPropertyValueType.fromValue(((Map.Entry)element).getValue());
        switch (propertyType) {
            case Boolean: {
                return new ComboBoxCellEditor((Composite)this.tableViewer.getTable(), new String[]{Boolean.TRUE.toString().toLowerCase(), Boolean.FALSE.toString().toLowerCase()});
            }
            case List: {
                return new ListPropertyValueCellEditor((Composite)this.tableViewer.getTable());
            }
            case Dictionary: {
                return new MapPropertyValueCellEditor((Composite)this.tableViewer.getTable());
            }
            case String: 
            case Number: {
                return new TextCellEditor((Composite)this.tableViewer.getTable());
            }
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        return element instanceof Map.Entry;
    }

    protected Object getValue(Object element) {
        DriverPropertyValueType propertyType = DriverPropertyValueType.fromValue(((Map.Entry)element).getValue());
        switch (propertyType) {
            case Boolean: {
                Boolean booleanValue = (Boolean)((Map.Entry)element).getValue();
                return booleanValue != false ? 0 : 1;
            }
            case Dictionary: 
            case List: {
                return ((Map.Entry)element).getValue();
            }
            case String: 
            case Number: {
                return String.valueOf(((Map.Entry)element).getValue());
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        Map.Entry property = (Map.Entry)element;
        DriverPropertyValueType propertyType = DriverPropertyValueType.fromValue(property.getValue());
        switch (propertyType) {
            case Boolean: {
                if (!(value instanceof Integer)) break;
                Integer integerValue = (Integer)value;
                if (integerValue == 0) {
                    property.setValue(Boolean.TRUE);
                    break;
                }
                if (integerValue != 1) break;
                property.setValue(Boolean.FALSE);
                break;
            }
            case Number: {
                if (!(value instanceof String)) break;
                try {
                    Number numberValue = NumUtil.parseNumber((String)((String)value));
                    property.setValue(numberValue);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case Dictionary: 
            case List: {
                DriverPropertyValueType newPropertyType = DriverPropertyValueType.fromValue((Object)value);
                if (newPropertyType != propertyType) break;
                property.setValue(value);
                break;
            }
            case String: {
                if (!(value instanceof String)) break;
                property.setValue(value);
            }
        }
        this.tableViewer.refresh();
    }
}

