/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.jobs;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.exceptions.JobCancelException;
import com.kms.katalon.composer.execution.handlers.AbstractExecutionHandler;
import com.kms.katalon.composer.execution.launcher.IDELauncher;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseBindingExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.listener.LauncherEvent;
import com.kms.katalon.execution.launcher.listener.LauncherListener;
import com.kms.katalon.execution.launcher.listener.LauncherNotifiedObject;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import jakarta.inject.Inject;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.UISynchronize;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class ExecuteTestCaseJob
extends Job {
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    protected final UISynchronize sync;
    protected IRunConfiguration runConfig;
    protected final TestCaseEntity testCase;
    protected final LaunchMode launchMode;
    private AbstractExecutionHandler handler;
    protected boolean isCanceled;
    protected boolean executeFromHere;

    public static ExecuteTestCaseJob newInstance(String name, TestCaseEntity testCase, LaunchMode launchMode, UISynchronize sync, AbstractExecutionHandler handler) {
        return ExecuteTestCaseJob.newInstance(name, testCase, launchMode, sync, handler, false);
    }

    public static ExecuteTestCaseJob newInstance(String name, TestCaseEntity testCase, LaunchMode launchMode, UISynchronize sync, AbstractExecutionHandler handler, boolean executeFromHere) {
        ExecuteTestCaseJob instance = new ExecuteTestCaseJob(name, testCase, launchMode, sync, handler, executeFromHere);
        BundleContext bundleContext = FrameworkUtil.getBundle(ExecuteTestCaseJob.class).getBundleContext();
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        ContextInjectionFactory.inject((Object)((Object)instance), (IEclipseContext)context);
        return instance;
    }

    public ExecuteTestCaseJob(String name, TestCaseEntity testCase, LaunchMode launchMode, UISynchronize sync, AbstractExecutionHandler handler, boolean executeFromHere) {
        super(name);
        this.testCase = testCase;
        this.launchMode = launchMode;
        this.sync = sync;
        this.handler = handler;
        this.executeFromHere = executeFromHere;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(StringConstants.HAND_JOB_LAUNCHING_TEST_CASE, 3);
            monitor.subTask(StringConstants.HAND_JOB_ACTIVATING_VIEWERS);
            this.activateViewers();
            ExecuteTestCaseJob.validateJobProgressMonitor(monitor);
            monitor.worked(1);
            monitor.subTask(StringConstants.HAND_JOB_BUILDING_SCRIPTS);
            this.buildScripts();
            if (this.isCanceled) {
                EventBrokerSingleton.getInstance().getEventBroker().post("EXECUTE/EXECUTE_TEST_CASE_ENDED", null);
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            ExecuteTestCaseJob.validateJobProgressMonitor(monitor);
            this.startLauncher();
            monitor.worked(1);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (JobCancelException jobCancelException) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            this.sync.syncExec(new Runnable(){

                @Override
                public void run() {
                    MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_EXECUTE_SELECTED_TEST_CASE, (String)StringConstants.HAND_ERROR_MSG_REASON_WRONG_SYNTAX);
                }
            });
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected void startLauncher() {
        LauncherManager launcherManager = LauncherManager.getInstance();
        final IDELauncher launcher = new IDELauncher(launcherManager, this.runConfig, this.launchMode, this.executeFromHere);
        launcher.addListener(new LauncherListener(){

            public void handleLauncherEvent(LauncherEvent event, LauncherNotifiedObject notifiedObject) {
                if (event == LauncherEvent.UPDATE_STATUS) {
                    ExecuteTestCaseJob.this.handleLauncherStatusChange(launcher, (LauncherStatus)notifiedObject.getObject());
                }
            }
        });
        launcherManager.addLauncher((ILauncher)launcher);
    }

    protected void handleLauncherStatusChange(IDELauncher launcher, LauncherStatus status) {
        if (status == LauncherStatus.DONE) {
            this.handleLauncherCompleted(launcher);
        }
        if (status.isExecutionPhaseDone()) {
            EventBrokerSingleton.getInstance().getEventBroker().post("EXECUTE/EXECUTE_TEST_CASE_ENDED", (Object)launcher.getResult());
        }
    }

    protected void handleLauncherCompleted(IDELauncher launcher) {
        EventBrokerSingleton.getInstance().getEventBroker().post("EXECUTE/EXECUTE_TEST_CASE_COMPLETED", (Object)launcher.getResult());
    }

    protected void activateViewers() {
        AbstractExecutionHandler.openConsoleLog();
    }

    protected void buildScripts() {
        UISynchronizeService.syncExec(() -> {
            try {
                this.runConfig = this.handler.buildRunConfiguration(this.testCase.getProject().getFolderLocation());
                if (this.runConfig == null) {
                    this.isCanceled = true;
                    return;
                }
                if (this.testCase.getVariables().isEmpty() || TestCaseController.getInstance().isNotUsingDataBinding(this.testCase)) {
                    this.runConfig.build((FileEntity)this.testCase, (IExecutedEntity)new TestCaseExecutedEntity(this.testCase));
                } else {
                    boolean canUseDdtAtTcLevel = this.featureController.canUse(ProductFeature.TEST_CASE_DATA_BINDING);
                    if (!canUseDdtAtTcLevel) {
                        this.productFeatureDialog.showNotAvailableFeature(ProductFeature.TEST_CASE_DATA_BINDING);
                        this.isCanceled = true;
                        return;
                    }
                    TestCaseBindingExecutedEntity executedEntity = new TestCaseBindingExecutedEntity(this.testCase);
                    this.runConfig.build((FileEntity)this.testCase, (IExecutedEntity)executedEntity);
                }
            }
            catch (ExecutionException | IOException | ArithmeticException | InterruptedException e) {
                MultiStatusErrorDialog.showErrorDialog((String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_EXECUTE_SELECTED_TEST_CASE, (String)e.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
                LoggerSingleton.logError((Throwable)e);
                this.isCanceled = true;
            }
        });
    }

    private static void validateJobProgressMonitor(IProgressMonitor monitor) throws JobCancelException {
        if (monitor.isCanceled()) {
            throw new JobCancelException();
        }
    }
}

