/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.logviewer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.report.core.models.common.ExecutedTestType;
import java.util.HashSet;
import java.util.Set;

public class FastTreeViewerFilterBuilder {
    private Set<LogLevel> levels = new HashSet<LogLevel>();

    public void toggleShowFailedSteps(boolean enabled) {
        this.levels.clear();
        if (enabled) {
            this.levels.add(LogLevel.FAILED);
        }
    }

    public Object build() {
        if (this.levels.isEmpty()) {
            return null;
        }
        JsonArray levelArray = new JsonArray();
        for (LogLevel level : this.levels) {
            levelArray.add(level.name());
        }
        JsonObject resultFilter = new JsonObject();
        resultFilter.add("$in", (JsonElement)levelArray);
        JsonObject resultObj = new JsonObject();
        resultObj.add("result", (JsonElement)resultFilter);
        JsonObject nullResultObj = new JsonObject();
        nullResultObj.add("result", (JsonElement)JsonNull.INSTANCE);
        JsonObject noEndTimeObj = new JsonObject();
        noEndTimeObj.add("endTime", (JsonElement)JsonNull.INSTANCE);
        JsonObject typeObj = new JsonObject();
        typeObj.addProperty("type", ExecutedTestType.TEST_SUITE.toString());
        JsonArray orArray = new JsonArray();
        orArray.add((JsonElement)resultObj);
        orArray.add((JsonElement)nullResultObj);
        orArray.add((JsonElement)noEndTimeObj);
        orArray.add((JsonElement)typeObj);
        JsonObject finalFilter = new JsonObject();
        finalFilter.add("$or", (JsonElement)orArray);
        return finalFilter;
    }
}

