/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.services.IStudioAssistController;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.settings.AbstractExecutionSettingPage;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.execution.setting.ReportSettingStore;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.tracking.model.ReportConfigurationTrackingInfo;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import java.io.IOException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportSettingPage
extends AbstractExecutionSettingPage {
    private static final Logger logger = LoggerFactory.getLogger(ReportSettingPage.class);
    private ReportSettingStore settingStore = ReportSettingStore.getStore();
    private Button generateHTMLCheckbox;
    private Button generateCSVCheckbox;
    private Button generatePDFCheckbox;
    private Button generateConsoleLogCheckbox;
    private Button useImageReferencesCheckbox;
    private Button useNewReportCheckbox;
    private Button useSplitReportDataCheckbox;
    private Button useAnalyzeFailedReasonByAiCheckbox;
    private Link linkToStudioAssistSetting;
    private SelectionAdapter linkToStudioAssistSettingListener;
    @Inject
    private IStudioAssistController studioAssistController;
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;

    @Override
    protected void createSettingsArea(Composite container) {
        ComponentBuilder.label((Composite)container).text(ComposerExecutionMessageConstants.LBL_GENERATE_REPORT).fillHorizontal().build();
        Composite usedReportTypesGroup = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().build();
        this.generateHTMLCheckbox = (Button)ComponentBuilder.checkBox((Composite)usedReportTypesGroup).text(ComposerExecutionMessageConstants.CHK_GENERATE_HTML).build();
        this.generateCSVCheckbox = (Button)ComponentBuilder.checkBox((Composite)usedReportTypesGroup).text(ComposerExecutionMessageConstants.CHK_GENERATE_CSV).build();
        this.generatePDFCheckbox = (Button)ComponentBuilder.checkBox((Composite)usedReportTypesGroup).text(ComposerExecutionMessageConstants.CHK_GENERATE_PDF).build();
        this.generateConsoleLogCheckbox = (Button)ComponentBuilder.checkBox((Composite)usedReportTypesGroup).text(ComposerExecutionMessageConstants.CHK_GENERATE_CONSOLE).build();
        ComponentBuilder.label((Composite)usedReportTypesGroup).text(ComposerExecutionMessageConstants.LBL_HTML_FILE_STRUCTURE).marginTop(ComponentUtil.applyZoom((int)10)).build();
        Composite htmlSettingsGroup = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().build();
        Composite useImageReferencesGroup = (Composite)ComponentBuilder.gridContainer((Composite)htmlSettingsGroup, (int)2).fillHorizontal().build();
        this.useImageReferencesCheckbox = (Button)ComponentBuilder.checkBox((Composite)useImageReferencesGroup).text(ComposerExecutionMessageConstants.CHK_USE_HTML_IMAGE_PREFERENCE).build();
        ComponentBuilder.helpButton((Composite)useImageReferencesGroup, (String)DocumentationMessageConstants.REPORT_USE_HTML_IMAGE_REFERENCE).fillHorizontal().left().build();
        Composite useNewReportGroup = (Composite)ComponentBuilder.gridContainer((Composite)htmlSettingsGroup, (int)2).fillHorizontal().build();
        this.useNewReportCheckbox = (Button)ComponentBuilder.checkBox((Composite)useNewReportGroup).text(ComposerExecutionMessageConstants.CHK_APPLY_NEW_REPORT).onChange(event -> this.updateButtons()).build();
        ComponentBuilder.link((Composite)useNewReportGroup).linkTo("View examples", DocumentationMessageConstants.NEW_REPORT_EXAMPLE).left().build();
        Composite useSplitReportDataGroup = (Composite)ComponentBuilder.gridContainer((Composite)htmlSettingsGroup, (int)2).groupIndent().fillHorizontal().build();
        this.useSplitReportDataCheckbox = (Button)ComponentBuilder.checkBox((Composite)useSplitReportDataGroup).text(ComposerExecutionMessageConstants.CHK_SPLIT_REPORT_DATA).build();
        ComponentBuilder.helpButton((Composite)useSplitReportDataGroup, (String)DocumentationMessageConstants.SPLIT_REPORT_DATA).left().build();
        Composite aiAnalyzeGroup = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).fillHorizontal().build();
        this.useAnalyzeFailedReasonByAiCheckbox = (Button)ComponentBuilder.checkBox((Composite)aiAnalyzeGroup).text(ComposerExecutionMessageConstants.CHK_ANALYZE_FAILED_REASON_BY_AI).onClick(event -> {
            if (!this.featureController.canUse(ProductFeature.AI_FAILURE_ANALYSIS)) {
                this.productFeatureDialog.showNotAvailableFeature(ProductFeature.AI_FAILURE_ANALYSIS);
                this.useAnalyzeFailedReasonByAiCheckbox.setSelection(false);
            }
        }).build();
        this.useAnalyzeFailedReasonByAiCheckbox.setEnabled(!this.getStudioAssistConfigType().equals((Object)LlmConfigType.NONE));
        this.linkToStudioAssistSetting = new Link(aiAnalyzeGroup, 0);
        this.linkToStudioAssistSetting.setText(ComposerExecutionMessageConstants.LNK_ANALYZE_FAILED_REASON_BY_AI_REQUIRED);
        this.linkToStudioAssistSettingListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventBrokerSingleton.getInstance().getEventBroker().post("KATALON/PREFERENCES", (Object)"com.kms.katalon.composer.preferences.GeneralPreferencePage/com.kms.katalon.composer.ai");
            }
        };
        this.registerOpenStudioAssistSettingListener();
    }

    private void registerOpenStudioAssistSettingListener() {
        if (this.linkToStudioAssistSettingListener != null) {
            this.linkToStudioAssistSettingListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EventBrokerSingleton.getInstance().getEventBroker().post("KATALON/PREFERENCES", (Object)"com.kms.katalon.composer.preferences.GeneralPreferencePage/com.kms.katalon.composer.ai");
                }
            };
        }
        this.linkToStudioAssistSetting.addSelectionListener((SelectionListener)this.linkToStudioAssistSettingListener);
    }

    @Override
    protected void initialize() throws IOException {
        this.generateHTMLCheckbox.setSelection(this.settingStore.useGenerateHTML());
        this.generateCSVCheckbox.setSelection(this.settingStore.useGenerateCSV());
        this.generatePDFCheckbox.setSelection(this.settingStore.useGeneratePDF());
        this.generateConsoleLogCheckbox.setSelection(this.settingStore.useGenerateConsoleLog());
        this.useImageReferencesCheckbox.setSelection(this.settingStore.useHTMLImageReferences());
        this.useNewReportCheckbox.setSelection(this.settingStore.useNewReport());
        this.useSplitReportDataCheckbox.setSelection(this.settingStore.useSplitReportData());
        if (!this.featureController.canUse(ProductFeature.AI_FAILURE_ANALYSIS)) {
            this.useAnalyzeFailedReasonByAiCheckbox.setSelection(false);
        } else {
            this.useAnalyzeFailedReasonByAiCheckbox.setSelection(this.settingStore.useAnalyzeFailedReasonByAI());
        }
        this.updateButtons();
    }

    @Override
    protected void performDefaults() {
        this.generateHTMLCheckbox.setSelection(true);
        this.generateCSVCheckbox.setSelection(true);
        this.generatePDFCheckbox.setSelection(false);
        this.generateConsoleLogCheckbox.setSelection(true);
        this.useImageReferencesCheckbox.setSelection(false);
        this.useNewReportCheckbox.setSelection(true);
        this.useSplitReportDataCheckbox.setSelection(false);
        this.useAnalyzeFailedReasonByAiCheckbox.setSelection(false);
        this.updateButtons();
        super.performDefaults();
    }

    @Override
    public boolean saveSettings() throws IOException {
        this.settingStore.setGenerateHTML(this.generateHTMLCheckbox.getSelection());
        this.settingStore.setGenerateCSV(this.generateCSVCheckbox.getSelection());
        this.settingStore.setGeneratePDF(this.generatePDFCheckbox.getSelection());
        this.settingStore.setGenerateConsoleLog(this.generateConsoleLogCheckbox.getSelection());
        this.settingStore.setUseHTMLImageReferences(this.useImageReferencesCheckbox.getSelection());
        this.settingStore.setNewReport(this.useNewReportCheckbox.getSelection());
        this.settingStore.setSplitReportData(this.useSplitReportDataCheckbox.getSelection());
        this.settingStore.setUseAnalyzeFailedReasonByAI(this.useAnalyzeFailedReasonByAiCheckbox.getSelection());
        this.trackReportSetting();
        return true;
    }

    private void updateButtons() {
        this.useSplitReportDataCheckbox.setEnabled(this.useNewReportCheckbox.getSelection());
    }

    private void trackReportSetting() {
        ReportConfigurationTrackingInfo reportConfigurationTrackingInfo = new ReportConfigurationTrackingInfo();
        if (this.generateHTMLCheckbox.getSelection()) {
            reportConfigurationTrackingInfo.markHtmlReportType();
        }
        if (this.generateCSVCheckbox.getSelection()) {
            reportConfigurationTrackingInfo.markCsvReportType();
        }
        if (this.generatePDFCheckbox.getSelection()) {
            reportConfigurationTrackingInfo.markPdfReportType();
        }
        if (this.generateConsoleLogCheckbox.getSelection()) {
            reportConfigurationTrackingInfo.markConsoleReportType();
        }
        reportConfigurationTrackingInfo.setApplyNewTemplate(this.useNewReportCheckbox.getSelection());
        boolean isSplitHtmlReport = this.useNewReportCheckbox.getSelection() ? this.useSplitReportDataCheckbox.getSelection() : false;
        reportConfigurationTrackingInfo.setSplitHtmlReport(isSplitHtmlReport);
        reportConfigurationTrackingInfo.setSplitImageHtml(this.useImageReferencesCheckbox.getSelection());
        reportConfigurationTrackingInfo.setUseAnalyzeFailedReasonByAI(this.useAnalyzeFailedReasonByAiCheckbox.getSelection());
        try {
            Trackings.trackReportConfigurationApply((ReportConfigurationTrackingInfo)reportConfigurationTrackingInfo);
        }
        catch (Exception e) {
            LogUtil.logError((String)"Failed to track report configuration, error:");
            LogUtil.logError((Throwable)e);
        }
    }

    private LlmConfigType getStudioAssistConfigType() {
        try {
            StudioAssistConfig config = this.studioAssistController.getConfig();
            if (config != null) {
                return config.getType();
            }
        }
        catch (Exception e) {
            logger.error("Failed to get Studio Assist config", (Throwable)e);
        }
        return LlmConfigType.NONE;
    }

    public void dispose() {
        if (this.linkToStudioAssistSetting != null && this.linkToStudioAssistSettingListener != null) {
            this.linkToStudioAssistSetting.removeSelectionListener((SelectionListener)this.linkToStudioAssistSettingListener);
        }
        super.dispose();
    }
}

