/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.util;

import com.kms.katalon.composer.components.dialogs.MessageDialogWithLink;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.CallabelUISynchronize;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.jobs.DownloadSDKProgress;
import com.kms.katalon.execution.mobile.configuration.providers.MobileDeviceProvider;
import com.kms.katalon.execution.mobile.device.AndroidSDKManager;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class MobileDeviceUIProvider {
    private MobileDeviceUIProvider() {
    }

    public static List<MobileDeviceInfo> getAndroidDevices() {
        ArrayList<MobileDeviceInfo> mobileDeviceInfos = new ArrayList<MobileDeviceInfo>();
        Shell activeShell = null;
        try {
            boolean sdkExists = (Boolean)CallabelUISynchronize.newInstance().syncCallabelExec(() -> MobileDeviceUIProvider.checkAndroidSDKExist(activeShell));
            if (sdkExists) {
                mobileDeviceInfos.addAll(MobileDeviceProvider.getAndroidDevices());
            }
        }
        catch (Exception e) {
            UISynchronizeService.syncExec(() -> MessageDialog.openInformation((Shell)activeShell, (String)"Error", (String)(e.getClass().getName() + ": " + e.getMessage())));
        }
        return mobileDeviceInfos;
    }

    public static List<MobileDeviceInfo> getIOSDevices() {
        ArrayList<MobileDeviceInfo> mobileDeviceInfos = new ArrayList<MobileDeviceInfo>();
        Shell activeShell = null;
        try {
            mobileDeviceInfos.addAll(MobileDeviceProvider.getIosDevices());
        }
        catch (IOException | InterruptedException e) {
            UISynchronizeService.syncExec(() -> MessageDialog.openInformation((Shell)activeShell, (String)"Error", (String)(e.getClass().getName() + ": " + e.getMessage())));
        }
        try {
            mobileDeviceInfos.addAll(MobileDeviceProvider.getIosSimulators());
        }
        catch (IOException | InterruptedException e) {
            UISynchronizeService.syncExec(() -> MessageDialog.openInformation((Shell)activeShell, (String)"Error", (String)(e.getClass().getName() + ": " + e.getMessage())));
        }
        return mobileDeviceInfos;
    }

    public static List<MobileDeviceInfo> getAllDevices() {
        ArrayList<MobileDeviceInfo> mobileDeviceInfos = new ArrayList<MobileDeviceInfo>();
        Shell activeShell = null;
        try {
            boolean sdkExists = (Boolean)CallabelUISynchronize.newInstance().syncCallabelExec(() -> MobileDeviceUIProvider.checkAndroidSDKExist(activeShell));
            if (sdkExists) {
                mobileDeviceInfos.addAll(MobileDeviceProvider.getAndroidDevices());
            }
        }
        catch (Exception e) {
            UISynchronizeService.syncExec(() -> MessageDialog.openInformation((Shell)activeShell, (String)"Error", (String)(e.getClass().getName() + ": " + e.getMessage())));
        }
        try {
            mobileDeviceInfos.addAll(MobileDeviceProvider.getIosDevices());
        }
        catch (IOException | InterruptedException e) {
            UISynchronizeService.syncExec(() -> MessageDialog.openInformation((Shell)activeShell, (String)"Error", (String)(e.getClass().getName() + ": " + e.getMessage())));
        }
        try {
            mobileDeviceInfos.addAll(MobileDeviceProvider.getIosSimulators());
        }
        catch (IOException | InterruptedException e) {
            UISynchronizeService.syncExec(() -> MessageDialog.openInformation((Shell)activeShell, (String)"Error", (String)(e.getClass().getName() + ": " + e.getMessage())));
        }
        return mobileDeviceInfos;
    }

    public static boolean checkAndroidSDKExist(Shell activeShell) {
        AndroidSDKManager sdkManager = new AndroidSDKManager();
        if (!sdkManager.checkSDKExists()) {
            if (!MessageDialog.openConfirm((Shell)activeShell, (String)StringConstants.CONFIRMATION, (String)ComposerExecutionMessageConstants.DIA_MSG_ANDROID_SDK_MISSING)) {
                return false;
            }
            return MobileDeviceUIProvider.newDownloadSDKProgress(activeShell, sdkManager);
        }
        return true;
    }

    public static boolean newDownloadSDKProgress(Shell activeShell, AndroidSDKManager sdkManager) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(activeShell);
        try {
            dialog.run(true, false, (IRunnableWithProgress)new DownloadSDKProgress(sdkManager.getSDKLocator()));
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialogWithLink.openError((Shell)activeShell, (String)"Error", (String)e.getTargetException().getMessage());
            return false;
        }
    }
}

