/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.manager;

import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.dal.IReportDataProvider;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.constants.StringConstants;
import com.kms.katalon.dal.fileservice.dataprovider.SystemFileServiceDataProvider;
import com.kms.katalon.dal.fileservice.dataprovider.setting.FileServiceDataProviderSetting;
import com.kms.katalon.dal.fileservice.manager.CheckpointFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.DataFileFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.ReportFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.TestCaseFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.WebElementFileServiceManager;
import com.kms.katalon.dal.fileservice.strategies.IEntityLoadStrategy;
import com.kms.katalon.dal.fileservice.util.PathValidationUtil;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.dal.exception.DuplicatedFolderException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.file.UserFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import com.kms.katalon.groovy.util.GroovyRefreshUtil;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;

public class FolderFileServiceManager {
    private static final String[] IGNORABLE_FILE_EXTENSIONS = new String[]{".classpath", ".project", ".prj", ".DS_Store", ".index"};
    private static final String[] SYSTEM_FOLDERS = new String[]{StringConstants.ROOT_FOLDER_NAME_TEST_CASE, StringConstants.ROOT_FOLDER_NAME_OBJECT_REPOSITORY, StringConstants.ROOT_FOLDER_NAME_DATA_FILE, StringConstants.ROOT_FOLDER_NAME_TEST_SUITE, StringConstants.ROOT_FOLDER_NAME_REPORT, StringConstants.ROOT_FOLDER_NAME_KEYWORD, StringConstants.ROOT_FOLDER_NAME_CHECKPOINT, StringConstants.ROOT_FOLDER_NAME_PROFILES, StringConstants.ROOT_FOLDER_NAME_TEST_LISTENER, StringConstants.ROOT_FOLDER_NAME_INCLUDE, StringConstants.SYSTEM_FOLDER_NAME_BIN, StringConstants.SYSTEM_FOLDER_NAME_DRIVER, StringConstants.SYSTEM_FOLDER_NAME_LIB, StringConstants.SYSTEM_FOLDER_NAME_SETTINGS, StringConstants.SYSTEM_FOLDER_NAME_SCRIPT, ".git", ".settings", ".cache"};

    private static void initRootFolder(String folderPath) throws Exception {
        File rootFolder = new File(folderPath);
        if (!rootFolder.exists()) {
            rootFolder.mkdirs();
        }
    }

    public static void initRootEntityFolders(ProjectEntity project) throws Exception {
        if (project != null) {
            String projectFolderLocation = project.getFolderLocation();
            FolderFileServiceManager.initRootFolder(FileServiceConstant.getTestCaseRootFolderLocation(projectFolderLocation));
            FolderFileServiceManager.initRootFolder(FileServiceConstant.getTestSuiteRootFolderLocation(projectFolderLocation));
            FolderFileServiceManager.initRootFolder(FileServiceConstant.getDataFileRootFolderLocation(projectFolderLocation));
            FolderFileServiceManager.initRootFolder(FileServiceConstant.getObjectRepositoryRootFolderLocation(projectFolderLocation));
            FolderFileServiceManager.initRootFolder(FileServiceConstant.getKeywordRootFolderLocation(projectFolderLocation));
            if (ApplicationRunningMode.get() != RunningMode.CONSOLE) {
                FolderFileServiceManager.initRootFolder(FileServiceConstant.getReportRootFolderLocation(projectFolderLocation));
            }
            FolderFileServiceManager.initRootFolder(FileServiceConstant.getCheckpointRootFolderLocation(projectFolderLocation));
            FolderFileServiceManager.initRootFolder(FileServiceConstant.getTestListenerRootFolderLocation(projectFolderLocation));
            FolderFileServiceManager.initRootFolder(FileServiceConstant.getProfileFolderLocation(projectFolderLocation));
            FolderFileServiceManager.initRootFolder(FileServiceConstant.getSourceFolderLocation(projectFolderLocation));
            FolderFileServiceManager.initRootFolder(FileServiceConstant.getGroovyScriptFolderLocation(projectFolderLocation));
            FolderFileServiceManager.initRootFolder(FileServiceConstant.getFeatureFolderLocation(projectFolderLocation));
            FolderFileServiceManager.initRootFolder(FileServiceConstant.getConfigFolderLocation(projectFolderLocation));
        }
    }

    public static FolderEntity getTestSuiteRoot(ProjectEntity project) throws Exception {
        FolderEntity folder;
        if (project != null && (folder = FolderFileServiceManager.getFolder(FileServiceConstant.getTestSuiteRootFolderLocation(project.getFolderLocation()))) != null) {
            folder.setProject(project);
            return folder;
        }
        return null;
    }

    public static FolderEntity getTestCaseRoot(ProjectEntity project) throws Exception {
        FolderEntity folder;
        if (project != null && (folder = FolderFileServiceManager.getFolder(FileServiceConstant.getTestCaseRootFolderLocation(project.getFolderLocation()))) != null) {
            folder.setProject(project);
            return folder;
        }
        return null;
    }

    public static FolderEntity getTestDataRoot(ProjectEntity project) throws Exception {
        FolderEntity folder;
        if (project != null && (folder = FolderFileServiceManager.getFolder(FileServiceConstant.getDataFileRootFolderLocation(project.getFolderLocation()))) != null) {
            folder.setProject(project);
            return folder;
        }
        return null;
    }

    public static FolderEntity getObjectRepositoryRoot(ProjectEntity project) throws Exception {
        FolderEntity folder;
        if (project != null && (folder = FolderFileServiceManager.getFolder(FileServiceConstant.getObjectRepositoryRootFolderLocation(project.getFolderLocation()))) != null) {
            folder.setProject(project);
            return folder;
        }
        return null;
    }

    public static FolderEntity getKeywordRoot(ProjectEntity project) throws Exception {
        FolderEntity folder;
        if (project != null && (folder = FolderFileServiceManager.getFolder(FileServiceConstant.getKeywordRootFolderLocation(project.getFolderLocation()))) != null) {
            folder.setProject(project);
            return folder;
        }
        return null;
    }

    public static FolderEntity getReportRoot(ProjectEntity project) throws Exception {
        FolderEntity folder;
        if (project != null && (folder = FolderFileServiceManager.getFolder(FileServiceConstant.getReportRootFolderLocation(project.getFolderLocation()), project)) != null) {
            folder.setProject(project);
            return folder;
        }
        return null;
    }

    public static FolderEntity getCheckpointRoot(ProjectEntity project) throws Exception {
        if (project == null) {
            return null;
        }
        FolderEntity folder = FolderFileServiceManager.getFolder(FileServiceConstant.getCheckpointRootFolderLocation(project.getFolderLocation()));
        if (folder == null) {
            return null;
        }
        folder.setProject(project);
        return folder;
    }

    public static FolderEntity getTestListenerRoot(ProjectEntity project) throws Exception {
        if (project == null) {
            return null;
        }
        FolderEntity folder = FolderFileServiceManager.getFolder(FileServiceConstant.getTestListenerRootFolderLocation(project.getFolderLocation()));
        if (folder == null) {
            return null;
        }
        folder.setFolderType(FolderEntity.FolderType.TESTLISTENER);
        folder.setProject(project);
        return folder;
    }

    public static FolderEntity getFeatureRoot(ProjectEntity project) throws DALException {
        FolderEntity folder;
        block4: {
            if (project == null) {
                return null;
            }
            try {
                folder = FolderFileServiceManager.getFolder(FileServiceConstant.getFeatureFolderLocation(project.getFolderLocation()));
                if (folder != null) break block4;
                return null;
            }
            catch (Exception e) {
                throw new DALException(e);
            }
        }
        folder.setFolderType(FolderEntity.FolderType.FEATURE);
        folder.setProject(project);
        return folder;
    }

    public static FolderEntity getSourceRoot(ProjectEntity project) throws DALException {
        FolderEntity folder;
        block4: {
            if (project == null) {
                return null;
            }
            try {
                folder = FolderFileServiceManager.getFolder(FileServiceConstant.getSourceFolderLocation(project.getFolderLocation()));
                if (folder != null) break block4;
                return null;
            }
            catch (Exception e) {
                throw new DALException(e);
            }
        }
        folder.setFolderType(FolderEntity.FolderType.INCLUDE);
        folder.setProject(project);
        return folder;
    }

    public static FolderEntity getGroovyScriptRoot(ProjectEntity project) throws DALException {
        FolderEntity folder;
        block4: {
            if (project == null) {
                return null;
            }
            try {
                folder = FolderFileServiceManager.getFolder(FileServiceConstant.getGroovyScriptFolderLocation(project.getFolderLocation()));
                if (folder != null) break block4;
                return null;
            }
            catch (Exception e) {
                throw new DALException(e);
            }
        }
        folder.setFolderType(FolderEntity.FolderType.INCLUDE);
        folder.setProject(project);
        return folder;
    }

    public static FolderEntity getScreenshotsRoot(ProjectEntity project) throws DALException {
        FolderEntity folder;
        block4: {
            if (project == null) {
                return null;
            }
            try {
                folder = FolderFileServiceManager.getFolder(FileServiceConstant.getScreenshotsRootFolderLocation(project.getFolderLocation()));
                if (folder != null) break block4;
                return null;
            }
            catch (Exception e) {
                throw new DALException(e);
            }
        }
        folder.setFolderType(FolderEntity.FolderType.USER);
        folder.setProject(project);
        return folder;
    }

    public static List<FileEntity> getRootUserFilesOrFolders(ProjectEntity project) throws DALException {
        if (project == null) {
            return null;
        }
        ArrayList<FileEntity> fileEntities = new ArrayList<FileEntity>();
        List<String> systemFolders = Arrays.asList(SYSTEM_FOLDERS);
        try {
            File projectFolder = new File(project.getFolderLocation());
            File[] files = projectFolder.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isDirectory() && !systemFolders.contains(file.getName())) {
                        FolderEntity folderEntity = FolderFileServiceManager.getFolder(file.getAbsolutePath());
                        folderEntity.setFolderType(FolderEntity.FolderType.USER);
                        folderEntity.setProject(project);
                        fileEntities.add((FileEntity)folderEntity);
                    } else if (file.isFile()) {
                        String fileName = file.getName();
                        if (Arrays.stream(IGNORABLE_FILE_EXTENSIONS).noneMatch(fileName::endsWith)) {
                            UserFileEntity fileEntity = new UserFileEntity(file);
                            fileEntity.setProject(project);
                            fileEntities.add((FileEntity)fileEntity);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            throw new DALException(e);
        }
        fileEntities.sort(new Comparator<FileEntity>(){

            @Override
            public int compare(FileEntity fileA, FileEntity fileB) {
                if (fileA instanceof FolderEntity && fileB instanceof UserFileEntity) {
                    return -1;
                }
                if (fileB instanceof FolderEntity && fileA instanceof UserFileEntity) {
                    return 1;
                }
                return fileA.getName().compareToIgnoreCase(fileB.getName());
            }
        });
        return fileEntities;
    }

    public static FolderEntity addNewFolder(FolderEntity parentFolder, String defaultName) throws Exception {
        if (parentFolder != null) {
            if (defaultName == null || defaultName.trim().equals("")) {
                defaultName = StringConstants.MNG_NEW_FOLDER;
            }
            String name = EntityService.getInstance().getAvailableName(parentFolder.getLocation(), defaultName, false);
            FolderEntity newFolder = new FolderEntity();
            newFolder.setName(name);
            newFolder.setParentFolder(parentFolder);
            newFolder.setDescription("folder");
            newFolder.setFolderType(parentFolder.getFolderType());
            newFolder.setProject(parentFolder.getProject());
            PathValidationUtil.validatePathLength((FileEntity)newFolder);
            EntityService.getInstance().saveEntity((FileEntity)newFolder);
            FolderFileServiceManager.refreshFolder(parentFolder);
            if (newFolder.getFolderType() == FolderEntity.FolderType.TESTCASE) {
                GroovyUtil.initTestCaseScriptFolder((FolderEntity)newFolder);
                GroovyRefreshUtil.refreshFolder((String)GroovyUtil.getRelativePathForFolder((FolderEntity)parentFolder), (ProjectEntity)parentFolder.getProject(), null);
            }
            return newFolder;
        }
        return null;
    }

    public static FolderEntity addNewRootFolder(ProjectEntity project, String name) throws Exception {
        FolderEntity newFolder = new FolderEntity();
        newFolder.setName(name);
        newFolder.setFolderType(FolderEntity.FolderType.USER);
        newFolder.setProject(project);
        PathValidationUtil.validatePathLength((FileEntity)newFolder);
        EntityService.getInstance().saveEntity((FileEntity)newFolder);
        return newFolder;
    }

    public static FolderEntity getFolder(String path) throws Exception {
        FileEntity entity = EntityFileServiceManager.get(new File(path));
        if (entity instanceof FolderEntity) {
            return (FolderEntity)entity;
        }
        return null;
    }

    public static FolderEntity getFolder(String path, ProjectEntity project) throws Exception {
        return EntityFileServiceManager.getFolder(new File(path));
    }

    public static List<FileEntity> getChildren(FolderEntity folder) throws Exception {
        return EntityFileServiceManager.getChildren(folder, FileEntity.class);
    }

    public static List<File> getFileChildren(FolderEntity folder) throws Exception {
        return EntityFileServiceManager.getFileChildren(folder);
    }

    public static List<FolderEntity> getChildFoldersOfFolder(FolderEntity folder) throws Exception {
        return EntityFileServiceManager.getChildren(folder, FolderEntity.class);
    }

    public static List<TestCaseEntity> getChildTestCasesOfFolder(FolderEntity folder) throws Exception {
        return EntityFileServiceManager.getChildren(folder, TestCaseEntity.class);
    }

    public static List<TestSuiteEntity> getChildTestSuitesOfFolder(FolderEntity folder) throws Exception {
        return EntityFileServiceManager.getChildren(folder, TestSuiteEntity.class);
    }

    public static List<DataFileEntity> getChildDataFilesOfFolder(FolderEntity folder) throws Exception {
        return EntityFileServiceManager.getChildren(folder, DataFileEntity.class);
    }

    public static List<WebElementEntity> getChildWebElementsOfFolder(FolderEntity folder) throws Exception {
        return EntityFileServiceManager.getChildren(folder, WebElementEntity.class);
    }

    public static List<CheckpointEntity> getChildCheckpointsOfFolder(FolderEntity folder) throws DALException {
        try {
            return EntityFileServiceManager.getChildren(folder, CheckpointEntity.class);
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public static List<FileEntity> getChildReportsOfFolder(FolderEntity parentFolderEntity) throws Exception {
        if (parentFolderEntity == null) {
            return Collections.emptyList();
        }
        File parentFolderFile = new File(parentFolderEntity.getLocation());
        if (!parentFolderFile.exists() || !parentFolderFile.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<FileEntity> list = new ArrayList<FileEntity>();
        boolean sortByDate = false;
        IReportDataProvider reportDataProvider = new FileServiceDataProviderSetting().getReportDataProvider();
        File[] fileArray = parentFolderFile.listFiles(EntityFileServiceManager.fileFilter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                String folderName = FilenameUtils.getBaseName((String)file.getName());
                if (new File(file, "execution0.log").exists()) {
                    ReportEntity report = reportDataProvider.getReportEntity(file.getAbsolutePath());
                    list.add((FileEntity)report);
                    sortByDate = true;
                } else {
                    File reportCollectionFile = new File(file, folderName + ".rp");
                    if (reportCollectionFile.exists()) {
                        ReportCollectionEntity report = reportDataProvider.getReportCollectionEntity(reportCollectionFile.getAbsolutePath());
                        list.add((FileEntity)report);
                        sortByDate = true;
                    } else {
                        FileEntity fileEntity = EntityFileServiceManager.get(file);
                        if (fileEntity != null && !FolderFileServiceManager.getChildReportsOfFolder((FolderEntity)fileEntity).isEmpty()) {
                            list.add(fileEntity);
                        }
                    }
                }
            }
            ++n2;
        }
        if (sortByDate) {
            ReportFileServiceManager.sortListByCreatedDate(list, true);
        }
        return list;
    }

    public static List<WebElementEntity> getDescendantObjectRepository(FolderEntity folder) throws Exception {
        return EntityFileServiceManager.getDescendants(folder, WebElementEntity.class);
    }

    public static List<TestCaseEntity> getDescendantTestCasesOfFolder(FolderEntity folder) throws Exception {
        return EntityFileServiceManager.getDescendants(folder, TestCaseEntity.class);
    }

    public static List<TestSuiteEntity> getDescendantTestSuitesOfFolder(FolderEntity folder) throws Exception {
        return EntityFileServiceManager.getDescendants(folder, TestSuiteEntity.class, null);
    }

    public static List<TestSuiteEntity> getDescendantTestSuitesOfFolder(FolderEntity folder, IEntityLoadStrategy entityLoadStrategy) throws Exception {
        return EntityFileServiceManager.getDescendants(folder, TestSuiteEntity.class, entityLoadStrategy);
    }

    public static List<DataFileEntity> getDescendantDataFilesOfFolder(FolderEntity folder) throws Exception {
        return EntityFileServiceManager.getDescendants(folder, DataFileEntity.class);
    }

    public static List<ReportCollectionEntity> getDescendantReportCollectionOfFolder(FolderEntity folder) throws Exception {
        return EntityFileServiceManager.getDescendants(folder, ReportCollectionEntity.class);
    }

    public static void updateFolderName(FolderEntity folderEntity, String newName) throws Exception {
        if (folderEntity != null) {
            EntityService.getInstance().validateName(newName);
            ProjectEntity project = folderEntity.getProject();
            String location = folderEntity.getLocation();
            File folder = new File(location);
            if (folder.isDirectory()) {
                String oldKey;
                String newPath = folder.getParent() + File.separator + newName;
                PathValidationUtil.validatePathLength(newPath, (FileEntity)folderEntity);
                File newFolder = new File(newPath);
                if (newFolder.exists() && !newName.equalsIgnoreCase(folderEntity.getName())) {
                    throw new DuplicatedFolderException(MessageFormat.format(StringConstants.MNG_EXC_EXISTED_FOLDER_NAME, newName));
                }
                if (folder.list().length > 0) {
                    String oldRelativeFolderLocation = folderEntity.getRelativePath();
                    FolderEntity testSuiteRoot = FolderFileServiceManager.getTestSuiteRoot(project);
                    List<TestSuiteEntity> allTestSuites = FolderFileServiceManager.getDescendantTestSuitesOfFolder(testSuiteRoot);
                    List<TestCaseEntity> descendantTestCases = FolderFileServiceManager.getDescendantTestCasesOfFolder(folderEntity);
                    for (TestCaseEntity testCase : descendantTestCases) {
                        GroovyUtil.loadScriptContentIntoTestCase((TestCaseEntity)testCase);
                    }
                    IFolder oldScriptFolder = GroovyUtil.getGroovyProject((ProjectEntity)project).getFolder(GroovyUtil.getScriptPackageRelativePathForFolder((FolderEntity)folderEntity));
                    String oldName = folderEntity.getName();
                    boolean updated = folder.renameTo(newFolder);
                    if (updated) {
                        folderEntity.setName(newName);
                        EntityService.getInstance().getEntityCache().replaceKeys(location, folderEntity.getLocation());
                        switch (folderEntity.getFolderType()) {
                            case DATAFILE: {
                                DataFileFileServiceManager.saveAllReferencesToDataFileAfterFolderRenamed(oldRelativeFolderLocation, folderEntity, allTestSuites);
                                break;
                            }
                            case KEYWORD: {
                                break;
                            }
                            case REPORT: {
                                break;
                            }
                            case TESTCASE: {
                                IFolder newScriptFolder;
                                File newScriptDirectory;
                                File oldScriptsDirectory;
                                if ((oldName.equalsIgnoreCase(newName) || !descendantTestCases.isEmpty() && descendantTestCases.get(0).getParentFolder().getName().equals(oldName)) && (oldScriptsDirectory = oldScriptFolder.getRawLocation().makeAbsolute().toFile()).renameTo(newScriptDirectory = (newScriptFolder = GroovyUtil.getGroovyProject((ProjectEntity)project).getFolder(GroovyUtil.getScriptPackageRelativePathForFolder((FolderEntity)folderEntity))).getRawLocation().makeAbsolute().toFile())) {
                                    for (TestCaseEntity testCase : descendantTestCases) {
                                        testCase.setParentFolder(folderEntity);
                                    }
                                    GroovyUtil.getTestCaseScriptSourceFolder((ProjectEntity)project).refreshLocal(2, null);
                                }
                                for (TestCaseEntity testCase : descendantTestCases) {
                                    GroovyUtil.updateTestCasePasted((TestCaseEntity)testCase);
                                }
                                TestCaseFileServiceManager.updateReferencesTestCaseFolder(oldRelativeFolderLocation, folderEntity, allTestSuites);
                                if (oldScriptFolder.exists()) {
                                    oldScriptFolder.delete(true, false, null);
                                    GroovyUtil.getTestCaseScriptSourceFolder((ProjectEntity)project).refreshLocal(2, null);
                                }
                                GroovyUtil.refreshInfiniteScriptTestCaseClasspath((ProjectEntity)folderEntity.getProject(), (FolderEntity)folderEntity.getParentFolder(), null);
                                break;
                            }
                            case TESTSUITE: {
                                break;
                            }
                            case WEBELEMENT: {
                                WebElementFileServiceManager.updateFolderTestObjectReferences(folderEntity, oldRelativeFolderLocation);
                                break;
                            }
                            case CHECKPOINT: {
                                CheckpointFileServiceManager.updateFolderCheckpointReferences(folderEntity, oldRelativeFolderLocation);
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else if (folder.renameTo(newFolder)) {
                    folderEntity.setName(newName);
                }
                if ((oldKey = EntityService.getInstance().getEntityCache().getKey((FileEntity)folderEntity)) != null) {
                    EntityService.getInstance().getEntityCache().remove(oldKey);
                }
                EntityService.getInstance().getEntityCache().put(folderEntity.getLocation(), (FileEntity)folderEntity);
                EntityService.getInstance().saveIntergratedFolderMetadataEntity((IntegratedFileEntity)folderEntity);
                FolderFileServiceManager.refreshFolder(folderEntity.getParentFolder());
            }
        }
    }

    public static FolderEntity getFolderByName(FolderEntity parentFolder, String name, ProjectEntity project) throws Exception {
        List<FolderEntity> folders = FolderFileServiceManager.getChildFoldersOfFolder(parentFolder);
        for (FolderEntity folder : folders) {
            if (!folder.getName().equals(name)) continue;
            return folder;
        }
        return null;
    }

    public static String getAvailableFolderName(FolderEntity parentFolder, String name) throws Exception {
        String newname = name;
        int i = 0;
        List<FolderEntity> folders = FolderFileServiceManager.getChildFoldersOfFolder(parentFolder);
        if (folders != null && folders.size() != 0) {
            Boolean flag = false;
            while (!flag.booleanValue()) {
                Boolean duplicate = false;
                for (FolderEntity folder : folders) {
                    if (!folder.getName().equals(newname)) continue;
                    duplicate = true;
                }
                if (!duplicate.booleanValue()) {
                    flag = true;
                    continue;
                }
                newname = MessageFormat.format("{0} ({1})", name, ++i);
            }
        }
        return newname;
    }

    public static void deleteFolder(FolderEntity folder) throws Exception {
        if (folder != null) {
            switch (folder.getFolderType()) {
                case TESTCASE: {
                    TestCaseFileServiceManager.deleteTestCaseFolder(folder);
                    break;
                }
                case DATAFILE: {
                    DataFileFileServiceManager.deteleDataFileFolder(folder);
                    break;
                }
                default: {
                    EntityFileServiceManager.deleteFolder(folder);
                }
            }
            FolderFileServiceManager.refreshFolder(folder);
        }
    }

    public static FolderEntity loadAllTestCaseDescendants(FolderEntity folder) throws Exception {
        ArrayList<Object> childrenEntities = new ArrayList<Object>();
        childrenEntities.addAll(FolderFileServiceManager.getChildTestCasesOfFolder(folder));
        childrenEntities.addAll(FolderFileServiceManager.getChildFoldersOfFolder(folder));
        if (childrenEntities != null) {
            folder.setChildrenEntities(childrenEntities);
            for (Object e : childrenEntities) {
                if (!(e instanceof FolderEntity)) continue;
                FolderFileServiceManager.loadAllTestCaseDescendants((FolderEntity)e);
            }
        }
        return folder;
    }

    public static FolderEntity copyFolder(FolderEntity folder, FolderEntity destinationFolder) throws Exception {
        switch (folder.getFolderType()) {
            case TESTCASE: {
                return TestCaseFileServiceManager.copyTestCaseFolder(folder, destinationFolder);
            }
            case TESTSUITE: 
            case DATAFILE: 
            case WEBELEMENT: 
            case CHECKPOINT: {
                return EntityFileServiceManager.copyFolder(folder, destinationFolder);
            }
            case KEYWORD: {
                return EntityFileServiceManager.copyKeywordFolder(folder, destinationFolder);
            }
            case INCLUDE: {
                return new SystemFileServiceDataProvider().copyFolder(folder, destinationFolder);
            }
        }
        return null;
    }

    public static FolderEntity moveFolder(FolderEntity folder, FolderEntity destinationFolder) throws Exception {
        String oldRelativeFolderLocation = folder.getRelativePath();
        FolderEntity movedFolder = EntityFileServiceManager.moveFolder(folder, destinationFolder);
        if (movedFolder != null) {
            switch (movedFolder.getFolderType()) {
                case WEBELEMENT: {
                    WebElementFileServiceManager.updateFolderTestObjectReferences(movedFolder, oldRelativeFolderLocation);
                    break;
                }
                case TESTCASE: {
                    ProjectEntity project = movedFolder.getProject();
                    FolderEntity testSuiteRoot = FolderFileServiceManager.getTestSuiteRoot(project);
                    List<TestSuiteEntity> allTestSuites = FolderFileServiceManager.getDescendantTestSuitesOfFolder(testSuiteRoot);
                    TestCaseFileServiceManager.updateReferencesTestCaseFolder(oldRelativeFolderLocation, movedFolder, allTestSuites);
                    break;
                }
                case DATAFILE: {
                    ProjectEntity dataProject = movedFolder.getProject();
                    FolderEntity dataTestSuiteRoot = FolderFileServiceManager.getTestSuiteRoot(dataProject);
                    List<TestSuiteEntity> dataAllTestSuites = FolderFileServiceManager.getDescendantTestSuitesOfFolder(dataTestSuiteRoot);
                    DataFileFileServiceManager.saveAllReferencesToDataFileAfterFolderRenamed(oldRelativeFolderLocation, movedFolder, dataAllTestSuites);
                    break;
                }
                case CHECKPOINT: {
                    CheckpointFileServiceManager.updateFolderCheckpointReferences(movedFolder, oldRelativeFolderLocation);
                    break;
                }
            }
        }
        return movedFolder;
    }

    public static void refreshFolder(FolderEntity folder) throws CoreException {
        GroovyRefreshUtil.refreshFolder((String)folder.getRelativePath(), (ProjectEntity)folder.getProject(), null);
    }

    public static void refreshFolderScriptReferences(String oldFolderId, FolderEntity folder) throws CoreException, IOException {
        new TestArtifactScriptRefactor(folder.getFolderType(), oldFolderId, false, false, false, true).updateReferenceForProject(folder.getIdForDisplay() + "/", folder.getProject());
    }

    public static FolderEntity saveFolder(FolderEntity folder) throws Exception {
        EntityService.getInstance().saveIntergratedFolderMetadataEntity((IntegratedFileEntity)folder);
        return folder;
    }

    public static FolderEntity getProfileRoot(ProjectEntity project) throws DALException {
        try {
            FolderEntity folder = FolderFileServiceManager.getFolder(FileServiceConstant.getProfileFolderLocation(project.getFolderLocation()), project);
            if (folder != null) {
                folder.setProject(project);
                folder.setFolderType(FolderEntity.FolderType.PROFILE);
                return folder;
            }
            return null;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }
}

