/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.manager;

import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.constants.StringConstants;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.ProjectFileServiceManager;
import com.kms.katalon.dal.fileservice.util.PathValidationUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.global.GlobalVariableEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalVariableFileServiceManager {
    private static Logger logger = LoggerFactory.getLogger(GlobalVariableFileServiceManager.class);

    public static List<GlobalVariableEntity> getAll(String projectPk) throws Exception {
        ExecutionProfileEntity wrapper;
        if (projectPk != null && (wrapper = GlobalVariableFileServiceManager.getWrapper(projectPk)) != null) {
            return wrapper.getGlobalVariableEntities();
        }
        return Collections.emptyList();
    }

    public static GlobalVariableEntity addNewVariable(String newName, String value, String projectPk) throws Exception {
        ExecutionProfileEntity wrapper = GlobalVariableFileServiceManager.getWrapper(projectPk);
        for (GlobalVariableEntity variable : wrapper.getGlobalVariableEntities()) {
            if (!variable.getName().equals(newName)) continue;
            return null;
        }
        GlobalVariableEntity newVariable = new GlobalVariableEntity(newName, value);
        wrapper.getGlobalVariableEntities().add(newVariable);
        GlobalVariableFileServiceManager.save(wrapper);
        return newVariable;
    }

    private static ExecutionProfileEntity getWrapper(String projectPk) throws Exception {
        if (projectPk != null) {
            ProjectEntity project = ProjectFileServiceManager.getProject(projectPk);
            File globalVariableFile = new File(FileServiceConstant.getLegacyGlobalVariableFileLocation(project.getFolderLocation()));
            ExecutionProfileEntity wrapper = null;
            if (globalVariableFile.exists()) {
                wrapper = (ExecutionProfileEntity)EntityService.getInstance().getEntityByPath(globalVariableFile.getAbsolutePath());
                wrapper.setProject(project);
                ISecurePreferences securePreferences = GlobalVariableFileServiceManager.loadSecurePreferences(wrapper);
                List globalVariableEntities = wrapper.getGlobalVariableEntities();
                globalVariableEntities = globalVariableEntities.stream().map(g -> {
                    if (g.isProtected()) {
                        try {
                            String value = securePreferences.get(g.getName(), null);
                            if (value != null) {
                                g.setProtectedValue(value);
                                g.setInitValue(g.getDefaultValue());
                            } else {
                                value = g.getDefaultValue();
                                g.setProtectedValue(value);
                                g.setInitValue(value);
                            }
                        }
                        catch (StorageException e) {
                            logger.error(e.getMessage());
                        }
                    }
                    return g;
                }).collect(Collectors.toList());
                wrapper.setGlobalVariableEntities(globalVariableEntities);
            } else {
                wrapper = new ExecutionProfileEntity();
                wrapper.setProject(project);
                GlobalVariableFileServiceManager.save(wrapper);
            }
            return wrapper;
        }
        return null;
    }

    public static List<GlobalVariableEntity> updateVariables(List<GlobalVariableEntity> listVariable, String projectPk) throws Exception {
        ExecutionProfileEntity wrapper = GlobalVariableFileServiceManager.getWrapper(projectPk);
        wrapper.setGlobalVariableEntities(listVariable);
        GlobalVariableFileServiceManager.save(wrapper);
        return wrapper.getGlobalVariableEntities();
    }

    public static void save(ExecutionProfileEntity executionProfile) throws Exception {
        ISecurePreferences securePreferences = GlobalVariableFileServiceManager.loadSecurePreferences(executionProfile);
        executionProfile.getGlobalVariableEntities().stream().map(g -> {
            try {
                if (g.isProtected()) {
                    securePreferences.put(g.getName(), g.getProtectedValue(), true);
                } else {
                    securePreferences.remove(g.getName());
                }
            }
            catch (StorageException e) {
                logger.error(e.getMessage());
            }
            return g;
        }).collect(Collectors.toList());
        try {
            securePreferences.flush();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        EntityService.getInstance().saveEntity((FileEntity)executionProfile);
    }

    public static void delete(ExecutionProfileEntity executionProfile) throws Exception {
        ISecurePreferences securePreferences = GlobalVariableFileServiceManager.loadSecurePreferences(executionProfile);
        securePreferences.removeNode();
        try {
            securePreferences.flush();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        EntityService.getInstance().deleteEntity((FileEntity)executionProfile);
    }

    public static void rename(ExecutionProfileEntity executionProfile, String newName) throws Exception {
        GlobalVariableFileServiceManager.delete(executionProfile);
        executionProfile.setName(newName);
        GlobalVariableFileServiceManager.save(executionProfile);
    }

    public static ExecutionProfileEntity get(String name, ProjectEntity project) throws DALException {
        ExecutionProfileEntity executionProfile;
        String path;
        FolderEntity parentFolder;
        block3: {
            try {
                parentFolder = FolderFileServiceManager.getProfileRoot(project);
                path = new File(parentFolder.getLocation(), name + ExecutionProfileEntity.getGlobalVariableFileExtension()).getAbsolutePath();
                executionProfile = (ExecutionProfileEntity)EntityService.getInstance().getEntityByPath(path);
                if (executionProfile != null) break block3;
                return null;
            }
            catch (Exception e) {
                throw new DALException(e);
            }
        }
        executionProfile.setProject(parentFolder.getProject());
        executionProfile.setParentFolder(parentFolder);
        executionProfile.setHasWarning(false);
        IFile warningResource = GlobalVariableFileServiceManager.getIFileFromPath(path);
        GlobalVariableFileServiceManager.clearWarnings((IResource)warningResource);
        ISecurePreferences securePreferences = GlobalVariableFileServiceManager.loadSecurePreferences(executionProfile);
        List globalVariableEntities = executionProfile.getGlobalVariableEntities();
        globalVariableEntities = globalVariableEntities.stream().map(g -> {
            if (g.isProtected()) {
                try {
                    String value = securePreferences.get(g.getName(), null);
                    if (value != null) {
                        g.setProtectedValue(value);
                        g.setInitValue(g.getDefaultValue());
                    } else {
                        value = g.getDefaultValue();
                        g.setProtectedValue(value);
                        g.setInitValue(value);
                    }
                    if (g.isDefaultValue()) {
                        executionProfile.setHasWarning(true);
                        GlobalVariableFileServiceManager.addWarning((IResource)warningResource, MessageFormat.format(StringConstants.MNG_PROTECTED_GLOBAL_VARIABLE_NOT_SET_OR_MISSING, g.getName(), executionProfile.getName()));
                    }
                }
                catch (StorageException e) {
                    logger.error(e.getMessage());
                }
            }
            return g;
        }).collect(Collectors.toList());
        executionProfile.setGlobalVariableEntities(globalVariableEntities);
        return executionProfile;
    }

    public static ExecutionProfileEntity getById(String id, ProjectEntity project) throws DALException {
        try {
            FolderEntity parentFolder = FolderFileServiceManager.getProfileRoot(project);
            String name = id.replace(parentFolder.getId(), "").replace(File.pathSeparator, "").replace(ExecutionProfileEntity.getGlobalVariableFileExtension(), "");
            return GlobalVariableFileServiceManager.get(name, project);
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public static ExecutionProfileEntity newProfile(String newName, boolean defaultProfile, ProjectEntity project) throws DALException {
        return GlobalVariableFileServiceManager.newProfile(newName, defaultProfile, Collections.emptyList(), project);
    }

    public static ExecutionProfileEntity newProfile(String newName, boolean defaultProfile, List<GlobalVariableEntity> variables, ProjectEntity project) throws DALException {
        ExecutionProfileEntity newProfile = new ExecutionProfileEntity();
        newProfile.setName(newName);
        newProfile.setParentFolder(FolderFileServiceManager.getProfileRoot(project));
        newProfile.setProject(project);
        newProfile.setDefaultProfile(defaultProfile);
        newProfile.setGlobalVariableEntities(new ArrayList<GlobalVariableEntity>(variables));
        try {
            PathValidationUtil.validatePathLength((FileEntity)newProfile);
            EntityService.getInstance().saveEntity((FileEntity)newProfile);
        }
        catch (Exception e) {
            throw new DALException(e);
        }
        return newProfile;
    }

    public static List<ExecutionProfileEntity> getAll(ProjectEntity project) throws DALException {
        FolderEntity profileFolder = FolderFileServiceManager.getProfileRoot(project);
        File folder = new File(profileFolder.getLocation());
        if (!folder.exists()) {
            return Collections.emptyList();
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).filter(f -> f.getName().endsWith(ExecutionProfileEntity.getGlobalVariableFileExtension())).map(f -> {
            try {
                return GlobalVariableFileServiceManager.get(FilenameUtils.getBaseName((String)f.getName()), project);
            }
            catch (DALException dALException) {
                return null;
            }
        }).filter(p -> p != null).collect(Collectors.toList());
    }

    public static ISecurePreferences loadSecurePreferences(ExecutionProfileEntity executionProfileEntity) {
        ISecurePreferences securePreferences = null;
        try {
            File secureStorageFolder = Paths.get(SystemUtils.getUserHome().toString(), ".katalon", "secure_storage").toFile();
            File secureStorageFile = new File(secureStorageFolder, executionProfileEntity.getProject().getUUID());
            ISecurePreferences root = SecurePreferencesFactory.open((URL)secureStorageFile.toURI().toURL(), null);
            if (root != null) {
                securePreferences = root.node(executionProfileEntity.getName());
                securePreferences.flush();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return securePreferences;
    }

    public static IFile getIFileFromPath(String filePath) {
        Path path = new Path(filePath);
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
    }

    public static void addWarning(IResource resource, String message) {
        if (resource == null) {
            return;
        }
        try {
            IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", 1);
        }
        catch (CoreException e) {
            logger.error(e.getMessage());
        }
    }

    public static void clearWarnings(IResource resource) {
        if (resource == null || !resource.exists()) {
            return;
        }
        try {
            resource.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            logger.error(e.getMessage());
        }
    }
}

