/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.manager;

import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.dal.exception.InvalidNameException;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.constants.StringConstants;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.TestCaseFileServiceManager;
import com.kms.katalon.dal.fileservice.strategies.IEntityLoadStrategy;
import com.kms.katalon.dal.fileservice.strategies.StringMatchPrecheckEntityLoadStrategy;
import com.kms.katalon.dal.fileservice.util.PathValidationUtil;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.dal.exception.DuplicatedFileNameException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.entity.webservice.TextBodyContent;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import com.kms.katalon.groovy.util.GroovyRefreshUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.ExecutionTimeTracker;
import com.kms.katalon.util.URLBuilder;
import com.kms.katalon.util.collections.NameValuePair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class WebElementFileServiceManager {
    private static Map<String, File> objectRepositoryLookup = new HashMap<String, File>();

    public static WebElementEntity getWebElement(String webElementFileLocation) throws Exception {
        return WebElementFileServiceManager.getWebElement(webElementFileLocation, null);
    }

    public static WebElementEntity getWebElement(String webElementFileLocation, IEntityLoadStrategy entityLoadStrategy) throws Exception {
        FileEntity entity = null;
        if (webElementFileLocation != null) {
            entity = EntityFileServiceManager.get(new File(webElementFileLocation), entityLoadStrategy);
        }
        if (entity != null && entity instanceof WebElementEntity) {
            if (entity instanceof WebServiceRequestEntity) {
                WebServiceRequestEntity requestEntity = (WebServiceRequestEntity)entity;
                WebElementFileServiceManager.migrateWSRequestEntityToVersion5_4_1(requestEntity);
            }
            return (WebElementEntity)entity;
        }
        return null;
    }

    private static void migrateWSRequestEntityToVersion5_4_1(WebServiceRequestEntity requestEntity) throws Exception {
        if (!StringUtils.isBlank((String)requestEntity.getMigratedVersion())) {
            return;
        }
        if ("RESTful".equals(requestEntity.getServiceType())) {
            if (!requestEntity.getRestParameters().isEmpty()) {
                String restUrl = requestEntity.getRestUrl();
                URLBuilder urlBuilder = new URLBuilder(restUrl);
                List paramProperties = requestEntity.getRestParameters();
                requestEntity.setRestParameters(Collections.emptyList());
                List params = paramProperties.stream().map(pr -> new NameValuePair(pr.getName(), pr.getValue())).collect(Collectors.toList());
                urlBuilder.addParameters(params);
                requestEntity.setRestUrl(urlBuilder.buildString());
                requestEntity.setRestParameters(Collections.emptyList());
            }
            if (StringUtils.isBlank((String)requestEntity.getHttpBodyType()) && !StringUtils.isBlank((String)requestEntity.getHttpBody())) {
                String httpBody = requestEntity.getHttpBody();
                requestEntity.setHttpBodyType("text");
                TextBodyContent bodyContent = new TextBodyContent();
                bodyContent.setText(httpBody);
                requestEntity.setHttpBodyContent(JsonUtil.toJson((Object)bodyContent));
            }
            requestEntity.setMigratedVersion("5.4.1");
            WebElementFileServiceManager.saveNewTestObject((WebElementEntity)requestEntity);
        }
    }

    public static WebElementEntity saveNewTestObject(WebElementEntity newTestObject) throws Exception {
        if (newTestObject == null || newTestObject.getProject() == null || newTestObject.getParentFolder() == null) {
            return null;
        }
        if (newTestObject instanceof WebServiceRequestEntity) {
            WebServiceRequestEntity requestEntity = (WebServiceRequestEntity)newTestObject;
            requestEntity.setKatalonVersion(System.getProperty("application.version"));
        }
        PathValidationUtil.validatePathLength((FileEntity)newTestObject);
        EntityService.getInstance().saveEntity((FileEntity)newTestObject);
        return newTestObject;
    }

    public static String getAvailableWebElementName(FolderEntity parentFolder, String name) throws Exception {
        Object newname = name;
        int i = 0;
        List<Object> entityList = null;
        if (parentFolder != null) {
            entityList = WebElementFileServiceManager.getAllChildren(parentFolder);
        }
        if (entityList != null && entityList.size() != 0) {
            Boolean flag = false;
            while (!flag.booleanValue()) {
                Boolean duplicate = false;
                for (Object iEntity : entityList) {
                    if (!((WebElementEntity)iEntity).getName().equalsIgnoreCase((String)newname)) continue;
                    duplicate = true;
                }
                if (!duplicate.booleanValue()) {
                    flag = true;
                    continue;
                }
                newname = name + " (" + Integer.toString(++i) + ")";
            }
        }
        return newname;
    }

    public static void deleteWebElement(WebElementEntity webElement) throws Exception {
        EntityFileServiceManager.delete((FileEntity)webElement);
        FolderFileServiceManager.refreshFolder(webElement.getParentFolder());
    }

    public static List<Object> getAllChildren(FolderEntity parentFolder) throws Exception {
        File folder;
        if (parentFolder != null && (folder = new File(parentFolder.getLocation())).exists() && folder.isDirectory()) {
            ArrayList<Object> result = new ArrayList<Object>();
            File[] fileArray = folder.listFiles(EntityFileServiceManager.fileFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && file.getName().endsWith(WebElementEntity.getWebElementFileExtension())) {
                    WebElementEntity webElement = WebElementFileServiceManager.getWebElement(file.getAbsolutePath());
                    webElement.setParentFolder(parentFolder);
                    result.add(webElement);
                }
                ++n2;
            }
            return result;
        }
        return new ArrayList<Object>();
    }

    public static List<Object> getAllFiles(FolderEntity parentFolder) throws Exception {
        File folder;
        if (parentFolder != null && (folder = new File(parentFolder.getLocation())).exists() && folder.isDirectory()) {
            ArrayList<Object> result = new ArrayList<Object>();
            File[] fileArray = folder.listFiles(EntityFileServiceManager.fileFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && file.getName().endsWith(WebElementEntity.getWebElementFileExtension())) {
                    WebElementEntity webElement = WebElementFileServiceManager.getWebElement(file.getAbsolutePath());
                    webElement.setParentFolder(parentFolder);
                    result.add(webElement);
                } else if (file.isDirectory()) {
                    FolderEntity aFoler = FolderController.getInstance().getFolder(file.getAbsolutePath());
                    result.addAll(WebElementFileServiceManager.getAllFiles(aFoler));
                }
                ++n2;
            }
            return result;
        }
        return new ArrayList<Object>();
    }

    public static List<Object> getAllChildren(String folderLocation, WebElementEntity parentWebElement, FolderEntity parentFolder) throws Exception {
        File folder = new File(folderLocation);
        if (folder.exists() && folder.isDirectory()) {
            ArrayList<Object> result = new ArrayList<Object>();
            File[] fileArray = folder.listFiles(EntityFileServiceManager.fileFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && file.getName().endsWith(WebElementEntity.getWebElementFileExtension())) {
                    WebElementEntity webElement = WebElementFileServiceManager.getWebElement(file.getAbsolutePath());
                    webElement.setParentFolder(parentFolder);
                    result.add(webElement);
                }
                ++n2;
            }
            return result;
        }
        return new ArrayList<Object>();
    }

    private static List<IEntity> getWebElementByName(FolderEntity parentFolder, String name) throws Exception {
        ArrayList<IEntity> children = new ArrayList<IEntity>();
        List<Object> childWebElements = WebElementFileServiceManager.getAllChildren(parentFolder);
        for (Object object : childWebElements) {
            WebElementEntity webElement;
            if (!(object instanceof WebElementEntity) || !(webElement = (WebElementEntity)object).getName().toLowerCase().contains(name.toLowerCase())) continue;
            children.add((IEntity)webElement);
        }
        return children;
    }

    public static List<IEntity> getElement(FolderEntity rootFolder, String webElementName, int num) throws Exception {
        List<IEntity> childWebElements = WebElementFileServiceManager.getWebElementByName(rootFolder, webElementName);
        return childWebElements.size() > num ? childWebElements.subList(0, num) : childWebElements;
    }

    public static WebElementEntity updateTestObject(WebElementEntity webElement) throws Exception {
        WebElementFileServiceManager.validateToRename(webElement);
        return webElement;
    }

    private static void validateToRename(WebElementEntity webElement) throws Exception {
        String oldPk;
        boolean isNameChanged = WebElementFileServiceManager.isNameChanged(webElement);
        if (isNameChanged) {
            try {
                PathValidationUtil.validatePathLength((FileEntity)webElement);
                EntityService.getInstance().validateName(webElement.getName());
            }
            catch (InvalidNameException ex) {
                String oldPk2 = EntityService.getInstance().getEntityCache().getKey((FileEntity)webElement);
                webElement.setName(FilenameUtils.getExtension((String)oldPk2));
                throw ex;
            }
            File duplicatedWebElementFile = new File(webElement.getLocation());
            if (duplicatedWebElementFile.exists()) {
                throw new DuplicatedFileNameException(webElement.getName());
            }
        }
        if ((oldPk = EntityService.getInstance().getEntityCache().getKey((FileEntity)webElement)) == null) {
            EntityService.getInstance().saveEntity((FileEntity)webElement);
            return;
        }
        if (isNameChanged) {
            File webElementFile = new File(EntityService.getInstance().getEntityCache().getKey((FileEntity)webElement));
            EntityService.getInstance().getEntityCache().remove((FileEntity)webElement, false);
            if (webElementFile.exists() && webElementFile.isFile() && webElementFile.getName().endsWith(WebElementEntity.getWebElementFileExtension())) {
                webElementFile.renameTo(new File(webElement.getLocation()));
                EntityService.getInstance().saveEntity((FileEntity)webElement);
                WebElementFileServiceManager.updateTestCaseFileReferences(oldPk, webElement.getIdForDisplay(), ProjectController.getInstance().getCurrentProject());
                WebElementFileServiceManager.updateTestObjectReferences(webElement, oldPk);
            }
            FolderFileServiceManager.refreshFolder(webElement.getParentFolder());
            return;
        }
        EntityService.getInstance().saveEntity((FileEntity)webElement);
    }

    private static boolean isNameChanged(WebElementEntity webElement) throws Exception {
        String webElementLocation = EntityService.getInstance().getEntityCache().getKey((FileEntity)webElement);
        if (webElementLocation == null) {
            return false;
        }
        return !webElementLocation.toLowerCase().equals(webElement.getLocation().toLowerCase());
    }

    private static void updateTestObjectReferences(WebElementEntity webElement, String oldPk) throws Exception {
        FolderFileServiceManager.refreshFolder(webElement.getParentFolder());
        ProjectEntity project = webElement.getProject();
        String oldRelativeToLocation = oldPk.substring(project.getFolderLocation().length() + 1);
        String oldRelativeToId = FilenameUtils.removeExtension((String)oldRelativeToLocation).replace(File.separator, "/");
        String newRelativeToId = webElement.getRelativePathForUI().replace(File.separator, "/");
        TestArtifactScriptRefactor.createForTestObjectEntity((String)oldRelativeToId).updateReferenceForProject(newRelativeToId, project);
        block0: for (WebElementEntity referenceEntity : WebElementFileServiceManager.getWebElementPropertyByRefElement(oldRelativeToId, project, true)) {
            for (WebElementPropertyEntity webElementProperty : referenceEntity.getWebElementProperties()) {
                if (!webElementProperty.getName().equalsIgnoreCase("ref_element") || !oldRelativeToId.equals(webElementProperty.getValue())) continue;
                webElementProperty.setValue(newRelativeToId);
                EntityService.getInstance().saveEntity((FileEntity)referenceEntity);
                GroovyRefreshUtil.refreshFile((String)referenceEntity.getRelativePath(), (ProjectEntity)project);
                continue block0;
            }
        }
    }

    public static void updateFolderTestObjectReferences(FolderEntity webElementFolder, String oldRelativeToLocation) throws Exception {
        ProjectEntity project = webElementFolder.getProject();
        String oldRelativeToId = oldRelativeToLocation.replace(File.separator, "/") + "/";
        String newRelativeToId = webElementFolder.getRelativePathForUI().replace(File.separator, "/") + "/";
        FolderFileServiceManager.refreshFolderScriptReferences(oldRelativeToId, webElementFolder);
        block0: for (WebElementEntity referenceEntity : WebElementFileServiceManager.getWebElementPropertyByRefElement(oldRelativeToId, project, false)) {
            for (WebElementPropertyEntity webElementProperty : referenceEntity.getWebElementProperties()) {
                if (!webElementProperty.getName().equalsIgnoreCase("ref_element") || webElementProperty.getValue() == null || !webElementProperty.getValue().startsWith(oldRelativeToId)) continue;
                String newValue = webElementProperty.getValue().replace(oldRelativeToId, newRelativeToId);
                webElementProperty.setValue(newValue);
                EntityService.getInstance().saveEntity((FileEntity)referenceEntity);
                GroovyRefreshUtil.refreshFile((String)referenceEntity.getRelativePath(), (ProjectEntity)project);
                continue block0;
            }
        }
    }

    public static WebElementEntity copyWebElement(WebElementEntity webElement, FolderEntity destinationFolder) throws Exception {
        return EntityFileServiceManager.copy(webElement, destinationFolder);
    }

    public static WebElementEntity moveWebElement(WebElementEntity webElement, FolderEntity destinationFolder) throws Exception {
        String oldWebElementLocation = webElement.getLocation();
        WebElementEntity newWebElement = EntityFileServiceManager.move(webElement, destinationFolder);
        if (!newWebElement.getLocation().equalsIgnoreCase(oldWebElementLocation)) {
            WebElementFileServiceManager.updateTestObjectReferences(newWebElement, oldWebElementLocation);
        }
        return newWebElement;
    }

    public static WebElementEntity getDuplicateWebElement(WebElementEntity parentWebElement, FolderEntity parentFolder, String name, ProjectEntity project) throws Exception {
        List<Object> webElements = null;
        if (parentFolder != null) {
            webElements = WebElementFileServiceManager.getAllChildren(parentFolder);
        }
        if (webElements != null) {
            for (Object object : webElements) {
                WebElementEntity webElement;
                if (!(object instanceof WebElementEntity) || !(webElement = (WebElementEntity)object).getName().equals(name)) continue;
                return webElement;
            }
        }
        return null;
    }

    public static WebElementEntity getByGUID(String guid, ProjectEntity project) throws Exception {
        File webElementFolder;
        File projectFolder = new File(project.getFolderLocation());
        if (projectFolder.exists() && projectFolder.isDirectory() && (webElementFolder = new File(FileServiceConstant.getObjectRepositoryRootFolderLocation(projectFolder.getAbsolutePath()))).exists() && webElementFolder.isDirectory()) {
            return WebElementFileServiceManager.getByGUID(webElementFolder.getAbsolutePath(), guid);
        }
        return null;
    }

    private static WebElementEntity getByGUID(String webElementFolder, String guid) throws Exception {
        File folder = new File(webElementFolder);
        if (folder.exists() && folder.isDirectory()) {
            File[] fileArray = folder.listFiles(EntityFileServiceManager.fileFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                WebElementEntity webElement;
                File file = fileArray[n2];
                if (file.isFile() && file.getName().toLowerCase().endsWith(WebElementEntity.getWebElementFileExtension().toLowerCase()) && (webElement = WebElementFileServiceManager.getWebElement(file.getAbsolutePath())).getElementGuidId().equals(guid)) {
                    return webElement;
                }
                ++n2;
            }
        }
        return null;
    }

    public static List<WebElementEntity> getWebElementPropertyByRefElement(final String refElement, ProjectEntity project, boolean isExactly) throws Exception {
        File webElementFolder;
        String taskName = "Find web elements to rename test object ref";
        ExecutionTimeTracker.getInstance().start(taskName);
        ArrayList<WebElementEntity> returnList = new ArrayList<WebElementEntity>();
        StringMatchPrecheckEntityLoadStrategy entityLoadStrategy = new StringMatchPrecheckEntityLoadStrategy(new Predicate<String>(){

            @Override
            public boolean test(String fileContent) {
                if (!StringUtils.containsIgnoreCase((String)fileContent, (String)"ref_element")) {
                    return false;
                }
                return StringUtils.containsIgnoreCase((String)fileContent, (String)refElement);
            }
        });
        File projectFolder = new File(project.getFolderLocation());
        if (projectFolder.exists() && projectFolder.isDirectory() && (webElementFolder = new File(FileServiceConstant.getObjectRepositoryRootFolderLocation(projectFolder.getAbsolutePath()))).exists() && webElementFolder.isDirectory()) {
            WebElementFileServiceManager.getWebElementPropertyByRefElement(returnList, webElementFolder.getAbsolutePath(), refElement, isExactly, entityLoadStrategy);
        }
        ExecutionTimeTracker.getInstance().stop(taskName);
        return returnList;
    }

    private static void getWebElementPropertyByRefElement(List<WebElementEntity> webElementList, String webElementFolder, String refElement, boolean isExactly, IEntityLoadStrategy entityLoadStrategy) throws Exception {
        File folder = new File(webElementFolder);
        if (!folder.exists() || !folder.isDirectory()) {
            return;
        }
        String lowercaseFileExt = WebElementEntity.getWebElementFileExtension().toLowerCase();
        File[] fileArray = folder.listFiles(EntityFileServiceManager.fileFilter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    WebElementFileServiceManager.getWebElementPropertyByRefElement(webElementList, file.getAbsolutePath(), refElement, isExactly, entityLoadStrategy);
                } else if (file.isFile() && StringUtils.endsWithIgnoreCase((String)file.getName(), (String)lowercaseFileExt)) {
                    try {
                        WebElementEntity webElement = WebElementFileServiceManager.getWebElement(file.getAbsolutePath(), entityLoadStrategy);
                        if (webElement == null) break block8;
                        for (WebElementPropertyEntity webElementProperty : webElement.getWebElementProperties()) {
                            if (webElementProperty.getValue() == null || !webElementProperty.getName().equalsIgnoreCase("ref_element") || (!isExactly || !webElementProperty.getValue().equalsIgnoreCase(refElement)) && (isExactly || !webElementProperty.getValue().startsWith(refElement))) continue;
                            webElementList.add(webElement);
                            break;
                        }
                    }
                    catch (Exception e) {
                        LogUtil.printAndLogError((Throwable)e);
                    }
                }
            }
            ++n2;
        }
    }

    public static FolderEntity importWebElementFolder(FolderEntity folder, FolderEntity parentFolder) throws Exception {
        folder.setParentFolder(parentFolder);
        String newName = EntityService.getInstance().getAvailableName(parentFolder.getLocation(), folder.getName(), false);
        if (!newName.equals(folder.getName())) {
            folder.setName(newName);
        }
        folder.setProject(parentFolder.getProject());
        PathValidationUtil.validatePathLength((FileEntity)folder);
        EntityService.getInstance().saveEntity((FileEntity)folder);
        return folder;
    }

    public static WebElementEntity importWebElement(WebElementEntity webElement, FolderEntity parentFolder) throws Exception {
        webElement.setParentFolder(parentFolder);
        String newName = EntityService.getInstance().getAvailableName(parentFolder.getLocation(), webElement.getName(), true);
        if (!newName.equals(webElement.getName())) {
            webElement.setName(newName);
        }
        PathValidationUtil.validatePathLength((FileEntity)webElement);
        EntityService.getInstance().saveEntity((FileEntity)webElement);
        return webElement;
    }

    public static WebElementPropertyEntity getRefElementProperty(WebElementEntity webElement) {
        for (WebElementPropertyEntity webElementProperty : webElement.getWebElementProperties()) {
            if (!webElementProperty.getName().equalsIgnoreCase("ref_element")) continue;
            return webElementProperty;
        }
        return null;
    }

    public static WebServiceRequestEntity addNewRequest(FolderEntity parentFolder, WebServiceRequestEntity request) throws Exception {
        if (parentFolder != null) {
            if (request == null) {
                request = new WebServiceRequestEntity();
            }
            if (request.getName() == null || request.getName().equals("")) {
                String name = WebElementFileServiceManager.getAvailableWebElementName(parentFolder, StringConstants.MNG_NEW_REQUEST);
                request.setName(name);
            }
            request.setParentFolder(parentFolder);
            request.setProject(parentFolder.getProject());
            PathValidationUtil.validatePathLength((FileEntity)request);
            EntityService.getInstance().saveEntity((FileEntity)request);
            return request;
        }
        return null;
    }

    public static Map<String, File> getObjectRepositoryLookup() {
        return objectRepositoryLookup;
    }

    public static WebElementEntity getWebElementByScriptName(String scriptName, ProjectEntity projectEntity) throws Exception {
        FolderEntity objectRepoRootFolder = FolderFileServiceManager.getObjectRepositoryRoot(projectEntity);
        for (WebElementEntity webEleEntity : FolderFileServiceManager.getDescendantObjectRepository(objectRepoRootFolder)) {
            String fileName;
            File objectRepoScript = WebElementFileServiceManager.getObjectRepositoryLookup().get(webEleEntity.getName());
            if (objectRepoScript == null || !scriptName.equals(fileName = FilenameUtils.getBaseName((String)objectRepoScript.getAbsolutePath()))) continue;
            return webEleEntity;
        }
        return null;
    }

    private static void updateTestCaseFileReferences(String oldTestObjectLocationId, String newTestObjectId, ProjectEntity project) throws Exception {
        FolderEntity testCaseRoot = FolderFileServiceManager.getTestCaseRoot(project);
        File projectFile = new File(project.getLocation());
        String oldRelativeTdLocation = oldTestObjectLocationId.substring(projectFile.getParent().length() + 1);
        String oldTestObjectId = FilenameUtils.removeExtension((String)oldRelativeTdLocation).replace(File.separator, "/");
        String taskName = "Find test cases to rename test object ref";
        ExecutionTimeTracker.getInstance().start(taskName);
        List<TestCaseEntity> lstTestCase = FolderFileServiceManager.getDescendantTestCasesOfFolder(testCaseRoot);
        ExecutionTimeTracker.getInstance().stop(taskName);
        for (TestCaseEntity testCaseEntity : lstTestCase) {
            boolean needToUpdateTestCase = false;
            for (TestCaseTestDataLink testDataLink : testCaseEntity.getTestDataLinks()) {
                String testDataId = testDataLink.getTestDataId();
                if (testDataId == null || !oldTestObjectId.equals(testDataId)) continue;
                testDataLink.setTestDataId(newTestObjectId);
                needToUpdateTestCase = true;
            }
            String oldEntityValue = "findTestObject('" + oldTestObjectId + "')";
            String oldRelativeValue = "findTestObject('" + WebElementFileServiceManager.getRelativeId(oldTestObjectId) + "')";
            for (VariableEntity variable : testCaseEntity.getVariables()) {
                String defaultValue = variable.getDefaultValue();
                if (StringUtils.isBlank((String)defaultValue)) continue;
                boolean updated = false;
                if (defaultValue.contains(oldEntityValue)) {
                    defaultValue = defaultValue.replace(oldTestObjectId, newTestObjectId);
                    updated = true;
                }
                if (defaultValue.contains(oldRelativeValue)) {
                    defaultValue = defaultValue.replace(WebElementFileServiceManager.getRelativeId(oldTestObjectId), newTestObjectId);
                    updated = true;
                }
                if (!updated) continue;
                variable.setDefaultValue(defaultValue);
                needToUpdateTestCase = true;
            }
            if (!needToUpdateTestCase) continue;
            TestCaseFileServiceManager.updateTestCase(testCaseEntity);
        }
    }

    private static String getRelativeId(String s) {
        int firstSeparatorIdx = s.indexOf("/");
        if (firstSeparatorIdx < 0) {
            return s;
        }
        return s.substring(firstSeparatorIdx + 1, s.length());
    }
}

