/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.strategies;

import com.kms.katalon.dal.fileservice.strategies.IEntitySaveStrategy;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.util.collections.Pair;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.xml.bind.Marshaller;
import org.apache.commons.lang.StringUtils;

public class TextReplacementEntitySaveStrategy
implements IEntitySaveStrategy {
    private List<Pair<String, String>> replacements;

    public TextReplacementEntitySaveStrategy(List<Pair<String, String>> replacements) {
        this.replacements = replacements;
    }

    @Override
    public void save(FileEntity entity, String filePath, Marshaller marshaller) throws Exception {
        Path path = Paths.get(filePath, new String[0]);
        Charset charset = Charset.forName("UTF-8");
        String content = Files.readString(path, charset);
        for (Pair<String, String> pair : this.replacements) {
            content = StringUtils.replace((String)content, (String)((String)pair.getLeft()), (String)((String)pair.getRight()));
        }
        Files.writeString(path, (CharSequence)content, charset, new OpenOption[0]);
    }
}

