/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.StepDefinitionReporter;
import cucumber.api.TypeRegistryConfigurer;
import cucumber.api.event.TestRunFinished;
import cucumber.runner.EventBus;
import cucumber.runner.Runner;
import cucumber.runner.TimeService;
import cucumber.runtime.Backend;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.DefaultTypeRegistryConfiguration;
import cucumber.runtime.ExitStatus;
import cucumber.runtime.Glue;
import cucumber.runtime.LinePredicate;
import cucumber.runtime.NamePredicate;
import cucumber.runtime.PicklePredicate;
import cucumber.runtime.Reflections;
import cucumber.runtime.RuntimeGlue;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.TagPredicate;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.CucumberFeature;
import gherkin.events.PickleEvent;
import gherkin.pickles.Compiler;
import gherkin.pickles.Pickle;
import io.cucumber.stepexpression.TypeRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Runtime {
    private final ExitStatus exitStatus = new ExitStatus();
    private final RuntimeOptions runtimeOptions;
    private final ResourceLoader resourceLoader;
    private final ClassLoader classLoader;
    private final Runner runner;
    private final List<PicklePredicate> filters;
    private final EventBus bus;
    private final Compiler compiler = new Compiler();

    public Runtime(ResourceLoader resourceLoader, ClassFinder classFinder, ClassLoader classLoader, RuntimeOptions runtimeOptions) {
        this(resourceLoader, classLoader, Runtime.loadBackends(resourceLoader, classFinder, runtimeOptions), runtimeOptions);
    }

    public Runtime(ResourceLoader resourceLoader, ClassLoader classLoader, Collection<? extends Backend> backends, RuntimeOptions runtimeOptions) {
        this(resourceLoader, classLoader, backends, runtimeOptions, TimeService.SYSTEM, null);
    }

    public Runtime(ResourceLoader resourceLoader, ClassLoader classLoader, Collection<? extends Backend> backends, RuntimeOptions runtimeOptions, Glue optionalGlue) {
        this(resourceLoader, classLoader, backends, runtimeOptions, TimeService.SYSTEM, optionalGlue);
    }

    public Runtime(ResourceLoader resourceLoader, ClassLoader classLoader, Collection<? extends Backend> backends, RuntimeOptions runtimeOptions, TimeService stopWatch, Glue optionalGlue) {
        Map<String, List<Long>> lineFilters;
        List<Pattern> nameFilters;
        if (backends.isEmpty()) {
            throw new CucumberException("No backends were found. Please make sure you have a backend module on your CLASSPATH.");
        }
        this.resourceLoader = resourceLoader;
        this.classLoader = classLoader;
        this.runtimeOptions = runtimeOptions;
        Glue glue = optionalGlue == null ? new RuntimeGlue() : optionalGlue;
        this.bus = new EventBus(stopWatch);
        this.runner = new Runner(glue, this.bus, backends, runtimeOptions);
        this.filters = new ArrayList<PicklePredicate>();
        List<String> tagFilters = runtimeOptions.getTagFilters();
        if (!tagFilters.isEmpty()) {
            this.filters.add(new TagPredicate(tagFilters));
        }
        if (!(nameFilters = runtimeOptions.getNameFilters()).isEmpty()) {
            this.filters.add(new NamePredicate(nameFilters));
        }
        if (!(lineFilters = runtimeOptions.getLineFilters(resourceLoader)).isEmpty()) {
            this.filters.add(new LinePredicate(lineFilters));
        }
        this.exitStatus.setEventPublisher(this.bus);
        runtimeOptions.setEventBus(this.bus);
    }

    private static Collection<? extends Backend> loadBackends(ResourceLoader resourceLoader, ClassFinder classFinder, RuntimeOptions runtimeOptions) {
        Reflections reflections = new Reflections(classFinder);
        TypeRegistryConfigurer typeRegistryConfigurer = reflections.instantiateExactlyOneSubclass(TypeRegistryConfigurer.class, MultiLoader.packageName(runtimeOptions.getGlue()), new Class[0], new Object[0], new DefaultTypeRegistryConfiguration());
        TypeRegistry typeRegistry = new TypeRegistry(typeRegistryConfigurer.locale());
        typeRegistryConfigurer.configureTypeRegistry(typeRegistry);
        return reflections.instantiateSubclasses(Backend.class, Collections.singletonList("cucumber.runtime"), new Class[]{ResourceLoader.class, TypeRegistry.class}, new Object[]{resourceLoader, typeRegistry});
    }

    public void run() {
        List<CucumberFeature> features = this.runtimeOptions.cucumberFeatures(this.resourceLoader, this.bus);
        StepDefinitionReporter stepDefinitionReporter = this.runtimeOptions.stepDefinitionReporter(this.classLoader);
        this.reportStepDefinitions(stepDefinitionReporter);
        for (CucumberFeature cucumberFeature : features) {
            this.runFeature(cucumberFeature);
        }
        this.bus.send(new TestRunFinished(this.bus.getTime()));
    }

    public void reportStepDefinitions(StepDefinitionReporter stepDefinitionReporter) {
        this.runner.reportStepDefinitions(stepDefinitionReporter);
    }

    public void runFeature(CucumberFeature feature) {
        List<PickleEvent> pickleEvents = this.compileFeature(feature);
        for (PickleEvent pickleEvent : pickleEvents) {
            if (!this.matchesFilters(pickleEvent)) continue;
            this.runner.runPickle(pickleEvent);
        }
    }

    public List<PickleEvent> compileFeature(CucumberFeature feature) {
        ArrayList<PickleEvent> pickleEvents = new ArrayList<PickleEvent>();
        for (Pickle pickle : this.compiler.compile(feature.getGherkinFeature())) {
            pickleEvents.add(new PickleEvent(feature.getUri(), pickle));
        }
        return pickleEvents;
    }

    public boolean matchesFilters(PickleEvent pickleEvent) {
        for (PicklePredicate filter : this.filters) {
            if (filter.apply(pickleEvent)) continue;
            return false;
        }
        return true;
    }

    public byte exitStatus() {
        return this.exitStatus.exitStatus(this.runtimeOptions.isStrict());
    }

    public Glue getGlue() {
        return this.runner.getGlue();
    }

    public EventBus getEventBus() {
        return this.bus;
    }

    public Runner getRunner() {
        return this.runner;
    }
}

