/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.windows.driver;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.selenium.remote.http.ConfiguredHttpClientFactory;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.windows.driver.WindowsDesiredCapsBuilder;
import com.kms.katalon.core.windows.driver.WindowsSession;
import com.kms.katalon.core.windows.keyword.helper.WindowsActionHelper;
import com.kms.katalon.core.windows.keyword.helper.WindowsShortcut;
import com.kms.katalon.core.windows.model.StringMatchingStrategy;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.remote.AppiumCommandExecutor;
import io.appium.java_client.windows.WindowsDriver;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.http.HttpClient;

public class WindowsDriverFactory {
    private static final int DEFAULT_CONNECT_TIMEOUT_IN_SECONDS = 120;
    private static final int DEFAULT_READ_TIMEOUT_IN_SECONDS = 10800;
    private static final int DEFAULT_WRITE_TIMEOUT_IN_SECONDS = 0;
    private static KeywordLogger logger = KeywordLogger.getInstance(WindowsDriverFactory.class);
    public static final String DESIRED_CAPABILITIES_PROPERTY = "desiredCapabilities";
    @Deprecated
    public static final String WIN_APP_DRIVER_PROPERTY = "winAppDriverUrl";
    public static final String FLAUI_DRIVER_PROPERTY = "desktopDriverUrl";
    private static WindowsSession windowsSession;

    public static WindowsDriver getWindowsDriver() {
        return windowsSession.getRunningDriver();
    }

    public static WindowsSession getWindowsSession() {
        return windowsSession;
    }

    public static WindowsDriver startApplication(String appFile, String appTitle) throws IOException, URISyntaxException, InterruptedException {
        return WindowsDriverFactory.startApplication(appFile, appTitle, null);
    }

    public static WindowsDriver startApplication(String appFile, String appTitle, StringMatchingStrategy strategy) throws IOException, URISyntaxException, InterruptedException {
        ProxyInformation proxyInfo = RunConfiguration.getProxyInformation();
        HashMap userConfigProperties = RunConfiguration.getDriverPreferencesProperties((String)"Windows");
        if (userConfigProperties == null) {
            userConfigProperties = new HashMap();
        }
        String driverUrlString = (String)userConfigProperties.get(FLAUI_DRIVER_PROPERTY);
        URL driverUrl = new URL(driverUrlString);
        logger.logInfo(String.format("Starting application %s on machine at address %s", appFile, driverUrl.toString()));
        logger.logRunData(FLAUI_DRIVER_PROPERTY, driverUrl.toString());
        WindowsDesiredCapsBuilder capsBuilder = new WindowsDesiredCapsBuilder();
        Object desiredCapabilitiesAsObject = userConfigProperties.getOrDefault(DESIRED_CAPABILITIES_PROPERTY, null);
        if (desiredCapabilitiesAsObject instanceof Map) {
            capsBuilder.merge((Map<String, Object>)desiredCapabilitiesAsObject);
        }
        DesiredCapabilities desiredCapabilities = capsBuilder.build();
        logger.logRunData(DESIRED_CAPABILITIES_PROPERTY, JsonUtil.toJson((Object)desiredCapabilities.toJson(), (boolean)false));
        WindowsDriver windowsDriver = WindowsDriverFactory.startApplication(driverUrl, appFile, desiredCapabilities, proxyInfo, appTitle, strategy).getRunningDriver();
        windowsDriver.manage().timeouts().implicitlyWait(Duration.ofSeconds(RunConfiguration.getElementTimeoutForWindows()));
        return windowsDriver;
    }

    public static WindowsSession startApplication(URL remoteAddressURL, String appFile, DesiredCapabilities initCapabilities, ProxyInformation proxyInfo, String appTitle, StringMatchingStrategy strategy) throws IOException, URISyntaxException, InterruptedException {
        WindowsDesiredCapsBuilder capsBuilder = new WindowsDesiredCapsBuilder();
        String finalAppFile = appFile;
        try {
            if (WindowsShortcut.isShortcutFilePath(appFile)) {
                try {
                    WindowsShortcut shortcut = WindowsShortcut.from(appFile);
                    finalAppFile = shortcut.getRealFilename();
                    capsBuilder.withAppArguments(shortcut.getCommandLineArguments()).withAppWorkingDir(shortcut.getWorkingDirectory());
                }
                catch (IOException | ParseException error) {
                    logger.logWarning(MessageFormat.format("Failed to read the shortcut file \"{0}\": {1}", appFile, error.getMessage()));
                }
            }
            try {
                capsBuilder.withAppWorkingDir(new File(finalAppFile).getParentFile().getCanonicalPath());
            }
            catch (Throwable throwable) {}
            DesiredCapabilities desiredCapabilities = capsBuilder.withApp(finalAppFile).merge(initCapabilities).build();
            windowsSession = new WindowsSession(remoteAddressURL, finalAppFile, initCapabilities, proxyInfo, appTitle, strategy);
            windowsSession.setApplicationDriver(WindowsDriverFactory.newWindowsDriver(remoteAddressURL, desiredCapabilities, proxyInfo));
            return windowsSession;
        }
        catch (WebDriverException e) {
            if (StringUtils.isEmpty((CharSequence)appTitle)) {
                throw e;
            }
            if (!(e instanceof NoSuchWindowException) && !(e instanceof SessionNotCreatedException)) {
                throw e;
            }
            if (e.getMessage() != null && e.getMessage().contains("The system cannot find the file specified")) {
                throw e;
            }
            if ("Root".equals(appFile)) {
                throw e;
            }
            try {
                Thread.sleep(1000L);
                WindowsDriver foundDriver = WindowsDriverFactory.switchToWindowTitle(appTitle, strategy);
                if (foundDriver != null) {
                    return windowsSession;
                }
            }
            catch (Exception secondTryEx) {
                logger.logWarning(MessageFormat.format("Failed to re-attempt to switch to window with title = \"{0}\": {1}", appTitle, secondTryEx.getMessage()));
            }
            throw e;
        }
    }

    public static WindowsDriver switchToWindowTitle(String title, StringMatchingStrategy strategy) throws IOException, URISyntaxException, InterruptedException {
        return new WindowsActionHelper(windowsSession).switchToWindowTitle(title, strategy);
    }

    public static WindowsDriver newWindowsDriver(URL remoteAddressURL, DesiredCapabilities desiredCapabilities, ProxyInformation proxyInfo) throws IOException, URISyntaxException {
        if (remoteAddressURL != null) {
            return new WindowsDriver((HttpCommandExecutor)WindowsDriverFactory.getAppiumExecutorForRemoteDriver(remoteAddressURL, proxyInfo, (MutableCapabilities)desiredCapabilities), (Capabilities)desiredCapabilities);
        }
        return new WindowsDriver((Capabilities)desiredCapabilities);
    }

    public static AppiumCommandExecutor getAppiumExecutorForRemoteDriver(URL remoteWebServerUrl, ProxyInformation proxyInfo, MutableCapabilities capabilities) throws IOException, URISyntaxException {
        ConfiguredHttpClientFactory clientFactory = ConfiguredHttpClientFactory.of((ProxyInformation)proxyInfo, (URL)remoteWebServerUrl, (Capabilities)capabilities);
        AppiumCommandExecutor executor = new AppiumCommandExecutor(MobileCommand.commandRepository, remoteWebServerUrl, (HttpClient.Factory)clientFactory);
        return executor;
    }
}

