/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColumnViewerUtil;
import com.kms.katalon.composer.testcase.ast.dialogs.IAstDialogBuilder;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.editors.TypeSelectionDialogCellEditor;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.AnnotationNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.MethodNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ParameterWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BlockStatementWrapper;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.core.annotation.SetUp;
import com.kms.katalon.core.annotation.TearDown;
import com.kms.katalon.core.annotation.TearDownIfError;
import com.kms.katalon.core.annotation.TearDownIfFailed;
import com.kms.katalon.core.annotation.TearDownIfPassed;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MethodObjectBuilderDialog
extends Dialog
implements IAstDialogBuilder {
    private static final String NEW_PARAM_DEFAULT_NAME = "param";
    private MethodObjectBuilderDialog _instance;
    private Text returnTypeText;
    private Text methodNameText;
    private TableViewer tableViewer;
    private Button btnSetup;
    private Button btnTearDown;
    private Button btnTearDownIfFailed;
    private Button btnTearDownIfError;
    private Button btnTearDownIfPassed;
    private ClassNodeWrapper returnTypeNode;
    private String methodName;
    private List<ParameterWrapper> parameterList = new ArrayList<ParameterWrapper>();
    private int modifiers;
    private List<ClassNodeWrapper> exceptionList = new ArrayList<ClassNodeWrapper>();
    private BlockStatementWrapper code;
    private boolean isSetup;
    private boolean isTearDown;
    private boolean isTearDownIfFailed;
    private boolean isTearDownIfError;
    private boolean isTearDownIfPassed;
    private MethodNodeWrapper tempMethod = null;
    static final Collator englishCollator = Collator.getInstance(Locale.ENGLISH);
    static final String[] keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};

    public MethodObjectBuilderDialog(Shell parentShell, MethodNodeWrapper methodNode, ASTNodeWrapper parent) {
        super(parentShell);
        this.initData(methodNode, parent);
        this._instance = this;
    }

    protected void initData(MethodNodeWrapper methodNode, ASTNodeWrapper parent) {
        if (methodNode == null) {
            this.tempMethod = new MethodNodeWrapper(parent);
            return;
        }
        this.tempMethod = methodNode.clone();
        this.methodName = methodNode.getName();
        this.returnTypeNode = methodNode.getReturnType();
        ASTNodeWrapper[] aSTNodeWrapperArray = methodNode.getParameters();
        int n = aSTNodeWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterWrapper parameter = aSTNodeWrapperArray[n2];
            this.parameterList.add(parameter);
            ++n2;
        }
        this.modifiers = methodNode.getModifiers();
        aSTNodeWrapperArray = methodNode.getExceptions();
        n = aSTNodeWrapperArray.length;
        n2 = 0;
        while (n2 < n) {
            ASTNodeWrapper exceptionNode = aSTNodeWrapperArray[n2];
            this.exceptionList.add((ClassNodeWrapper)exceptionNode);
            ++n2;
        }
        this.code = methodNode.getBlock();
        this.isSetup = methodNode.getAnnotationByClass(SetUp.class) != null;
        this.isTearDown = methodNode.getAnnotationByClass(TearDown.class) != null;
        this.isTearDownIfFailed = methodNode.getAnnotationByClass(TearDownIfFailed.class) != null;
        this.isTearDownIfError = methodNode.getAnnotationByClass(TearDownIfError.class) != null;
        this.isTearDownIfPassed = methodNode.getAnnotationByClass(TearDownIfPassed.class) != null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createInfoComposite(container);
        this.createTableComposite(container);
        this.refresh();
        return container;
    }

    private void createInfoComposite(Composite container) {
        Composite infoComposite = new Composite(container, 0);
        infoComposite.setLayout((Layout)new GridLayout(2, false));
        infoComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.createNameComposite(infoComposite);
        Composite returnTypeComposite = this.addReturnTypeComposite(infoComposite);
        new Label(returnTypeComposite, 0);
        new Label(infoComposite, 0);
        this.btnTearDownIfPassed = new Button(infoComposite, 32);
        GridData gd_btnCheckButton = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnCheckButton.horizontalIndent = 5;
        this.btnTearDownIfPassed.setLayoutData((Object)gd_btnCheckButton);
        this.btnTearDownIfPassed.setText(ComposerTestcaseMessageConstants.PA_LBL_TEAR_DOWN_PASSED_BUTTON);
        this.btnTearDownIfPassed.setSelection(this.isTearDownIfPassed);
        this.btnTearDownIfPassed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodObjectBuilderDialog.this.isTearDownIfPassed = MethodObjectBuilderDialog.this.btnTearDownIfPassed.getSelection();
            }
        });
    }

    private Composite addReturnTypeComposite(Composite parent) {
        Composite returnTypeComposite = new Composite(parent, 0);
        GridData returnTypeGridData = new GridData(4, 4, true, true, 1, 1);
        returnTypeGridData.minimumWidth = 250;
        returnTypeComposite.setLayoutData((Object)returnTypeGridData);
        GridLayout returnTypeGridLayout = new GridLayout(3, false);
        returnTypeGridLayout.verticalSpacing = 20;
        returnTypeComposite.setLayout((Layout)returnTypeGridLayout);
        Label returnTypeLabel = new Label(returnTypeComposite, 0);
        returnTypeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        returnTypeLabel.setText(ComposerTestcaseMessageConstants.PA_LBL_RETURN_TYPE);
        this.returnTypeText = new Text(returnTypeComposite, 2048);
        GridData gd_returnTypeText = new GridData(4, 0x1000000, true, true, 1, 1);
        gd_returnTypeText.heightHint = 20;
        this.returnTypeText.setEditable(false);
        this.returnTypeText.setLayoutData((Object)gd_returnTypeText);
        Button returnTypeBrowseButton = new Button(returnTypeComposite, 0);
        returnTypeBrowseButton.setText(ComposerTestcaseMessageConstants.PA_LBL_RETURN_TYPE_BROWSE_BUTTON);
        GridData gd_returnTypeBrowseButton = new GridData(4, 0x1000000, false, true, 1, 1);
        gd_returnTypeBrowseButton.minimumWidth = 100;
        gd_returnTypeBrowseButton.widthHint = 30;
        returnTypeBrowseButton.setLayoutData((Object)gd_returnTypeBrowseButton);
        returnTypeBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenTypeSelectionDialog dialog = new OpenTypeSelectionDialog(Display.getCurrent().getActiveShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), null, 0);
                dialog.setTitle(JavaUIMessages.OpenTypeAction_dialogTitle);
                dialog.setMessage(JavaUIMessages.OpenTypeAction_dialogMessage);
                if (MethodObjectBuilderDialog.this.returnTypeNode != null) {
                    dialog.setInitialPattern(MethodObjectBuilderDialog.this.returnTypeNode.getName());
                }
                if (dialog.open() != 0 || dialog.getResult().length != 1 || !(dialog.getResult()[0] instanceof IType)) {
                    return;
                }
                Class<?> newClass = MethodObjectBuilderDialog.this.getClassFromIType((IType)dialog.getResult()[0]);
                if (newClass != null) {
                    MethodObjectBuilderDialog.this.returnTypeNode = new ClassNodeWrapper(newClass, (ASTNodeWrapper)MethodObjectBuilderDialog.this.tempMethod);
                    MethodObjectBuilderDialog.this.refresh();
                }
            }
        });
        this.btnTearDownIfFailed = new Button(returnTypeComposite, 32);
        this.btnTearDownIfFailed.setText(ComposerTestcaseMessageConstants.PA_LBL_TEAR_DOWN_FAILED_BUTTON);
        this.btnTearDownIfFailed.setSelection(this.isTearDownIfFailed);
        this.btnTearDownIfFailed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodObjectBuilderDialog.this.isTearDownIfFailed = MethodObjectBuilderDialog.this.btnTearDownIfFailed.getSelection();
            }
        });
        this.btnTearDownIfError = new Button(returnTypeComposite, 32);
        this.btnTearDownIfError.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.btnTearDownIfError.setText(ComposerTestcaseMessageConstants.PA_LBL_TEAR_DOWN_ERROR_BUTTON);
        this.btnTearDownIfError.setSelection(this.isTearDownIfError);
        this.btnTearDownIfError.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodObjectBuilderDialog.this.isTearDownIfError = MethodObjectBuilderDialog.this.btnTearDownIfError.getSelection();
            }
        });
        return returnTypeComposite;
    }

    private void createNameComposite(Composite parent) {
        Composite nameComposite = new Composite(parent, 0);
        GridData namGridData = new GridData(4, 4, true, true, 1, 1);
        namGridData.minimumWidth = 250;
        nameComposite.setLayoutData((Object)namGridData);
        GridLayout nameGridLayout = new GridLayout(2, false);
        nameGridLayout.verticalSpacing = 20;
        nameComposite.setLayout((Layout)nameGridLayout);
        Label methodNameLabel = new Label(nameComposite, 0);
        methodNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        methodNameLabel.setText(GlobalMessageConstants.NAME);
        this.methodNameText = new Text(nameComposite, 2048);
        GridData methodNameGridData = new GridData(4, 0x1000000, true, true, 1, 1);
        methodNameGridData.heightHint = 20;
        this.methodNameText.setLayoutData((Object)methodNameGridData);
        this.methodNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MethodObjectBuilderDialog.this.methodName = MethodObjectBuilderDialog.this.methodNameText.getText();
            }
        });
        this.btnSetup = new Button(nameComposite, 32);
        this.btnSetup.setText(ComposerTestcaseMessageConstants.PA_LBL_SET_UP_BUTTON);
        this.btnSetup.setSelection(this.isSetup);
        this.btnSetup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodObjectBuilderDialog.this.isSetup = MethodObjectBuilderDialog.this.btnSetup.getSelection();
            }
        });
        this.btnTearDown = new Button(nameComposite, 32);
        this.btnTearDown.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.btnTearDown.setText(ComposerTestcaseMessageConstants.PA_LBL_TEAR_DOWN_BUTTON);
        this.btnTearDown.setSelection(this.isTearDown);
        this.btnTearDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodObjectBuilderDialog.this.isTearDown = MethodObjectBuilderDialog.this.btnTearDown.getSelection();
            }
        });
    }

    protected Class<?> getClassFromIType(IType type) {
        return AstKeywordsInputUtil.loadType(type.getFullyQualifiedName(), this.tempMethod.getScriptClass());
    }

    protected void createTableComposite(Composite container) {
        Composite tableComposite = new Composite(container, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        tableComposite.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = new TableViewer(tableComposite, 67586);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        table.setHeaderVisible(true);
        ColumnViewerUtil.setTableActivation((TableViewer)this.tableViewer);
        this.addTableColumns();
    }

    private void addTableColumns() {
        this.addTableColumnParamType();
        this.addTableColumnParamName();
    }

    private void addTableColumnParamName() {
        TableViewerColumn tableViewerColumnParamName = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnParamName.getColumn().setText(ComposerTestcaseMessageConstants.DIA_COL_PARAM_NAME);
        tableViewerColumnParamName.getColumn().setWidth(335);
        tableViewerColumnParamName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ParameterWrapper) {
                    ParameterWrapper parameter = (ParameterWrapper)element;
                    return parameter.getName();
                }
                return "";
            }
        });
        tableViewerColumnParamName.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                ParameterWrapper oldParameterWrapper;
                int parameterIndex;
                if (element instanceof ParameterWrapper && value instanceof String && (parameterIndex = MethodObjectBuilderDialog.this.parameterList.indexOf(oldParameterWrapper = (ParameterWrapper)element)) >= 0 && parameterIndex < MethodObjectBuilderDialog.this.parameterList.size()) {
                    MethodObjectBuilderDialog.this.parameterList.set(parameterIndex, new ParameterWrapper(oldParameterWrapper.getType().getTypeClass(), (String)value, MethodObjectBuilderDialog.this.tempMethod));
                    MethodObjectBuilderDialog.this.refresh();
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof ParameterWrapper) {
                    return ((ParameterWrapper)element).getName();
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)MethodObjectBuilderDialog.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return element instanceof ParameterWrapper;
            }
        });
    }

    private void addTableColumnParamType() {
        TableViewerColumn tableViewerColumnParamType = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnParamType.getColumn().setText(ComposerTestcaseMessageConstants.DIA_COL_PARAM_TYPE);
        tableViewerColumnParamType.getColumn().setWidth(335);
        tableViewerColumnParamType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ParameterWrapper) {
                    ParameterWrapper parameter = (ParameterWrapper)element;
                    return parameter.getType().getName();
                }
                return "";
            }
        });
        tableViewerColumnParamType.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                Class<?> newClass;
                ParameterWrapper oldParameterWrapper;
                int parameterIndex;
                if (element instanceof ParameterWrapper && value instanceof IType && (parameterIndex = MethodObjectBuilderDialog.this.parameterList.indexOf(oldParameterWrapper = (ParameterWrapper)element)) >= 0 && parameterIndex < MethodObjectBuilderDialog.this.parameterList.size() && (newClass = MethodObjectBuilderDialog.this.getClassFromIType((IType)value)) != null) {
                    MethodObjectBuilderDialog.this.parameterList.set(parameterIndex, new ParameterWrapper(newClass, oldParameterWrapper.getName(), MethodObjectBuilderDialog.this.tempMethod));
                    MethodObjectBuilderDialog.this.refresh();
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof ParameterWrapper) {
                    return ((ParameterWrapper)element).getType().getName();
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof ParameterWrapper) {
                    return new TypeSelectionDialogCellEditor((Composite)MethodObjectBuilderDialog.this.tableViewer.getTable(), ((ParameterWrapper)element).getType().getName());
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof ParameterWrapper;
            }
        });
    }

    public void refresh() {
        this.methodNameText.setText(this.methodName != null ? this.methodName : "");
        this.returnTypeText.setText(this.returnTypeNode != null ? this.returnTypeNode.getName() : "");
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.parameterList);
        this.tableViewer.refresh();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createInsertButton(parent);
        this.createRemoveButton(parent);
        this.createOKButton(parent);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void createOKButton(Composite parent) {
        Button btnOK = this.createButton(parent, 102, IDialogConstants.OK_LABEL, true);
        btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MethodObjectBuilderDialog.this.verify()) {
                    MethodObjectBuilderDialog.this._instance.close();
                }
            }
        });
    }

    private void createRemoveButton(Composite parent) {
        Button btnRemove = this.createButton(parent, 200, GlobalMessageConstants.DELETE, false);
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<ParameterWrapper> removeParameterWrappers = new ArrayList<ParameterWrapper>();
                int[] nArray = MethodObjectBuilderDialog.this.tableViewer.getTable().getSelectionIndices();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    if (index >= 0 && index < MethodObjectBuilderDialog.this.parameterList.size()) {
                        removeParameterWrappers.add(MethodObjectBuilderDialog.this.parameterList.get(index));
                    }
                    ++n2;
                }
                for (ParameterWrapper parameter : removeParameterWrappers) {
                    MethodObjectBuilderDialog.this.parameterList.remove(parameter);
                }
                MethodObjectBuilderDialog.this.tableViewer.refresh();
            }
        });
    }

    private void createInsertButton(Composite parent) {
        Button btnInsert = this.createButton(parent, 100, GlobalMessageConstants.INSERT, true);
        btnInsert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = MethodObjectBuilderDialog.this.tableViewer.getTable().getSelectionIndex();
                ParameterWrapper parameter = new ParameterWrapper(Object.class, MethodObjectBuilderDialog.NEW_PARAM_DEFAULT_NAME, MethodObjectBuilderDialog.this.tempMethod);
                if (selectionIndex < 0 || selectionIndex >= MethodObjectBuilderDialog.this.parameterList.size()) {
                    MethodObjectBuilderDialog.this.parameterList.add(parameter);
                } else {
                    MethodObjectBuilderDialog.this.parameterList.add(selectionIndex + 1, parameter);
                }
                MethodObjectBuilderDialog.this.tableViewer.refresh();
                MethodObjectBuilderDialog.this.tableViewer.getTable().setSelection(selectionIndex + 1);
            }
        });
    }

    protected boolean verify() {
        if (this.methodName == null || this.methodName.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)GlobalMessageConstants.ERROR, (String)ComposerTestcaseMessageConstants.DIA_ERROR_METHOD_NAME_EMPTY);
            return false;
        }
        if (MethodObjectBuilderDialog.isJavaKeyword(this.methodName)) {
            MessageDialog.openError((Shell)this.getShell(), (String)GlobalMessageConstants.ERROR, (String)MessageFormat.format(ComposerTestcaseMessageConstants.DIA_ERROR_METHOD_NAME_X_INVALID_JAVA_KEYWORD, this.methodName));
            return false;
        }
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogTitle());
    }

    @Override
    public MethodNodeWrapper getReturnValue() {
        this.tempMethod.setName(this.methodName);
        this.tempMethod.setModifiers(this.modifiers);
        this.tempMethod.setReturnType(this.returnTypeNode != null ? this.returnTypeNode : new ClassNodeWrapper(Object.class, (ASTNodeWrapper)this.tempMethod));
        this.tempMethod.setParameters(this.parameterList.toArray(new ParameterWrapper[this.parameterList.size()]));
        this.tempMethod.setExceptions(this.exceptionList.toArray(new ClassNodeWrapper[this.exceptionList.size()]));
        this.tempMethod.setBlock(this.code != null ? this.code : this.tempMethod.getBlock());
        MethodObjectBuilderDialog.processAnnotation(this.tempMethod, this.isSetup, SetUp.class);
        MethodObjectBuilderDialog.processAnnotation(this.tempMethod, this.isTearDown, TearDown.class);
        MethodObjectBuilderDialog.processAnnotation(this.tempMethod, this.isTearDownIfFailed, TearDownIfFailed.class);
        MethodObjectBuilderDialog.processAnnotation(this.tempMethod, this.isTearDownIfError, TearDownIfError.class);
        MethodObjectBuilderDialog.processAnnotation(this.tempMethod, this.isTearDownIfPassed, TearDownIfPassed.class);
        return this.tempMethod;
    }

    private static void processAnnotation(MethodNodeWrapper method, boolean toogleValue, Class<?> annotationClass) {
        if (toogleValue && method.getAnnotationByClass(annotationClass) == null) {
            method.addAnnotation(new AnnotationNodeWrapper(annotationClass, (ASTNodeWrapper)method));
        } else if (!toogleValue && method.getAnnotationByClass(annotationClass) != null) {
            method.removeAnnotation(method.getAnnotationByClass(annotationClass));
        }
    }

    protected Point getInitialSize() {
        return new Point(700, 500);
    }

    private static boolean isJavaKeyword(String keyword) {
        return Arrays.binarySearch(keywords, keyword, englishCollator) >= 0;
    }

    public String getDialogTitle() {
        return ComposerTestcaseMessageConstants.DIA_TITLE_METHOD_BUILDER;
    }
}

