/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.editors;

import com.kms.katalon.composer.components.dialogs.ApplyingEditingValue;
import com.kms.katalon.composer.testcase.editors.NumberCellEditor;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import org.codehaus.groovy.syntax.Numbers;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class NumberConstantCellEditor
extends NumberCellEditor
implements ApplyingEditingValue {
    private Composite parent;
    private ConstantExpressionWrapper constantExpression;

    public NumberConstantCellEditor(Composite parent) {
        super(parent);
        this.parent = parent;
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData data = super.getLayoutData();
        if (this.parent instanceof Table) {
            data.minimumHeight = ((Table)this.parent).getItemHeight();
            data.verticalAlignment = 128;
        }
        return data;
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((value instanceof ConstantExpressionWrapper && ((ConstantExpressionWrapper)value).getValue() instanceof Number ? 1 : 0) != 0);
        this.constantExpression = ((ConstantExpressionWrapper)value).clone();
        super.doSetValue((Object)String.valueOf(((ConstantExpressionWrapper)value).getValue()));
    }

    protected ConstantExpressionWrapper doGetValue() {
        String stringResult = (String)super.doGetValue();
        if (stringResult == null || stringResult.isEmpty()) {
            return null;
        }
        Number numValue = 0;
        try {
            numValue = Numbers.parseInteger((String)stringResult);
        }
        catch (NumberFormatException numberFormatException) {
            numValue = Numbers.parseDecimal((String)stringResult);
        }
        this.constantExpression.setValue(numValue);
        return this.constantExpression;
    }

    public void applyEditingValue() {
        this.fireApplyEditorValue();
    }
}

