/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.treetable;

import com.kms.katalon.composer.testcase.ast.editors.MethodObjectBuilderCellEditor;
import com.kms.katalon.composer.testcase.ast.treetable.AstAbstractTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.IAstItemEditableNode;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.MethodNodeWrapper;
import com.kms.katalon.composer.testcase.util.WrapperToAstTreeConverter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class AstMethodTreeTableNode
extends AstAbstractTreeTableNode
implements IAstItemEditableNode {
    private MethodNodeWrapper methodNode;
    private List<AstTreeTableNode> childNodes = new ArrayList<AstTreeTableNode>();

    public AstMethodTreeTableNode(MethodNodeWrapper methodNode, AstTreeTableNode parentNode) {
        super(parentNode);
        this.methodNode = methodNode;
        this.reloadChildren();
    }

    @Override
    public MethodNodeWrapper getASTObject() {
        return this.methodNode;
    }

    @Override
    public String getItemText() {
        return this.methodNode.getText();
    }

    @Override
    public boolean canHaveChildren() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return !this.childNodes.isEmpty();
    }

    @Override
    public void reloadChildren() {
        this.childNodes.clear();
        this.childNodes.addAll(WrapperToAstTreeConverter.getInstance().convert(this.methodNode.getBlock().getStatements(), this));
    }

    @Override
    public Image getIcon() {
        return ImageConstants.IMG_16_FUNCTION;
    }

    @Override
    public boolean canEditItem() {
        return true;
    }

    @Override
    public Object getItem() {
        return this.methodNode;
    }

    @Override
    public CellEditor getCellEditorForItem(Composite parent) {
        return new MethodObjectBuilderCellEditor(parent, this.methodNode.getText(), this.methodNode.getParent());
    }

    @Override
    public boolean setItem(Object item) {
        if (!(item instanceof MethodNodeWrapper)) {
            return false;
        }
        MethodNodeWrapper newMethodNode = (MethodNodeWrapper)item;
        this.methodNode.setName(newMethodNode.getName());
        this.methodNode.setModifiers(newMethodNode.getModifiers());
        this.methodNode.setParameters(newMethodNode.getParameters());
        this.methodNode.setReturnType(newMethodNode.getReturnType());
        this.methodNode.setExceptions(newMethodNode.getExceptions());
        this.methodNode.setAnnotations(newMethodNode.getAnnotations());
        return true;
    }

    @Override
    public List<AstTreeTableNode> getChildren() {
        return this.childNodes;
    }

    @Override
    public boolean isChildAssignble(ASTNodeWrapper astNode) {
        return this.methodNode.isChildAssignble(astNode);
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject) {
        return this.methodNode.addChild(childObject);
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject, int index) {
        return this.methodNode.addChild(childObject, index);
    }

    @Override
    public boolean removeChild(ASTNodeWrapper childObject) {
        return this.methodNode.removeChild(childObject);
    }

    @Override
    public int indexOf(ASTNodeWrapper childObject) {
        return this.methodNode.indexOf(childObject);
    }
}

