/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.dialogs;

import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class TestCaseSelectionDialog
extends TreeEntitySelectionDialog {
    private List<TestCaseTreeEntity> selectedTestCases = new ArrayList<TestCaseTreeEntity>();

    public TestCaseSelectionDialog(Shell parent) {
        super(parent, (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new EntityProvider(), (AbstractEntityViewerFilter)new EntityViewerFilter(new EntityProvider()));
        this.setAllowMultiple(false);
        this.setDoubleClickSelects(false);
        this.populateEntities();
    }

    protected TestCaseSelectionDialog(Shell parent, IEntityLabelProvider entityLabelProvider, ITreeContentProvider entityProvider, AbstractEntityViewerFilter viewerFilter) {
        super(parent, entityLabelProvider, entityProvider, viewerFilter);
        this.setAllowMultiple(false);
        this.setDoubleClickSelects(false);
        this.populateEntities();
    }

    private void populateEntities() {
        try {
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            FolderEntity testCaseFolderRoot = FolderController.getInstance().getTestCaseRoot(project);
            FolderTreeEntity testCaseFolderTreeRoot = new FolderTreeEntity(testCaseFolderRoot, null, false);
            this.setInput(Arrays.asList(testCaseFolderTreeRoot));
        }
        catch (ControllerException e) {
            ExceptionUtil.throwUnchecked((Exception)((Object)e));
        }
    }

    public TreeViewer createTreeViewer(Composite parent) {
        final ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)super.createTreeViewer(parent);
        treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 32) {
                    return;
                }
                TreeItem item = (TreeItem)e.item;
                treeViewer.getTree().setSelection(item);
                TestCaseSelectionDialog.this.onStateChangedTreeItem(item.getData(), item.getChecked());
            }
        });
        return treeViewer;
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new ContainerCheckedTreeViewer(new Tree(parent, 0x20 | style));
    }

    protected void onStateChangedTreeItem(Object element, boolean isChecked) {
        if (element instanceof TestCaseTreeEntity) {
            TestCaseTreeEntity testCaseTreeEntity = (TestCaseTreeEntity)element;
            if (isChecked) {
                this.selectedTestCases.add(testCaseTreeEntity);
            } else {
                this.selectedTestCases.remove(testCaseTreeEntity);
            }
        } else if (element instanceof FolderTreeEntity) {
            try {
                ITreeEntity[] iTreeEntityArray = TreeEntityUtil.getChildren((FolderTreeEntity)((FolderTreeEntity)element));
                int n = iTreeEntityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITreeEntity childElement = iTreeEntityArray[n2];
                    this.onStateChangedTreeItem(childElement, isChecked);
                    ++n2;
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    protected void computeResult() {
        ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)this.getTreeViewer();
        List<Object> grayedItems = Arrays.asList(treeViewer.getGrayedElements());
        this.selectedTestCases.removeAll(grayedItems);
        this.setResult(this.selectedTestCases);
    }

    public List<TestCaseTreeEntity> getSelectedTestCases() throws Exception {
        List<TestCaseTreeEntity> selectedTreeEntities = this.flattenDialogResult(this.getResult());
        return selectedTreeEntities;
    }

    protected List<TestCaseTreeEntity> flattenDialogResult(Object[] dialogResult) throws Exception {
        if (dialogResult == null) {
            return Collections.emptyList();
        }
        ArrayList<TestCaseTreeEntity> selectedTreeEntities = new ArrayList<TestCaseTreeEntity>();
        Object[] objectArray = dialogResult;
        int n = dialogResult.length;
        int n2 = 0;
        while (n2 < n) {
            Object eachResult = objectArray[n2];
            if (eachResult instanceof TestCaseTreeEntity) {
                selectedTreeEntities.add((TestCaseTreeEntity)eachResult);
            } else if (eachResult instanceof FolderTreeEntity) {
                selectedTreeEntities.addAll(this.flattenDialogResult(((FolderTreeEntity)eachResult).getChildren()));
            }
            ++n2;
        }
        return selectedTreeEntities;
    }
}

