/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast;

import com.kms.katalon.composer.testcase.groovy.ast.ASTHasBlock;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.AnnonatedNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ParameterWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BlockStatementWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.stmt.BlockStatement;

public class MethodNodeWrapper
extends AnnonatedNodeWrapper
implements ASTHasBlock {
    private BlockStatementWrapper code;
    private String name;
    private int modifiers;
    private ClassNodeWrapper returnType;
    private ParameterWrapper[] parameters;
    private ClassNodeWrapper[] exceptions;

    public MethodNodeWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.name = "";
        this.modifiers = 1;
        this.returnType = new ClassNodeWrapper(Void.class, parentNodeWrapper);
        this.parameters = new ParameterWrapper[0];
        this.code = new BlockStatementWrapper(this);
    }

    public MethodNodeWrapper(MethodNodeWrapper methodNodeWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(methodNodeWrapper, parentNodeWrapper);
        this.name = methodNodeWrapper.getName();
        this.modifiers = methodNodeWrapper.getModifiers();
        this.returnType = new ClassNodeWrapper(methodNodeWrapper.getReturnType(), (ASTNodeWrapper)this);
        this.parameters = new ParameterWrapper[methodNodeWrapper.getParameters().length];
        int index = 0;
        while (index < this.parameters.length) {
            this.parameters[index] = new ParameterWrapper(methodNodeWrapper.getParameters()[index], (ASTNodeWrapper)this);
            ++index;
        }
        this.exceptions = new ClassNodeWrapper[methodNodeWrapper.getExceptions().length];
        index = 0;
        while (index < methodNodeWrapper.getExceptions().length) {
            this.exceptions[index] = new ClassNodeWrapper(methodNodeWrapper.getExceptions()[index], (ASTNodeWrapper)this);
            ++index;
        }
        this.code = new BlockStatementWrapper(methodNodeWrapper.getBlock(), (ASTNodeWrapper)this);
    }

    public MethodNodeWrapper(MethodNode methodNode, ASTNodeWrapper parentNodeWrapper) {
        super((AnnotatedNode)methodNode, parentNodeWrapper);
        this.code = methodNode.getCode() instanceof BlockStatement ? new BlockStatementWrapper((BlockStatement)methodNode.getCode(), (ASTNodeWrapper)this) : new BlockStatementWrapper(this);
        this.name = methodNode.getName();
        this.modifiers = methodNode.getModifiers();
        this.returnType = ClassNodeWrapper.getClassWrapper(methodNode.getReturnType(), this);
        this.parameters = new ParameterWrapper[methodNode.getParameters().length];
        int index = 0;
        while (index < this.parameters.length) {
            this.parameters[index] = new ParameterWrapper(methodNode.getParameters()[index], (ASTNodeWrapper)this);
            ++index;
        }
        this.exceptions = new ClassNodeWrapper[methodNode.getExceptions().length];
        index = 0;
        while (index < methodNode.getExceptions().length) {
            this.exceptions[index] = ClassNodeWrapper.getClassWrapper(methodNode.getExceptions()[index], this);
            ++index;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public ClassNodeWrapper getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ClassNodeWrapper returnType) {
        if (returnType == null) {
            return;
        }
        returnType.setParent(this);
        this.returnType = returnType;
    }

    public ParameterWrapper[] getParameters() {
        return this.parameters;
    }

    public void setParameters(ParameterWrapper[] parameters) {
        if (parameters == null) {
            return;
        }
        ParameterWrapper[] parameterWrapperArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterWrapper parameter = parameterWrapperArray[n2];
            parameter.setParent(this);
            ++n2;
        }
        this.parameters = parameters;
    }

    public ClassNodeWrapper[] getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(ClassNodeWrapper[] exceptions) {
        if (exceptions == null) {
            return;
        }
        ClassNodeWrapper[] classNodeWrapperArray = exceptions;
        int n = exceptions.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNodeWrapper exception = classNodeWrapperArray[n2];
            exception.setParent(this);
            ++n2;
        }
        this.exceptions = exceptions;
    }

    @Override
    public BlockStatementWrapper getBlock() {
        return this.code;
    }

    public void setBlock(BlockStatementWrapper block) {
        if (block == null) {
            return;
        }
        block.setParent(this);
        this.code = block;
    }

    @Override
    public String getText() {
        return this.name + "()";
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<? extends ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.addAll(super.getAstChildren());
        ParameterWrapper[] parameterWrapperArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterWrapper parameter = parameterWrapperArray[n2];
            astNodeWrappers.add(parameter);
            ++n2;
        }
        astNodeWrappers.add(this.code);
        return astNodeWrappers;
    }

    @Override
    public MethodNodeWrapper clone() {
        return new MethodNodeWrapper(this, this.getParent());
    }

    @Override
    public boolean isChildAssignble(ASTNodeWrapper astNode) {
        return this.getBlock().isChildAssignble(astNode);
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject) {
        return this.getBlock().addChild(childObject);
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject, int index) {
        return this.getBlock().addChild(childObject, index);
    }

    @Override
    public boolean removeChild(ASTNodeWrapper childObject) {
        return this.getBlock().removeChild(childObject);
    }

    @Override
    public boolean replaceChild(ASTNodeWrapper oldChild, ASTNodeWrapper newChild) {
        return this.getBlock().replaceChild(oldChild, newChild);
    }

    @Override
    public int indexOf(ASTNodeWrapper childObject) {
        return this.getBlock().indexOf(childObject);
    }
}

