/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.AnnonatedNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.expr.Expression;

public abstract class ExpressionWrapper
extends AnnonatedNodeWrapper {
    protected ClassNodeWrapper type;

    public ExpressionWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.type = ClassNodeWrapper.getClassWrapper(ClassHelper.DYNAMIC_TYPE, this);
    }

    public ExpressionWrapper(ExpressionWrapper expressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(expressionWrapper, parentNodeWrapper);
        this.type = new ClassNodeWrapper(expressionWrapper.getType(), (ASTNodeWrapper)this);
    }

    public ExpressionWrapper(Expression expression, ASTNodeWrapper parentNodeWrapper) {
        super((AnnotatedNode)expression, parentNodeWrapper);
        this.type = ClassNodeWrapper.getClassWrapper(expression.getType(), this);
    }

    @Override
    public boolean hasAstChildren() {
        return false;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        return new ArrayList();
    }

    public ClassNodeWrapper getType() {
        return this.type;
    }

    public void setType(ClassNodeWrapper type) {
        if (type == null) {
            return;
        }
        type.setParent(this);
        this.type = type;
    }

    public void setType(Class<?> typeClass) {
        ScriptNodeWrapper scriptClass = this.getScriptClass();
        if (scriptClass != null) {
            this.getScriptClass().addImport(typeClass);
        }
        this.setType(ClassNodeWrapper.getClassWrapper(ClassHelper.make(typeClass), this));
    }

    @Override
    public abstract ExpressionWrapper clone();

    @Override
    public ExpressionWrapper copy(ASTNodeWrapper newParent) {
        return (ExpressionWrapper)super.copy(newParent);
    }

    @Override
    public String getInputText() {
        return this.getText();
    }

    public Class<?> resolveType(ClassLoader classLoader) {
        Class<?> foundClass = this.loadClassQuietly(this.getType().getName(), classLoader);
        if (foundClass != null) {
            return foundClass;
        }
        return null;
    }

    protected final Class<?> loadClassQuietly(String className, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return AstKeywordsInputUtil.loadClassFromImportedPackage(className, classLoader);
        }
    }
}

