/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;

public class StaticMethodCallExpressionWrapper
extends ExpressionWrapper {
    private ClassNodeWrapper ownerType;
    private String method;
    private ExpressionWrapper arguments;

    public StaticMethodCallExpressionWrapper(Class<?> ownerType, String method, ExpressionWrapper arguments, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.ownerType = new ClassNodeWrapper(ownerType, (ASTNodeWrapper)this);
        this.method = method;
        this.arguments = arguments;
    }

    public StaticMethodCallExpressionWrapper(StaticMethodCallExpression staticMethodCallExpression, ASTNodeWrapper parentNodeWrapper) {
        super((Expression)staticMethodCallExpression, parentNodeWrapper);
        this.ownerType = ClassNodeWrapper.getClassWrapper(staticMethodCallExpression.getOwnerType(), this);
        this.method = staticMethodCallExpression.getMethod();
        this.arguments = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(staticMethodCallExpression.getArguments(), this);
    }

    public StaticMethodCallExpressionWrapper(StaticMethodCallExpressionWrapper staticMethodCallExpressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(staticMethodCallExpressionWrapper, parentNodeWrapper);
        this.ownerType = new ClassNodeWrapper(staticMethodCallExpressionWrapper.getOwnerType(), (ASTNodeWrapper)this);
        this.method = staticMethodCallExpressionWrapper.getMethod();
        this.arguments = staticMethodCallExpressionWrapper.getArguments().copy(this);
    }

    public ClassNodeWrapper getOwnerType() {
        return this.ownerType;
    }

    public String getMethod() {
        return this.method;
    }

    public ExpressionWrapper getArguments() {
        return this.arguments;
    }

    public void setArguments(ExpressionWrapper arguments) {
        this.arguments = arguments;
    }

    @Override
    public String getText() {
        return this.getOwnerType().getName() + "." + this.method + this.arguments.getText();
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    public List<ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.ownerType);
        astNodeWrappers.add(this.arguments);
        return astNodeWrappers;
    }

    @Override
    public StaticMethodCallExpressionWrapper clone() {
        return new StaticMethodCallExpressionWrapper(this, this.getParent());
    }
}

