/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.statements;

import com.kms.katalon.composer.testcase.groovy.ast.ASTHasBlock;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BlockStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.CatchStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ComplexStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.FinallyStatementWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;

public class TryCatchStatementWrapper
extends ComplexStatementWrapper<CatchStatementWrapper, FinallyStatementWrapper>
implements ASTHasBlock {
    private BlockStatementWrapper block;

    public TryCatchStatementWrapper() {
        this(null);
    }

    public TryCatchStatementWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.block = new BlockStatementWrapper(this);
        this.lastStatement = new FinallyStatementWrapper(this);
    }

    public TryCatchStatementWrapper(TryCatchStatement tryCatchStatement, ASTNodeWrapper parentNodeWrapper) {
        super((Statement)tryCatchStatement, parentNodeWrapper);
        this.block = new BlockStatementWrapper((BlockStatement)tryCatchStatement.getTryStatement(), (ASTNodeWrapper)this);
        for (CatchStatement catchStatement : tryCatchStatement.getCatchStatements()) {
            this.complexChildStatements.add(new CatchStatementWrapper(catchStatement, this));
        }
        if (!(tryCatchStatement.getFinallyStatement() instanceof BlockStatement)) {
            return;
        }
        BlockStatement blockStatement = (BlockStatement)tryCatchStatement.getFinallyStatement();
        if (blockStatement.getStatements().size() == 1 && blockStatement.getStatements().get(0) instanceof BlockStatement) {
            this.lastStatement = new FinallyStatementWrapper((BlockStatement)blockStatement.getStatements().get(0), this);
        }
    }

    public TryCatchStatementWrapper(TryCatchStatementWrapper tryCatchStatementWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(tryCatchStatementWrapper, parentNodeWrapper);
        this.block = new BlockStatementWrapper(tryCatchStatementWrapper.getBlock(), (ASTNodeWrapper)this);
    }

    @Override
    public String getText() {
        return "try";
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.block);
        astNodeWrappers.addAll(super.getAstChildren());
        return astNodeWrappers;
    }

    @Override
    public BlockStatementWrapper getBlock() {
        return this.block;
    }

    @Override
    public TryCatchStatementWrapper clone() {
        return new TryCatchStatementWrapper(this, this.getParent());
    }

    @Override
    public boolean isChildAssignble(ASTNodeWrapper nodeWrapper) {
        return nodeWrapper instanceof CatchStatementWrapper || nodeWrapper instanceof FinallyStatementWrapper || this.getBlock().isChildAssignble(nodeWrapper);
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject) {
        if (childObject instanceof CatchStatementWrapper) {
            this.addComplexChildStatement((CatchStatementWrapper)childObject);
            return true;
        }
        if (childObject instanceof FinallyStatementWrapper) {
            return this.setLastStatement((FinallyStatementWrapper)childObject);
        }
        return this.getBlock().addChild(childObject);
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject, int index) {
        if (childObject instanceof CatchStatementWrapper) {
            return this.addComplexChildStatement((CatchStatementWrapper)childObject, index);
        }
        if (childObject instanceof FinallyStatementWrapper) {
            return this.setLastStatement((FinallyStatementWrapper)childObject);
        }
        return this.getBlock().addChild(childObject, index);
    }

    @Override
    public boolean removeChild(ASTNodeWrapper childObject) {
        if (childObject instanceof CatchStatementWrapper) {
            return this.removeComplexChildStatement((CatchStatementWrapper)childObject);
        }
        if (childObject == this.lastStatement) {
            return this.removeLastStatement();
        }
        return this.getBlock().removeChild(childObject);
    }

    @Override
    public int indexOf(ASTNodeWrapper childObject) {
        if (childObject instanceof CatchStatementWrapper) {
            return this.indexOf((CatchStatementWrapper)childObject);
        }
        if (childObject == this.lastStatement) {
            return 0;
        }
        return this.getBlock().indexOf(childObject);
    }
}

