/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.handlers;

import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.parts.TestCaseDataBindingPart;
import com.kms.katalon.composer.testcase.parts.TestCaseIntegrationPart;
import com.kms.katalon.composer.testcase.parts.TestCasePart;
import com.kms.katalon.composer.testcase.parts.TestCasePropertiesPart;
import com.kms.katalon.composer.testcase.parts.TestCaseVariableEditorPart;
import com.kms.katalon.composer.testcase.parts.TestCaseVariablePart;
import com.kms.katalon.composer.testcase.preferences.TestCasePreferenceDefaultValueInitializer;
import com.kms.katalon.composer.util.groovy.GroovyEditorUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.internal.workbench.PartServiceImpl;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenTestCaseHandler {
    private static final String DEFAULT_CONTAINER_DATA = ComposerTestcaseMessageConstants.HAND_DEFAULT_CONTAINER_DATA;
    private static final String TEST_CASE_BUNDLE_URI = "bundleclass://com.kms.katalon.composer.testcase/";
    private static final String TEST_CASE_GENERAL_PART_URI = "bundleclass://com.kms.katalon.composer.testcase/" + TestCasePart.class.getName();
    private static final String TEST_CASE_VARIABLES_PART_URI = "bundleclass://com.kms.katalon.composer.testcase/" + TestCaseVariablePart.class.getName();
    private static final String TEST_CASE_VARIABLE_EDITOR_PART_URI = "bundleclass://com.kms.katalon.composer.testcase/" + TestCaseVariableEditorPart.class.getName();
    private static final String TEST_CASE_DATA_BINDING_PART_URI = "bundleclass://com.kms.katalon.composer.testcase/" + TestCaseDataBindingPart.class.getName();
    private static final String TEST_CASE_COMPOSITE_PART_URI = "bundleclass://com.kms.katalon.composer.testcase/" + TestCaseCompositePart.class.getName();
    private static final String TEST_CASE_INTEGRATION_PART_URI = "bundleclass://com.kms.katalon.composer.testcase/" + TestCaseIntegrationPart.class.getName();
    private static final String TEST_CASE_PROPERTIES_PART_URI = "bundleclass://com.kms.katalon.composer.testcase/" + TestCasePropertiesPart.class.getName();
    @Inject
    private MApplication application;
    @Inject
    private static EModelService modelService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IEclipseContext context;
    private static OpenTestCaseHandler instance;

    public static OpenTestCaseHandler getInstance() {
        return instance;
    }

    @PostConstruct
    public void registerEventHandler() {
        instance = this;
        this.eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof TestCaseEntity) {
                    OpenTestCaseHandler.this.openTestCase((TestCaseEntity)object);
                }
            }
        });
    }

    @Inject
    @Optional
    public MCompositePart openTestCase(@UIEventTopic(value="TESTCASE/OPEN") TestCaseEntity entity) {
        EPartService partService = (EPartService)this.context.getActive(EPartService.class);
        if (partService == null) {
            partService = (EPartService)this.context.getActive(PartServiceImpl.class);
        }
        return this.execute(entity, partService);
    }

    public void openTestCaseInDataBindingView(TestCaseEntity entity) {
        TestCaseCompositePart testCaseParentCompositePart = (TestCaseCompositePart)this.openTestCase(entity).getObject();
        testCaseParentCompositePart.setVariablesAndDataBindingTab();
    }

    private MCompositePart execute(TestCaseEntity testCaseEntity, EPartService partService) {
        MCompositePart testCaseCompositePart = null;
        try {
            if (testCaseEntity != null) {
                MPartStack stack = (MPartStack)modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
                String defaultTestCaseView = TestCasePreferenceDefaultValueInitializer.getTestCasePartStartView();
                if (stack != null) {
                    String tcPropertiesPartId;
                    MPart tcPropertiesPart;
                    String testCaseIntegrationPartId;
                    MPart testCaseIntegrationPart;
                    String testCaseDataBindingId;
                    MPart testCaseDataBindingPart;
                    String testCaseVariableEditorPartId;
                    MPart testCaseVariableEditorPart;
                    String testCaseVariablesPartId;
                    MPart testCaseVariablesPart;
                    String testCaseEditorId;
                    MPart editorPart;
                    String testCasePartId;
                    MPart testCasePart;
                    String subPartStackId;
                    MPartStack subPartStack;
                    String testCaseCompositePartId = EntityPartUtil.getTestCaseCompositePartId((String)testCaseEntity.getId());
                    testCaseCompositePart = (MCompositePart)modelService.find(testCaseCompositePartId, (MUIElement)stack);
                    if (testCaseCompositePart != null) {
                        partService.activate((MPart)testCaseCompositePart, true);
                        Trackings.trackOpenTestCase((String)defaultTestCaseView);
                        return testCaseCompositePart;
                    }
                    if (testCaseCompositePart == null) {
                        testCaseCompositePart = (MCompositePart)modelService.createModelElement(MCompositePart.class);
                        testCaseCompositePart.setElementId(testCaseCompositePartId);
                        testCaseCompositePart.setLabel(testCaseEntity.getName());
                        testCaseCompositePart.setCloseable(true);
                        testCaseCompositePart.setContributionURI(TEST_CASE_COMPOSITE_PART_URI);
                        testCaseCompositePart.setContainerData(DEFAULT_CONTAINER_DATA);
                        testCaseCompositePart.setIconURI(ImageConstants.URL_16_TEST_CASE);
                        testCaseCompositePart.setObject((Object)testCaseEntity);
                        testCaseCompositePart.setTooltip(testCaseEntity.getIdForDisplay());
                        stack.getChildren().add(testCaseCompositePart);
                    }
                    if ((subPartStack = (MPartStack)modelService.find(subPartStackId = testCaseCompositePartId + ".partStack", (MUIElement)testCaseCompositePart)) == null) {
                        subPartStack = (MPartStack)modelService.createModelElement(MPartStack.class);
                        subPartStack.setElementId(subPartStackId);
                        subPartStack.setContainerData(DEFAULT_CONTAINER_DATA);
                        testCaseCompositePart.getChildren().add(subPartStack);
                    }
                    if ((testCasePart = (MPart)modelService.find(testCasePartId = testCaseCompositePartId + ".partStack.testCasePart", (MUIElement)subPartStack)) == null) {
                        testCasePart = (MPart)modelService.createModelElement(MPart.class);
                        testCasePart.setElementId(testCasePartId);
                        testCasePart.setContributionURI(TEST_CASE_GENERAL_PART_URI);
                        testCasePart.setContainerData(DEFAULT_CONTAINER_DATA);
                        testCasePart.getTags().add("NoMove");
                        this.context.set(TestCaseEntity.class, (Object)testCaseEntity);
                        subPartStack.getChildren().add(testCasePart);
                        subPartStack.setSelectedElement((MUIElement)testCasePart);
                    }
                    if ((editorPart = (MPart)modelService.find(testCaseEditorId = testCaseCompositePartId + ".partStack.editor", (MUIElement)subPartStack)) == null) {
                        editorPart = GroovyEditorUtil.createTestCaseEditorPart((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile(GroovyUtil.getOrCreateGroovyScriptForTestCaseFromPlugin((TestCaseEntity)testCaseEntity).getPath()), (MPartStack)subPartStack, (String)testCaseEditorId, (EPartService)partService, (int)1);
                    }
                    if ((testCaseVariablesPart = (MPart)modelService.find(testCaseVariablesPartId = testCaseCompositePartId + ".partStack.variables", (MUIElement)subPartStack)) == null) {
                        testCaseVariablesPart = (MPart)modelService.createModelElement(MPart.class);
                        testCaseVariablesPart.setElementId(testCaseVariablesPartId);
                        testCaseVariablesPart.setContributionURI(TEST_CASE_VARIABLES_PART_URI);
                        testCaseVariablesPart.setContainerData(DEFAULT_CONTAINER_DATA);
                        testCaseVariablesPart.getTags().add("NoMove");
                        this.context.set(TestCaseEntity.class, (Object)testCaseEntity);
                        subPartStack.getChildren().add(testCaseVariablesPart);
                    }
                    if ((testCaseVariableEditorPart = (MPart)modelService.find(testCaseVariableEditorPartId = testCaseCompositePartId + ".partStack.variableEditor", (MUIElement)subPartStack)) == null) {
                        testCaseVariableEditorPart = (MPart)modelService.createModelElement(MPart.class);
                        testCaseVariableEditorPart.setElementId(testCaseVariableEditorPartId);
                        testCaseVariableEditorPart.setContributionURI(TEST_CASE_VARIABLE_EDITOR_PART_URI);
                        testCaseVariableEditorPart.setContainerData(DEFAULT_CONTAINER_DATA);
                        testCaseVariableEditorPart.getTags().add("NoMove");
                        this.context.set(TestCaseEntity.class, (Object)testCaseEntity);
                        subPartStack.getChildren().add(testCaseVariableEditorPart);
                    }
                    if ((testCaseDataBindingPart = (MPart)modelService.find(testCaseDataBindingId = testCaseCompositePartId + ".partStack.dataBinding", (MUIElement)subPartStack)) == null) {
                        testCaseDataBindingPart = (MPart)modelService.createModelElement(MPart.class);
                        testCaseDataBindingPart.setElementId(testCaseDataBindingId);
                        testCaseDataBindingPart.setContributionURI(TEST_CASE_DATA_BINDING_PART_URI);
                        testCaseDataBindingPart.setContainerData(DEFAULT_CONTAINER_DATA);
                        testCaseDataBindingPart.getTags().add("NoMove");
                        this.context.set(TestCaseEntity.class, (Object)testCaseEntity);
                        subPartStack.getChildren().add(testCaseDataBindingPart);
                    }
                    if ((testCaseIntegrationPart = (MPart)modelService.find(testCaseIntegrationPartId = testCaseCompositePartId + ".partStack.integration", (MUIElement)subPartStack)) == null) {
                        testCaseIntegrationPart = (MPart)modelService.createModelElement(MPart.class);
                        testCaseIntegrationPart.setElementId(testCaseIntegrationPartId);
                        testCaseIntegrationPart.setContributionURI(TEST_CASE_INTEGRATION_PART_URI);
                        testCaseIntegrationPart.setContainerData(DEFAULT_CONTAINER_DATA);
                        testCaseIntegrationPart.getTags().add("NoMove");
                        this.context.set(TestCaseEntity.class, (Object)testCaseEntity);
                        subPartStack.getChildren().add(testCaseIntegrationPart);
                    }
                    if ((tcPropertiesPart = (MPart)modelService.find(tcPropertiesPartId = testCaseCompositePartId + ".partStack.properties", (MUIElement)subPartStack)) == null) {
                        tcPropertiesPart = (MPart)modelService.createModelElement(MPart.class);
                        tcPropertiesPart.setElementId(tcPropertiesPartId);
                        tcPropertiesPart.setContributionURI(TEST_CASE_PROPERTIES_PART_URI);
                        tcPropertiesPart.setContainerData(DEFAULT_CONTAINER_DATA);
                        tcPropertiesPart.getTags().add("NoMove");
                        this.context.set(TestCaseEntity.class, (Object)testCaseEntity);
                        subPartStack.getChildren().add(tcPropertiesPart);
                    }
                    partService.activate(editorPart);
                    partService.activate((MPart)testCaseCompositePart);
                    partService.activate(testCaseVariablesPart);
                    partService.activate(testCaseVariableEditorPart);
                    partService.activate(testCaseDataBindingPart);
                    partService.activate(testCaseIntegrationPart);
                    partService.activate(tcPropertiesPart);
                    partService.activate(testCasePart);
                    if (ComposerTestcaseMessageConstants.PA_TAB_SCRIPT.equals(defaultTestCaseView)) {
                        partService.activate(editorPart);
                    }
                    stack.setSelectedElement((MUIElement)testCaseCompositePart);
                    TestCaseCompositePart testCaseParentCompositePart = (TestCaseCompositePart)testCaseCompositePart.getObject();
                    if (!testCaseParentCompositePart.isInitialized()) {
                        testCaseParentCompositePart.initComponent();
                    } else {
                        testCaseParentCompositePart.initDefaultSelectedPart();
                    }
                    ((CompatibilityEditor)editorPart.getObject()).getEditor().addPropertyListener(testCaseParentCompositePart.getChildPropertyListner());
                    Trackings.trackOpenTestCase((String)defaultTestCaseView);
                }
            }
        }
        catch (Exception e) {
            if (testCaseCompositePart != null && testCaseCompositePart.isVisible()) {
                partService.hidePart(testCaseCompositePart, true);
            }
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)GlobalMessageConstants.ERROR, (String)ComposerTestcaseMessageConstants.HAND_ERROR_MSG_CANNOT_OPEN_TEST_CASE);
        }
        return testCaseCompositePart;
    }
}

