/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.keywords;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.keywords.IKeywordBrowserTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserFolderTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserTreeEntity;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.core.annotation.Keyword;
import com.kms.katalon.custom.keyword.KeywordMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuiltinKeywordFolderBrowserTreeEntity
extends KeywordBrowserFolderTreeEntity {
    private static final long serialVersionUID = 1L;
    private String className;
    private String simpleName;
    private String label;

    public BuiltinKeywordFolderBrowserTreeEntity(String className, String simpleName, String label, IKeywordBrowserTreeEntity parent) {
        super(simpleName, parent);
        this.className = className;
        this.setSimpleName(simpleName);
        this.label = label;
    }

    @Override
    public boolean hasChildren() {
        try {
            if (KeywordController.getInstance().getBuiltInKeywords(this.simpleName).size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return false;
    }

    @Override
    public Object[] getChildren() {
        try {
            return this.getKeywordByKeywordObject().toArray();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    private List<IKeywordBrowserTreeEntity> getKeywordByKeywordObject() throws Exception {
        List allKeywordMethod = KeywordController.getInstance().getBuiltInKeywords(this.simpleName, true);
        HashMap<String, ArrayList<KeywordMethod>> methodObjectMap = new HashMap<String, ArrayList<KeywordMethod>>();
        for (KeywordMethod method : allKeywordMethod) {
            Keyword keywordParameter = method.getKeywordAnnotation();
            if (keywordParameter == null) continue;
            ArrayList<KeywordMethod> methodList = (ArrayList<KeywordMethod>)methodObjectMap.get(keywordParameter.keywordObject());
            if (methodList == null) {
                methodList = new ArrayList<KeywordMethod>();
                methodObjectMap.put(keywordParameter.keywordObject(), methodList);
            }
            methodList.add(method);
        }
        ArrayList<IKeywordBrowserTreeEntity> childTreeEntityList = new ArrayList<IKeywordBrowserTreeEntity>();
        for (Map.Entry pair : methodObjectMap.entrySet()) {
            KeywordBrowserFolderTreeEntity keywordFolder = new KeywordBrowserFolderTreeEntity((String)pair.getKey(), this);
            for (KeywordMethod method : (List)pair.getValue()) {
                keywordFolder.children.add(new KeywordBrowserTreeEntity(this.className, this.simpleName, method.getName(), false, keywordFolder));
            }
            childTreeEntityList.add(keywordFolder);
        }
        Collections.sort(childTreeEntityList, new Comparator<IKeywordBrowserTreeEntity>(){

            @Override
            public int compare(IKeywordBrowserTreeEntity o1, IKeywordBrowserTreeEntity o2) {
                if (o1 != null && o2 != null) {
                    return o1.getName().compareTo(o2.getName());
                }
                return 0;
            }
        });
        return childTreeEntityList;
    }

    @Override
    public String getName() {
        return this.label;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }
}

